// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.eventgrid;

import com.azure.core.credential.TokenCredential;
import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.HttpPipelinePosition;
import com.azure.core.http.policy.AddDatePolicy;
import com.azure.core.http.policy.AddHeadersFromContextPolicy;
import com.azure.core.http.policy.BearerTokenAuthenticationPolicy;
import com.azure.core.http.policy.HttpLogOptions;
import com.azure.core.http.policy.HttpLoggingPolicy;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.HttpPolicyProviders;
import com.azure.core.http.policy.RequestIdPolicy;
import com.azure.core.http.policy.RetryOptions;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.management.profile.AzureProfile;
import com.azure.core.util.Configuration;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.eventgrid.fluent.EventGridManagementClient;
import com.azure.resourcemanager.eventgrid.implementation.CaCertificatesImpl;
import com.azure.resourcemanager.eventgrid.implementation.ChannelsImpl;
import com.azure.resourcemanager.eventgrid.implementation.ClientGroupsImpl;
import com.azure.resourcemanager.eventgrid.implementation.ClientsImpl;
import com.azure.resourcemanager.eventgrid.implementation.DomainEventSubscriptionsImpl;
import com.azure.resourcemanager.eventgrid.implementation.DomainTopicEventSubscriptionsImpl;
import com.azure.resourcemanager.eventgrid.implementation.DomainTopicsImpl;
import com.azure.resourcemanager.eventgrid.implementation.DomainsImpl;
import com.azure.resourcemanager.eventgrid.implementation.EventGridManagementClientBuilder;
import com.azure.resourcemanager.eventgrid.implementation.EventSubscriptionsImpl;
import com.azure.resourcemanager.eventgrid.implementation.ExtensionTopicsImpl;
import com.azure.resourcemanager.eventgrid.implementation.NamespaceTopicEventSubscriptionsImpl;
import com.azure.resourcemanager.eventgrid.implementation.NamespaceTopicsImpl;
import com.azure.resourcemanager.eventgrid.implementation.NamespacesImpl;
import com.azure.resourcemanager.eventgrid.implementation.OperationsImpl;
import com.azure.resourcemanager.eventgrid.implementation.PartnerConfigurationsImpl;
import com.azure.resourcemanager.eventgrid.implementation.PartnerNamespacesImpl;
import com.azure.resourcemanager.eventgrid.implementation.PartnerRegistrationsImpl;
import com.azure.resourcemanager.eventgrid.implementation.PartnerTopicEventSubscriptionsImpl;
import com.azure.resourcemanager.eventgrid.implementation.PartnerTopicsImpl;
import com.azure.resourcemanager.eventgrid.implementation.PermissionBindingsImpl;
import com.azure.resourcemanager.eventgrid.implementation.PrivateEndpointConnectionsImpl;
import com.azure.resourcemanager.eventgrid.implementation.PrivateLinkResourcesImpl;
import com.azure.resourcemanager.eventgrid.implementation.SystemTopicEventSubscriptionsImpl;
import com.azure.resourcemanager.eventgrid.implementation.SystemTopicsImpl;
import com.azure.resourcemanager.eventgrid.implementation.TopicEventSubscriptionsImpl;
import com.azure.resourcemanager.eventgrid.implementation.TopicSpacesImpl;
import com.azure.resourcemanager.eventgrid.implementation.TopicTypesImpl;
import com.azure.resourcemanager.eventgrid.implementation.TopicsImpl;
import com.azure.resourcemanager.eventgrid.implementation.VerifiedPartnersImpl;
import com.azure.resourcemanager.eventgrid.models.CaCertificates;
import com.azure.resourcemanager.eventgrid.models.Channels;
import com.azure.resourcemanager.eventgrid.models.ClientGroups;
import com.azure.resourcemanager.eventgrid.models.Clients;
import com.azure.resourcemanager.eventgrid.models.DomainEventSubscriptions;
import com.azure.resourcemanager.eventgrid.models.DomainTopicEventSubscriptions;
import com.azure.resourcemanager.eventgrid.models.DomainTopics;
import com.azure.resourcemanager.eventgrid.models.Domains;
import com.azure.resourcemanager.eventgrid.models.EventSubscriptions;
import com.azure.resourcemanager.eventgrid.models.ExtensionTopics;
import com.azure.resourcemanager.eventgrid.models.NamespaceTopicEventSubscriptions;
import com.azure.resourcemanager.eventgrid.models.NamespaceTopics;
import com.azure.resourcemanager.eventgrid.models.Namespaces;
import com.azure.resourcemanager.eventgrid.models.Operations;
import com.azure.resourcemanager.eventgrid.models.PartnerConfigurations;
import com.azure.resourcemanager.eventgrid.models.PartnerNamespaces;
import com.azure.resourcemanager.eventgrid.models.PartnerRegistrations;
import com.azure.resourcemanager.eventgrid.models.PartnerTopicEventSubscriptions;
import com.azure.resourcemanager.eventgrid.models.PartnerTopics;
import com.azure.resourcemanager.eventgrid.models.PermissionBindings;
import com.azure.resourcemanager.eventgrid.models.PrivateEndpointConnections;
import com.azure.resourcemanager.eventgrid.models.PrivateLinkResources;
import com.azure.resourcemanager.eventgrid.models.SystemTopicEventSubscriptions;
import com.azure.resourcemanager.eventgrid.models.SystemTopics;
import com.azure.resourcemanager.eventgrid.models.TopicEventSubscriptions;
import com.azure.resourcemanager.eventgrid.models.TopicSpaces;
import com.azure.resourcemanager.eventgrid.models.TopicTypes;
import com.azure.resourcemanager.eventgrid.models.Topics;
import com.azure.resourcemanager.eventgrid.models.VerifiedPartners;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * Entry point to EventGridManager.
 * Azure EventGrid Management Client.
 */
public final class EventGridManager {
    private CaCertificates caCertificates;

    private Channels channels;

    private ClientGroups clientGroups;

    private Clients clients;

    private Domains domains;

    private DomainTopics domainTopics;

    private TopicEventSubscriptions topicEventSubscriptions;

    private DomainEventSubscriptions domainEventSubscriptions;

    private NamespaceTopicEventSubscriptions namespaceTopicEventSubscriptions;

    private EventSubscriptions eventSubscriptions;

    private DomainTopicEventSubscriptions domainTopicEventSubscriptions;

    private SystemTopicEventSubscriptions systemTopicEventSubscriptions;

    private PartnerTopicEventSubscriptions partnerTopicEventSubscriptions;

    private Namespaces namespaces;

    private NamespaceTopics namespaceTopics;

    private Operations operations;

    private Topics topics;

    private PartnerConfigurations partnerConfigurations;

    private PartnerNamespaces partnerNamespaces;

    private PartnerRegistrations partnerRegistrations;

    private PartnerTopics partnerTopics;

    private PermissionBindings permissionBindings;

    private PrivateEndpointConnections privateEndpointConnections;

    private PrivateLinkResources privateLinkResources;

    private SystemTopics systemTopics;

    private ExtensionTopics extensionTopics;

    private TopicSpaces topicSpaces;

    private TopicTypes topicTypes;

    private VerifiedPartners verifiedPartners;

    private final EventGridManagementClient clientObject;

    private EventGridManager(HttpPipeline httpPipeline, AzureProfile profile, Duration defaultPollInterval) {
        Objects.requireNonNull(httpPipeline, "'httpPipeline' cannot be null.");
        Objects.requireNonNull(profile, "'profile' cannot be null.");
        this.clientObject = new EventGridManagementClientBuilder().pipeline(httpPipeline)
            .endpoint(profile.getEnvironment().getResourceManagerEndpoint())
            .subscriptionId(profile.getSubscriptionId())
            .defaultPollInterval(defaultPollInterval)
            .buildClient();
    }

    /**
     * Creates an instance of EventGrid service API entry point.
     * 
     * @param credential the credential to use.
     * @param profile the Azure profile for client.
     * @return the EventGrid service API instance.
     */
    public static EventGridManager authenticate(TokenCredential credential, AzureProfile profile) {
        Objects.requireNonNull(credential, "'credential' cannot be null.");
        Objects.requireNonNull(profile, "'profile' cannot be null.");
        return configure().authenticate(credential, profile);
    }

    /**
     * Creates an instance of EventGrid service API entry point.
     * 
     * @param httpPipeline the {@link HttpPipeline} configured with Azure authentication credential.
     * @param profile the Azure profile for client.
     * @return the EventGrid service API instance.
     */
    public static EventGridManager authenticate(HttpPipeline httpPipeline, AzureProfile profile) {
        Objects.requireNonNull(httpPipeline, "'httpPipeline' cannot be null.");
        Objects.requireNonNull(profile, "'profile' cannot be null.");
        return new EventGridManager(httpPipeline, profile, null);
    }

    /**
     * Gets a Configurable instance that can be used to create EventGridManager with optional configuration.
     * 
     * @return the Configurable instance allowing configurations.
     */
    public static Configurable configure() {
        return new EventGridManager.Configurable();
    }

    /**
     * The Configurable allowing configurations to be set.
     */
    public static final class Configurable {
        private static final ClientLogger LOGGER = new ClientLogger(Configurable.class);
        private static final String SDK_VERSION = "version";
        private static final Map<String, String> PROPERTIES
            = CoreUtils.getProperties("azure-resourcemanager-eventgrid.properties");

        private HttpClient httpClient;
        private HttpLogOptions httpLogOptions;
        private final List<HttpPipelinePolicy> policies = new ArrayList<>();
        private final List<String> scopes = new ArrayList<>();
        private RetryPolicy retryPolicy;
        private RetryOptions retryOptions;
        private Duration defaultPollInterval;

        private Configurable() {
        }

        /**
         * Sets the http client.
         *
         * @param httpClient the HTTP client.
         * @return the configurable object itself.
         */
        public Configurable withHttpClient(HttpClient httpClient) {
            this.httpClient = Objects.requireNonNull(httpClient, "'httpClient' cannot be null.");
            return this;
        }

        /**
         * Sets the logging options to the HTTP pipeline.
         *
         * @param httpLogOptions the HTTP log options.
         * @return the configurable object itself.
         */
        public Configurable withLogOptions(HttpLogOptions httpLogOptions) {
            this.httpLogOptions = Objects.requireNonNull(httpLogOptions, "'httpLogOptions' cannot be null.");
            return this;
        }

        /**
         * Adds the pipeline policy to the HTTP pipeline.
         *
         * @param policy the HTTP pipeline policy.
         * @return the configurable object itself.
         */
        public Configurable withPolicy(HttpPipelinePolicy policy) {
            this.policies.add(Objects.requireNonNull(policy, "'policy' cannot be null."));
            return this;
        }

        /**
         * Adds the scope to permission sets.
         *
         * @param scope the scope.
         * @return the configurable object itself.
         */
        public Configurable withScope(String scope) {
            this.scopes.add(Objects.requireNonNull(scope, "'scope' cannot be null."));
            return this;
        }

        /**
         * Sets the retry policy to the HTTP pipeline.
         *
         * @param retryPolicy the HTTP pipeline retry policy.
         * @return the configurable object itself.
         */
        public Configurable withRetryPolicy(RetryPolicy retryPolicy) {
            this.retryPolicy = Objects.requireNonNull(retryPolicy, "'retryPolicy' cannot be null.");
            return this;
        }

        /**
         * Sets the retry options for the HTTP pipeline retry policy.
         * <p>
         * This setting has no effect, if retry policy is set via {@link #withRetryPolicy(RetryPolicy)}.
         *
         * @param retryOptions the retry options for the HTTP pipeline retry policy.
         * @return the configurable object itself.
         */
        public Configurable withRetryOptions(RetryOptions retryOptions) {
            this.retryOptions = Objects.requireNonNull(retryOptions, "'retryOptions' cannot be null.");
            return this;
        }

        /**
         * Sets the default poll interval, used when service does not provide "Retry-After" header.
         *
         * @param defaultPollInterval the default poll interval.
         * @return the configurable object itself.
         */
        public Configurable withDefaultPollInterval(Duration defaultPollInterval) {
            this.defaultPollInterval
                = Objects.requireNonNull(defaultPollInterval, "'defaultPollInterval' cannot be null.");
            if (this.defaultPollInterval.isNegative()) {
                throw LOGGER
                    .logExceptionAsError(new IllegalArgumentException("'defaultPollInterval' cannot be negative"));
            }
            return this;
        }

        /**
         * Creates an instance of EventGrid service API entry point.
         *
         * @param credential the credential to use.
         * @param profile the Azure profile for client.
         * @return the EventGrid service API instance.
         */
        public EventGridManager authenticate(TokenCredential credential, AzureProfile profile) {
            Objects.requireNonNull(credential, "'credential' cannot be null.");
            Objects.requireNonNull(profile, "'profile' cannot be null.");

            String clientVersion = PROPERTIES.getOrDefault(SDK_VERSION, "UnknownVersion");

            StringBuilder userAgentBuilder = new StringBuilder();
            userAgentBuilder.append("azsdk-java")
                .append("-")
                .append("com.azure.resourcemanager.eventgrid")
                .append("/")
                .append(clientVersion);
            if (!Configuration.getGlobalConfiguration().get("AZURE_TELEMETRY_DISABLED", false)) {
                userAgentBuilder.append(" (")
                    .append(Configuration.getGlobalConfiguration().get("java.version"))
                    .append("; ")
                    .append(Configuration.getGlobalConfiguration().get("os.name"))
                    .append("; ")
                    .append(Configuration.getGlobalConfiguration().get("os.version"))
                    .append("; auto-generated)");
            } else {
                userAgentBuilder.append(" (auto-generated)");
            }

            if (scopes.isEmpty()) {
                scopes.add(profile.getEnvironment().getManagementEndpoint() + "/.default");
            }
            if (retryPolicy == null) {
                if (retryOptions != null) {
                    retryPolicy = new RetryPolicy(retryOptions);
                } else {
                    retryPolicy = new RetryPolicy("Retry-After", ChronoUnit.SECONDS);
                }
            }
            List<HttpPipelinePolicy> policies = new ArrayList<>();
            policies.add(new UserAgentPolicy(userAgentBuilder.toString()));
            policies.add(new AddHeadersFromContextPolicy());
            policies.add(new RequestIdPolicy());
            policies.addAll(this.policies.stream()
                .filter(p -> p.getPipelinePosition() == HttpPipelinePosition.PER_CALL)
                .collect(Collectors.toList()));
            HttpPolicyProviders.addBeforeRetryPolicies(policies);
            policies.add(retryPolicy);
            policies.add(new AddDatePolicy());
            policies.add(new BearerTokenAuthenticationPolicy(credential, scopes.toArray(new String[0])));
            policies.addAll(this.policies.stream()
                .filter(p -> p.getPipelinePosition() == HttpPipelinePosition.PER_RETRY)
                .collect(Collectors.toList()));
            HttpPolicyProviders.addAfterRetryPolicies(policies);
            policies.add(new HttpLoggingPolicy(httpLogOptions));
            HttpPipeline httpPipeline = new HttpPipelineBuilder().httpClient(httpClient)
                .policies(policies.toArray(new HttpPipelinePolicy[0]))
                .build();
            return new EventGridManager(httpPipeline, profile, defaultPollInterval);
        }
    }

    /**
     * Gets the resource collection API of CaCertificates. It manages CaCertificate.
     * 
     * @return Resource collection API of CaCertificates.
     */
    public CaCertificates caCertificates() {
        if (this.caCertificates == null) {
            this.caCertificates = new CaCertificatesImpl(clientObject.getCaCertificates(), this);
        }
        return caCertificates;
    }

    /**
     * Gets the resource collection API of Channels. It manages Channel.
     * 
     * @return Resource collection API of Channels.
     */
    public Channels channels() {
        if (this.channels == null) {
            this.channels = new ChannelsImpl(clientObject.getChannels(), this);
        }
        return channels;
    }

    /**
     * Gets the resource collection API of ClientGroups. It manages ClientGroup.
     * 
     * @return Resource collection API of ClientGroups.
     */
    public ClientGroups clientGroups() {
        if (this.clientGroups == null) {
            this.clientGroups = new ClientGroupsImpl(clientObject.getClientGroups(), this);
        }
        return clientGroups;
    }

    /**
     * Gets the resource collection API of Clients. It manages Client.
     * 
     * @return Resource collection API of Clients.
     */
    public Clients clients() {
        if (this.clients == null) {
            this.clients = new ClientsImpl(clientObject.getClients(), this);
        }
        return clients;
    }

    /**
     * Gets the resource collection API of Domains. It manages Domain.
     * 
     * @return Resource collection API of Domains.
     */
    public Domains domains() {
        if (this.domains == null) {
            this.domains = new DomainsImpl(clientObject.getDomains(), this);
        }
        return domains;
    }

    /**
     * Gets the resource collection API of DomainTopics.
     * 
     * @return Resource collection API of DomainTopics.
     */
    public DomainTopics domainTopics() {
        if (this.domainTopics == null) {
            this.domainTopics = new DomainTopicsImpl(clientObject.getDomainTopics(), this);
        }
        return domainTopics;
    }

    /**
     * Gets the resource collection API of TopicEventSubscriptions.
     * 
     * @return Resource collection API of TopicEventSubscriptions.
     */
    public TopicEventSubscriptions topicEventSubscriptions() {
        if (this.topicEventSubscriptions == null) {
            this.topicEventSubscriptions
                = new TopicEventSubscriptionsImpl(clientObject.getTopicEventSubscriptions(), this);
        }
        return topicEventSubscriptions;
    }

    /**
     * Gets the resource collection API of DomainEventSubscriptions.
     * 
     * @return Resource collection API of DomainEventSubscriptions.
     */
    public DomainEventSubscriptions domainEventSubscriptions() {
        if (this.domainEventSubscriptions == null) {
            this.domainEventSubscriptions
                = new DomainEventSubscriptionsImpl(clientObject.getDomainEventSubscriptions(), this);
        }
        return domainEventSubscriptions;
    }

    /**
     * Gets the resource collection API of NamespaceTopicEventSubscriptions. It manages Subscription.
     * 
     * @return Resource collection API of NamespaceTopicEventSubscriptions.
     */
    public NamespaceTopicEventSubscriptions namespaceTopicEventSubscriptions() {
        if (this.namespaceTopicEventSubscriptions == null) {
            this.namespaceTopicEventSubscriptions
                = new NamespaceTopicEventSubscriptionsImpl(clientObject.getNamespaceTopicEventSubscriptions(), this);
        }
        return namespaceTopicEventSubscriptions;
    }

    /**
     * Gets the resource collection API of EventSubscriptions. It manages EventSubscription.
     * 
     * @return Resource collection API of EventSubscriptions.
     */
    public EventSubscriptions eventSubscriptions() {
        if (this.eventSubscriptions == null) {
            this.eventSubscriptions = new EventSubscriptionsImpl(clientObject.getEventSubscriptions(), this);
        }
        return eventSubscriptions;
    }

    /**
     * Gets the resource collection API of DomainTopicEventSubscriptions.
     * 
     * @return Resource collection API of DomainTopicEventSubscriptions.
     */
    public DomainTopicEventSubscriptions domainTopicEventSubscriptions() {
        if (this.domainTopicEventSubscriptions == null) {
            this.domainTopicEventSubscriptions
                = new DomainTopicEventSubscriptionsImpl(clientObject.getDomainTopicEventSubscriptions(), this);
        }
        return domainTopicEventSubscriptions;
    }

    /**
     * Gets the resource collection API of SystemTopicEventSubscriptions.
     * 
     * @return Resource collection API of SystemTopicEventSubscriptions.
     */
    public SystemTopicEventSubscriptions systemTopicEventSubscriptions() {
        if (this.systemTopicEventSubscriptions == null) {
            this.systemTopicEventSubscriptions
                = new SystemTopicEventSubscriptionsImpl(clientObject.getSystemTopicEventSubscriptions(), this);
        }
        return systemTopicEventSubscriptions;
    }

    /**
     * Gets the resource collection API of PartnerTopicEventSubscriptions.
     * 
     * @return Resource collection API of PartnerTopicEventSubscriptions.
     */
    public PartnerTopicEventSubscriptions partnerTopicEventSubscriptions() {
        if (this.partnerTopicEventSubscriptions == null) {
            this.partnerTopicEventSubscriptions
                = new PartnerTopicEventSubscriptionsImpl(clientObject.getPartnerTopicEventSubscriptions(), this);
        }
        return partnerTopicEventSubscriptions;
    }

    /**
     * Gets the resource collection API of Namespaces. It manages Namespace.
     * 
     * @return Resource collection API of Namespaces.
     */
    public Namespaces namespaces() {
        if (this.namespaces == null) {
            this.namespaces = new NamespacesImpl(clientObject.getNamespaces(), this);
        }
        return namespaces;
    }

    /**
     * Gets the resource collection API of NamespaceTopics. It manages NamespaceTopic.
     * 
     * @return Resource collection API of NamespaceTopics.
     */
    public NamespaceTopics namespaceTopics() {
        if (this.namespaceTopics == null) {
            this.namespaceTopics = new NamespaceTopicsImpl(clientObject.getNamespaceTopics(), this);
        }
        return namespaceTopics;
    }

    /**
     * Gets the resource collection API of Operations.
     * 
     * @return Resource collection API of Operations.
     */
    public Operations operations() {
        if (this.operations == null) {
            this.operations = new OperationsImpl(clientObject.getOperations(), this);
        }
        return operations;
    }

    /**
     * Gets the resource collection API of Topics. It manages Topic.
     * 
     * @return Resource collection API of Topics.
     */
    public Topics topics() {
        if (this.topics == null) {
            this.topics = new TopicsImpl(clientObject.getTopics(), this);
        }
        return topics;
    }

    /**
     * Gets the resource collection API of PartnerConfigurations.
     * 
     * @return Resource collection API of PartnerConfigurations.
     */
    public PartnerConfigurations partnerConfigurations() {
        if (this.partnerConfigurations == null) {
            this.partnerConfigurations = new PartnerConfigurationsImpl(clientObject.getPartnerConfigurations(), this);
        }
        return partnerConfigurations;
    }

    /**
     * Gets the resource collection API of PartnerNamespaces. It manages PartnerNamespace.
     * 
     * @return Resource collection API of PartnerNamespaces.
     */
    public PartnerNamespaces partnerNamespaces() {
        if (this.partnerNamespaces == null) {
            this.partnerNamespaces = new PartnerNamespacesImpl(clientObject.getPartnerNamespaces(), this);
        }
        return partnerNamespaces;
    }

    /**
     * Gets the resource collection API of PartnerRegistrations. It manages PartnerRegistration.
     * 
     * @return Resource collection API of PartnerRegistrations.
     */
    public PartnerRegistrations partnerRegistrations() {
        if (this.partnerRegistrations == null) {
            this.partnerRegistrations = new PartnerRegistrationsImpl(clientObject.getPartnerRegistrations(), this);
        }
        return partnerRegistrations;
    }

    /**
     * Gets the resource collection API of PartnerTopics. It manages PartnerTopic.
     * 
     * @return Resource collection API of PartnerTopics.
     */
    public PartnerTopics partnerTopics() {
        if (this.partnerTopics == null) {
            this.partnerTopics = new PartnerTopicsImpl(clientObject.getPartnerTopics(), this);
        }
        return partnerTopics;
    }

    /**
     * Gets the resource collection API of PermissionBindings. It manages PermissionBinding.
     * 
     * @return Resource collection API of PermissionBindings.
     */
    public PermissionBindings permissionBindings() {
        if (this.permissionBindings == null) {
            this.permissionBindings = new PermissionBindingsImpl(clientObject.getPermissionBindings(), this);
        }
        return permissionBindings;
    }

    /**
     * Gets the resource collection API of PrivateEndpointConnections.
     * 
     * @return Resource collection API of PrivateEndpointConnections.
     */
    public PrivateEndpointConnections privateEndpointConnections() {
        if (this.privateEndpointConnections == null) {
            this.privateEndpointConnections
                = new PrivateEndpointConnectionsImpl(clientObject.getPrivateEndpointConnections(), this);
        }
        return privateEndpointConnections;
    }

    /**
     * Gets the resource collection API of PrivateLinkResources.
     * 
     * @return Resource collection API of PrivateLinkResources.
     */
    public PrivateLinkResources privateLinkResources() {
        if (this.privateLinkResources == null) {
            this.privateLinkResources = new PrivateLinkResourcesImpl(clientObject.getPrivateLinkResources(), this);
        }
        return privateLinkResources;
    }

    /**
     * Gets the resource collection API of SystemTopics. It manages SystemTopic.
     * 
     * @return Resource collection API of SystemTopics.
     */
    public SystemTopics systemTopics() {
        if (this.systemTopics == null) {
            this.systemTopics = new SystemTopicsImpl(clientObject.getSystemTopics(), this);
        }
        return systemTopics;
    }

    /**
     * Gets the resource collection API of ExtensionTopics.
     * 
     * @return Resource collection API of ExtensionTopics.
     */
    public ExtensionTopics extensionTopics() {
        if (this.extensionTopics == null) {
            this.extensionTopics = new ExtensionTopicsImpl(clientObject.getExtensionTopics(), this);
        }
        return extensionTopics;
    }

    /**
     * Gets the resource collection API of TopicSpaces. It manages TopicSpace.
     * 
     * @return Resource collection API of TopicSpaces.
     */
    public TopicSpaces topicSpaces() {
        if (this.topicSpaces == null) {
            this.topicSpaces = new TopicSpacesImpl(clientObject.getTopicSpaces(), this);
        }
        return topicSpaces;
    }

    /**
     * Gets the resource collection API of TopicTypes.
     * 
     * @return Resource collection API of TopicTypes.
     */
    public TopicTypes topicTypes() {
        if (this.topicTypes == null) {
            this.topicTypes = new TopicTypesImpl(clientObject.getTopicTypes(), this);
        }
        return topicTypes;
    }

    /**
     * Gets the resource collection API of VerifiedPartners.
     * 
     * @return Resource collection API of VerifiedPartners.
     */
    public VerifiedPartners verifiedPartners() {
        if (this.verifiedPartners == null) {
            this.verifiedPartners = new VerifiedPartnersImpl(clientObject.getVerifiedPartners(), this);
        }
        return verifiedPartners;
    }

    /**
     * Gets wrapped service client EventGridManagementClient providing direct access to the underlying auto-generated
     * API implementation, based on Azure REST API.
     * 
     * @return Wrapped service client EventGridManagementClient.
     */
    public EventGridManagementClient serviceClient() {
        return this.clientObject;
    }
}
