// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.eventgrid.fluent;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.polling.SyncPoller;
import com.azure.resourcemanager.eventgrid.fluent.models.PartnerRegistrationInner;
import com.azure.resourcemanager.eventgrid.models.PartnerRegistrationUpdateParameters;

/**
 * An instance of this class provides access to all the operations defined in PartnerRegistrationsClient.
 */
public interface PartnerRegistrationsClient {
    /**
     * Get a partner registration.
     * 
     * Gets a partner registration with the specified parameters.
     * 
     * @param resourceGroupName The name of the resource group within the user's subscription.
     * @param partnerRegistrationName Name of the partner registration.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a partner registration with the specified parameters along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<PartnerRegistrationInner> getByResourceGroupWithResponse(String resourceGroupName,
        String partnerRegistrationName, Context context);

    /**
     * Get a partner registration.
     * 
     * Gets a partner registration with the specified parameters.
     * 
     * @param resourceGroupName The name of the resource group within the user's subscription.
     * @param partnerRegistrationName Name of the partner registration.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a partner registration with the specified parameters.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    PartnerRegistrationInner getByResourceGroup(String resourceGroupName, String partnerRegistrationName);

    /**
     * Create a partner registration.
     * 
     * Creates a new partner registration with the specified parameters.
     * 
     * @param resourceGroupName The name of the resource group within the user's subscription.
     * @param partnerRegistrationName Name of the partner registration.
     * @param partnerRegistrationInfo PartnerRegistration information.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of information about a partner registration.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<PartnerRegistrationInner>, PartnerRegistrationInner> beginCreateOrUpdate(
        String resourceGroupName, String partnerRegistrationName, PartnerRegistrationInner partnerRegistrationInfo);

    /**
     * Create a partner registration.
     * 
     * Creates a new partner registration with the specified parameters.
     * 
     * @param resourceGroupName The name of the resource group within the user's subscription.
     * @param partnerRegistrationName Name of the partner registration.
     * @param partnerRegistrationInfo PartnerRegistration information.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of information about a partner registration.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<PartnerRegistrationInner>, PartnerRegistrationInner> beginCreateOrUpdate(
        String resourceGroupName, String partnerRegistrationName, PartnerRegistrationInner partnerRegistrationInfo,
        Context context);

    /**
     * Create a partner registration.
     * 
     * Creates a new partner registration with the specified parameters.
     * 
     * @param resourceGroupName The name of the resource group within the user's subscription.
     * @param partnerRegistrationName Name of the partner registration.
     * @param partnerRegistrationInfo PartnerRegistration information.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return information about a partner registration.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    PartnerRegistrationInner createOrUpdate(String resourceGroupName, String partnerRegistrationName,
        PartnerRegistrationInner partnerRegistrationInfo);

    /**
     * Create a partner registration.
     * 
     * Creates a new partner registration with the specified parameters.
     * 
     * @param resourceGroupName The name of the resource group within the user's subscription.
     * @param partnerRegistrationName Name of the partner registration.
     * @param partnerRegistrationInfo PartnerRegistration information.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return information about a partner registration.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    PartnerRegistrationInner createOrUpdate(String resourceGroupName, String partnerRegistrationName,
        PartnerRegistrationInner partnerRegistrationInfo, Context context);

    /**
     * Delete a partner registration.
     * 
     * Deletes a partner registration with the specified parameters.
     * 
     * @param resourceGroupName The name of the resource group within the user's subscription.
     * @param partnerRegistrationName Name of the partner registration.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String partnerRegistrationName);

    /**
     * Delete a partner registration.
     * 
     * Deletes a partner registration with the specified parameters.
     * 
     * @param resourceGroupName The name of the resource group within the user's subscription.
     * @param partnerRegistrationName Name of the partner registration.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String partnerRegistrationName,
        Context context);

    /**
     * Delete a partner registration.
     * 
     * Deletes a partner registration with the specified parameters.
     * 
     * @param resourceGroupName The name of the resource group within the user's subscription.
     * @param partnerRegistrationName Name of the partner registration.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void delete(String resourceGroupName, String partnerRegistrationName);

    /**
     * Delete a partner registration.
     * 
     * Deletes a partner registration with the specified parameters.
     * 
     * @param resourceGroupName The name of the resource group within the user's subscription.
     * @param partnerRegistrationName Name of the partner registration.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void delete(String resourceGroupName, String partnerRegistrationName, Context context);

    /**
     * Update a partner registration.
     * 
     * Updates a partner registration with the specified parameters.
     * 
     * @param resourceGroupName The name of the resource group within the user's subscription.
     * @param partnerRegistrationName Name of the partner registration.
     * @param partnerRegistrationUpdateParameters Partner registration update information.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<PartnerRegistrationInner>, PartnerRegistrationInner> beginUpdate(String resourceGroupName,
        String partnerRegistrationName, PartnerRegistrationUpdateParameters partnerRegistrationUpdateParameters);

    /**
     * Update a partner registration.
     * 
     * Updates a partner registration with the specified parameters.
     * 
     * @param resourceGroupName The name of the resource group within the user's subscription.
     * @param partnerRegistrationName Name of the partner registration.
     * @param partnerRegistrationUpdateParameters Partner registration update information.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<PartnerRegistrationInner>, PartnerRegistrationInner> beginUpdate(String resourceGroupName,
        String partnerRegistrationName, PartnerRegistrationUpdateParameters partnerRegistrationUpdateParameters,
        Context context);

    /**
     * Update a partner registration.
     * 
     * Updates a partner registration with the specified parameters.
     * 
     * @param resourceGroupName The name of the resource group within the user's subscription.
     * @param partnerRegistrationName Name of the partner registration.
     * @param partnerRegistrationUpdateParameters Partner registration update information.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    PartnerRegistrationInner update(String resourceGroupName, String partnerRegistrationName,
        PartnerRegistrationUpdateParameters partnerRegistrationUpdateParameters);

    /**
     * Update a partner registration.
     * 
     * Updates a partner registration with the specified parameters.
     * 
     * @param resourceGroupName The name of the resource group within the user's subscription.
     * @param partnerRegistrationName Name of the partner registration.
     * @param partnerRegistrationUpdateParameters Partner registration update information.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    PartnerRegistrationInner update(String resourceGroupName, String partnerRegistrationName,
        PartnerRegistrationUpdateParameters partnerRegistrationUpdateParameters, Context context);

    /**
     * List partner registrations under an Azure subscription.
     * 
     * List all the partner registrations under an Azure subscription.
     * 
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of the List Partner Registrations operation as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<PartnerRegistrationInner> list();

    /**
     * List partner registrations under an Azure subscription.
     * 
     * List all the partner registrations under an Azure subscription.
     * 
     * @param filter The query used to filter the search results using OData syntax. Filtering is permitted on the
     * 'name' property only and with limited number of OData operations. These operations are: the 'contains' function
     * as well as the following logical operations: not, and, or, eq (for equal), and ne (for not equal). No arithmetic
     * operations are supported. The following is a valid filter example: $filter=contains(namE, 'PATTERN') and name ne
     * 'PATTERN-1'. The following is not a valid filter example: $filter=location eq 'westus'.
     * @param top The number of results to return per page for the list operation. Valid range for top parameter is 1 to
     * 100. If not specified, the default number of results to be returned is 20 items per page.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of the List Partner Registrations operation as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<PartnerRegistrationInner> list(String filter, Integer top, Context context);

    /**
     * List partner registrations under a resource group.
     * 
     * List all the partner registrations under a resource group.
     * 
     * @param resourceGroupName The name of the resource group within the user's subscription.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of the List Partner Registrations operation as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<PartnerRegistrationInner> listByResourceGroup(String resourceGroupName);

    /**
     * List partner registrations under a resource group.
     * 
     * List all the partner registrations under a resource group.
     * 
     * @param resourceGroupName The name of the resource group within the user's subscription.
     * @param filter The query used to filter the search results using OData syntax. Filtering is permitted on the
     * 'name' property only and with limited number of OData operations. These operations are: the 'contains' function
     * as well as the following logical operations: not, and, or, eq (for equal), and ne (for not equal). No arithmetic
     * operations are supported. The following is a valid filter example: $filter=contains(namE, 'PATTERN') and name ne
     * 'PATTERN-1'. The following is not a valid filter example: $filter=location eq 'westus'.
     * @param top The number of results to return per page for the list operation. Valid range for top parameter is 1 to
     * 100. If not specified, the default number of results to be returned is 20 items per page.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of the List Partner Registrations operation as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<PartnerRegistrationInner> listByResourceGroup(String resourceGroupName, String filter, Integer top,
        Context context);
}
