// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.eventgrid.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventgrid.models.CaCertificateProvisioningState;
import java.io.IOException;
import java.time.OffsetDateTime;

/**
 * The properties of CA certificate.
 */
@Fluent
public final class CaCertificateProperties implements JsonSerializable<CaCertificateProperties> {
    /*
     * Description for the CA Certificate resource.
     */
    private String description;

    /*
     * Base64 encoded PEM (Privacy Enhanced Mail) format certificate data.
     */
    private String encodedCertificate;

    /*
     * Certificate issue time in UTC. This is a read-only field.
     */
    private OffsetDateTime issueTimeInUtc;

    /*
     * Certificate expiry time in UTC. This is a read-only field.
     */
    private OffsetDateTime expiryTimeInUtc;

    /*
     * Provisioning state of the CA Certificate resource.
     */
    private CaCertificateProvisioningState provisioningState;

    /**
     * Creates an instance of CaCertificateProperties class.
     */
    public CaCertificateProperties() {
    }

    /**
     * Get the description property: Description for the CA Certificate resource.
     * 
     * @return the description value.
     */
    public String description() {
        return this.description;
    }

    /**
     * Set the description property: Description for the CA Certificate resource.
     * 
     * @param description the description value to set.
     * @return the CaCertificateProperties object itself.
     */
    public CaCertificateProperties withDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * Get the encodedCertificate property: Base64 encoded PEM (Privacy Enhanced Mail) format certificate data.
     * 
     * @return the encodedCertificate value.
     */
    public String encodedCertificate() {
        return this.encodedCertificate;
    }

    /**
     * Set the encodedCertificate property: Base64 encoded PEM (Privacy Enhanced Mail) format certificate data.
     * 
     * @param encodedCertificate the encodedCertificate value to set.
     * @return the CaCertificateProperties object itself.
     */
    public CaCertificateProperties withEncodedCertificate(String encodedCertificate) {
        this.encodedCertificate = encodedCertificate;
        return this;
    }

    /**
     * Get the issueTimeInUtc property: Certificate issue time in UTC. This is a read-only field.
     * 
     * @return the issueTimeInUtc value.
     */
    public OffsetDateTime issueTimeInUtc() {
        return this.issueTimeInUtc;
    }

    /**
     * Get the expiryTimeInUtc property: Certificate expiry time in UTC. This is a read-only field.
     * 
     * @return the expiryTimeInUtc value.
     */
    public OffsetDateTime expiryTimeInUtc() {
        return this.expiryTimeInUtc;
    }

    /**
     * Get the provisioningState property: Provisioning state of the CA Certificate resource.
     * 
     * @return the provisioningState value.
     */
    public CaCertificateProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeStringField("encodedCertificate", this.encodedCertificate);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of CaCertificateProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of CaCertificateProperties if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the CaCertificateProperties.
     */
    public static CaCertificateProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            CaCertificateProperties deserializedCaCertificateProperties = new CaCertificateProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("description".equals(fieldName)) {
                    deserializedCaCertificateProperties.description = reader.getString();
                } else if ("encodedCertificate".equals(fieldName)) {
                    deserializedCaCertificateProperties.encodedCertificate = reader.getString();
                } else if ("issueTimeInUtc".equals(fieldName)) {
                    deserializedCaCertificateProperties.issueTimeInUtc = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("expiryTimeInUtc".equals(fieldName)) {
                    deserializedCaCertificateProperties.expiryTimeInUtc = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("provisioningState".equals(fieldName)) {
                    deserializedCaCertificateProperties.provisioningState
                        = CaCertificateProvisioningState.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedCaCertificateProperties;
        });
    }
}
