// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.eventgrid.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventgrid.models.PartnerUpdateTopicInfo;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

/**
 * Properties of the channel update parameters.
 */
@Fluent
public final class ChannelUpdateParametersProperties implements JsonSerializable<ChannelUpdateParametersProperties> {
    /*
     * Expiration time of the channel. If this timer expires while the corresponding partner topic or partner
     * destination is never activated,
     * the channel and corresponding partner topic or partner destination are deleted.
     */
    private OffsetDateTime expirationTimeIfNotActivatedUtc;

    /*
     * Partner topic properties which can be updated if the channel is of type PartnerTopic.
     */
    private PartnerUpdateTopicInfo partnerTopicInfo;

    /**
     * Creates an instance of ChannelUpdateParametersProperties class.
     */
    public ChannelUpdateParametersProperties() {
    }

    /**
     * Get the expirationTimeIfNotActivatedUtc property: Expiration time of the channel. If this timer expires while the
     * corresponding partner topic or partner destination is never activated,
     * the channel and corresponding partner topic or partner destination are deleted.
     * 
     * @return the expirationTimeIfNotActivatedUtc value.
     */
    public OffsetDateTime expirationTimeIfNotActivatedUtc() {
        return this.expirationTimeIfNotActivatedUtc;
    }

    /**
     * Set the expirationTimeIfNotActivatedUtc property: Expiration time of the channel. If this timer expires while the
     * corresponding partner topic or partner destination is never activated,
     * the channel and corresponding partner topic or partner destination are deleted.
     * 
     * @param expirationTimeIfNotActivatedUtc the expirationTimeIfNotActivatedUtc value to set.
     * @return the ChannelUpdateParametersProperties object itself.
     */
    public ChannelUpdateParametersProperties
        withExpirationTimeIfNotActivatedUtc(OffsetDateTime expirationTimeIfNotActivatedUtc) {
        this.expirationTimeIfNotActivatedUtc = expirationTimeIfNotActivatedUtc;
        return this;
    }

    /**
     * Get the partnerTopicInfo property: Partner topic properties which can be updated if the channel is of type
     * PartnerTopic.
     * 
     * @return the partnerTopicInfo value.
     */
    public PartnerUpdateTopicInfo partnerTopicInfo() {
        return this.partnerTopicInfo;
    }

    /**
     * Set the partnerTopicInfo property: Partner topic properties which can be updated if the channel is of type
     * PartnerTopic.
     * 
     * @param partnerTopicInfo the partnerTopicInfo value to set.
     * @return the ChannelUpdateParametersProperties object itself.
     */
    public ChannelUpdateParametersProperties withPartnerTopicInfo(PartnerUpdateTopicInfo partnerTopicInfo) {
        this.partnerTopicInfo = partnerTopicInfo;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (partnerTopicInfo() != null) {
            partnerTopicInfo().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("expirationTimeIfNotActivatedUtc",
            this.expirationTimeIfNotActivatedUtc == null
                ? null
                : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.expirationTimeIfNotActivatedUtc));
        jsonWriter.writeJsonField("partnerTopicInfo", this.partnerTopicInfo);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ChannelUpdateParametersProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ChannelUpdateParametersProperties if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ChannelUpdateParametersProperties.
     */
    public static ChannelUpdateParametersProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ChannelUpdateParametersProperties deserializedChannelUpdateParametersProperties
                = new ChannelUpdateParametersProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("expirationTimeIfNotActivatedUtc".equals(fieldName)) {
                    deserializedChannelUpdateParametersProperties.expirationTimeIfNotActivatedUtc = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("partnerTopicInfo".equals(fieldName)) {
                    deserializedChannelUpdateParametersProperties.partnerTopicInfo
                        = PartnerUpdateTopicInfo.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedChannelUpdateParametersProperties;
        });
    }
}
