// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.eventgrid.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventgrid.models.ClientGroupProvisioningState;
import java.io.IOException;

/**
 * The properties of client group.
 */
@Fluent
public final class ClientGroupProperties implements JsonSerializable<ClientGroupProperties> {
    /*
     * Description for the Client Group resource.
     */
    private String description;

    /*
     * The grouping query for the clients.
     * Example : attributes.keyName IN ['a', 'b', 'c'].
     */
    private String query;

    /*
     * Provisioning state of the ClientGroup resource.
     */
    private ClientGroupProvisioningState provisioningState;

    /**
     * Creates an instance of ClientGroupProperties class.
     */
    public ClientGroupProperties() {
    }

    /**
     * Get the description property: Description for the Client Group resource.
     * 
     * @return the description value.
     */
    public String description() {
        return this.description;
    }

    /**
     * Set the description property: Description for the Client Group resource.
     * 
     * @param description the description value to set.
     * @return the ClientGroupProperties object itself.
     */
    public ClientGroupProperties withDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * Get the query property: The grouping query for the clients.
     * Example : attributes.keyName IN ['a', 'b', 'c'].
     * 
     * @return the query value.
     */
    public String query() {
        return this.query;
    }

    /**
     * Set the query property: The grouping query for the clients.
     * Example : attributes.keyName IN ['a', 'b', 'c'].
     * 
     * @param query the query value to set.
     * @return the ClientGroupProperties object itself.
     */
    public ClientGroupProperties withQuery(String query) {
        this.query = query;
        return this;
    }

    /**
     * Get the provisioningState property: Provisioning state of the ClientGroup resource.
     * 
     * @return the provisioningState value.
     */
    public ClientGroupProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeStringField("query", this.query);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ClientGroupProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ClientGroupProperties if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ClientGroupProperties.
     */
    public static ClientGroupProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ClientGroupProperties deserializedClientGroupProperties = new ClientGroupProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("description".equals(fieldName)) {
                    deserializedClientGroupProperties.description = reader.getString();
                } else if ("query".equals(fieldName)) {
                    deserializedClientGroupProperties.query = reader.getString();
                } else if ("provisioningState".equals(fieldName)) {
                    deserializedClientGroupProperties.provisioningState
                        = ClientGroupProvisioningState.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedClientGroupProperties;
        });
    }
}
