// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.eventgrid.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventgrid.models.ClientCertificateAuthentication;
import com.azure.resourcemanager.eventgrid.models.ClientProvisioningState;
import com.azure.resourcemanager.eventgrid.models.ClientState;
import java.io.IOException;
import java.util.Map;

/**
 * The Client resource.
 */
@Fluent
public final class ClientInner extends ProxyResource {
    /*
     * The properties of client.
     */
    private ClientProperties innerProperties;

    /*
     * The system metadata relating to the Event Grid resource.
     */
    private SystemData systemData;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of ClientInner class.
     */
    public ClientInner() {
    }

    /**
     * Get the innerProperties property: The properties of client.
     * 
     * @return the innerProperties value.
     */
    private ClientProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the systemData property: The system metadata relating to the Event Grid resource.
     * 
     * @return the systemData value.
     */
    public SystemData systemData() {
        return this.systemData;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Get the description property: Description for the Client resource.
     * 
     * @return the description value.
     */
    public String description() {
        return this.innerProperties() == null ? null : this.innerProperties().description();
    }

    /**
     * Set the description property: Description for the Client resource.
     * 
     * @param description the description value to set.
     * @return the ClientInner object itself.
     */
    public ClientInner withDescription(String description) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ClientProperties();
        }
        this.innerProperties().withDescription(description);
        return this;
    }

    /**
     * Get the authenticationName property: The name presented by the client for authentication. The default value is
     * the name of the resource.
     * 
     * @return the authenticationName value.
     */
    public String authenticationName() {
        return this.innerProperties() == null ? null : this.innerProperties().authenticationName();
    }

    /**
     * Set the authenticationName property: The name presented by the client for authentication. The default value is
     * the name of the resource.
     * 
     * @param authenticationName the authenticationName value to set.
     * @return the ClientInner object itself.
     */
    public ClientInner withAuthenticationName(String authenticationName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ClientProperties();
        }
        this.innerProperties().withAuthenticationName(authenticationName);
        return this;
    }

    /**
     * Get the clientCertificateAuthentication property: The client certificate authentication information.
     * 
     * @return the clientCertificateAuthentication value.
     */
    public ClientCertificateAuthentication clientCertificateAuthentication() {
        return this.innerProperties() == null ? null : this.innerProperties().clientCertificateAuthentication();
    }

    /**
     * Set the clientCertificateAuthentication property: The client certificate authentication information.
     * 
     * @param clientCertificateAuthentication the clientCertificateAuthentication value to set.
     * @return the ClientInner object itself.
     */
    public ClientInner
        withClientCertificateAuthentication(ClientCertificateAuthentication clientCertificateAuthentication) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ClientProperties();
        }
        this.innerProperties().withClientCertificateAuthentication(clientCertificateAuthentication);
        return this;
    }

    /**
     * Get the state property: Indicates if the client is enabled or not. Default value is Enabled.
     * 
     * @return the state value.
     */
    public ClientState state() {
        return this.innerProperties() == null ? null : this.innerProperties().state();
    }

    /**
     * Set the state property: Indicates if the client is enabled or not. Default value is Enabled.
     * 
     * @param state the state value to set.
     * @return the ClientInner object itself.
     */
    public ClientInner withState(ClientState state) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ClientProperties();
        }
        this.innerProperties().withState(state);
        return this;
    }

    /**
     * Get the attributes property: Attributes for the client. Supported values are int, bool, string, string[].
     * Example:
     * "attributes": { "room": "345", "floor": 12, "deviceTypes": ["Fan", "Light"] }.
     * 
     * @return the attributes value.
     */
    public Map<String, Object> attributes() {
        return this.innerProperties() == null ? null : this.innerProperties().attributes();
    }

    /**
     * Set the attributes property: Attributes for the client. Supported values are int, bool, string, string[].
     * Example:
     * "attributes": { "room": "345", "floor": 12, "deviceTypes": ["Fan", "Light"] }.
     * 
     * @param attributes the attributes value to set.
     * @return the ClientInner object itself.
     */
    public ClientInner withAttributes(Map<String, Object> attributes) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ClientProperties();
        }
        this.innerProperties().withAttributes(attributes);
        return this;
    }

    /**
     * Get the provisioningState property: Provisioning state of the Client resource.
     * 
     * @return the provisioningState value.
     */
    public ClientProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ClientInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ClientInner if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ClientInner.
     */
    public static ClientInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ClientInner deserializedClientInner = new ClientInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedClientInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedClientInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedClientInner.type = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    deserializedClientInner.innerProperties = ClientProperties.fromJson(reader);
                } else if ("systemData".equals(fieldName)) {
                    deserializedClientInner.systemData = SystemData.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedClientInner;
        });
    }
}
