// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.eventgrid.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventgrid.models.ClientCertificateAuthentication;
import com.azure.resourcemanager.eventgrid.models.ClientProvisioningState;
import com.azure.resourcemanager.eventgrid.models.ClientState;
import java.io.IOException;
import java.util.Map;

/**
 * The properties of client.
 */
@Fluent
public final class ClientProperties implements JsonSerializable<ClientProperties> {
    /*
     * Description for the Client resource.
     */
    private String description;

    /*
     * The name presented by the client for authentication. The default value is the name of the resource.
     */
    private String authenticationName;

    /*
     * The client certificate authentication information.
     */
    private ClientCertificateAuthentication clientCertificateAuthentication;

    /*
     * Indicates if the client is enabled or not. Default value is Enabled.
     */
    private ClientState state;

    /*
     * Attributes for the client. Supported values are int, bool, string, string[].
     * Example:
     * "attributes": { "room": "345", "floor": 12, "deviceTypes": ["Fan", "Light"] }
     */
    private Map<String, Object> attributes;

    /*
     * Provisioning state of the Client resource.
     */
    private ClientProvisioningState provisioningState;

    /**
     * Creates an instance of ClientProperties class.
     */
    public ClientProperties() {
    }

    /**
     * Get the description property: Description for the Client resource.
     * 
     * @return the description value.
     */
    public String description() {
        return this.description;
    }

    /**
     * Set the description property: Description for the Client resource.
     * 
     * @param description the description value to set.
     * @return the ClientProperties object itself.
     */
    public ClientProperties withDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * Get the authenticationName property: The name presented by the client for authentication. The default value is
     * the name of the resource.
     * 
     * @return the authenticationName value.
     */
    public String authenticationName() {
        return this.authenticationName;
    }

    /**
     * Set the authenticationName property: The name presented by the client for authentication. The default value is
     * the name of the resource.
     * 
     * @param authenticationName the authenticationName value to set.
     * @return the ClientProperties object itself.
     */
    public ClientProperties withAuthenticationName(String authenticationName) {
        this.authenticationName = authenticationName;
        return this;
    }

    /**
     * Get the clientCertificateAuthentication property: The client certificate authentication information.
     * 
     * @return the clientCertificateAuthentication value.
     */
    public ClientCertificateAuthentication clientCertificateAuthentication() {
        return this.clientCertificateAuthentication;
    }

    /**
     * Set the clientCertificateAuthentication property: The client certificate authentication information.
     * 
     * @param clientCertificateAuthentication the clientCertificateAuthentication value to set.
     * @return the ClientProperties object itself.
     */
    public ClientProperties
        withClientCertificateAuthentication(ClientCertificateAuthentication clientCertificateAuthentication) {
        this.clientCertificateAuthentication = clientCertificateAuthentication;
        return this;
    }

    /**
     * Get the state property: Indicates if the client is enabled or not. Default value is Enabled.
     * 
     * @return the state value.
     */
    public ClientState state() {
        return this.state;
    }

    /**
     * Set the state property: Indicates if the client is enabled or not. Default value is Enabled.
     * 
     * @param state the state value to set.
     * @return the ClientProperties object itself.
     */
    public ClientProperties withState(ClientState state) {
        this.state = state;
        return this;
    }

    /**
     * Get the attributes property: Attributes for the client. Supported values are int, bool, string, string[].
     * Example:
     * "attributes": { "room": "345", "floor": 12, "deviceTypes": ["Fan", "Light"] }.
     * 
     * @return the attributes value.
     */
    public Map<String, Object> attributes() {
        return this.attributes;
    }

    /**
     * Set the attributes property: Attributes for the client. Supported values are int, bool, string, string[].
     * Example:
     * "attributes": { "room": "345", "floor": 12, "deviceTypes": ["Fan", "Light"] }.
     * 
     * @param attributes the attributes value to set.
     * @return the ClientProperties object itself.
     */
    public ClientProperties withAttributes(Map<String, Object> attributes) {
        this.attributes = attributes;
        return this;
    }

    /**
     * Get the provisioningState property: Provisioning state of the Client resource.
     * 
     * @return the provisioningState value.
     */
    public ClientProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (clientCertificateAuthentication() != null) {
            clientCertificateAuthentication().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeStringField("authenticationName", this.authenticationName);
        jsonWriter.writeJsonField("clientCertificateAuthentication", this.clientCertificateAuthentication);
        jsonWriter.writeStringField("state", this.state == null ? null : this.state.toString());
        jsonWriter.writeMapField("attributes", this.attributes, (writer, element) -> writer.writeUntyped(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ClientProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ClientProperties if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the ClientProperties.
     */
    public static ClientProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ClientProperties deserializedClientProperties = new ClientProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("description".equals(fieldName)) {
                    deserializedClientProperties.description = reader.getString();
                } else if ("authenticationName".equals(fieldName)) {
                    deserializedClientProperties.authenticationName = reader.getString();
                } else if ("clientCertificateAuthentication".equals(fieldName)) {
                    deserializedClientProperties.clientCertificateAuthentication
                        = ClientCertificateAuthentication.fromJson(reader);
                } else if ("state".equals(fieldName)) {
                    deserializedClientProperties.state = ClientState.fromString(reader.getString());
                } else if ("attributes".equals(fieldName)) {
                    Map<String, Object> attributes = reader.readMap(reader1 -> reader1.readUntyped());
                    deserializedClientProperties.attributes = attributes;
                } else if ("provisioningState".equals(fieldName)) {
                    deserializedClientProperties.provisioningState
                        = ClientProvisioningState.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedClientProperties;
        });
    }
}
