// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.eventgrid.fluent.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventgrid.models.DomainTopicProvisioningState;
import java.io.IOException;

/**
 * Properties of the Domain Topic.
 */
@Immutable
public final class DomainTopicProperties implements JsonSerializable<DomainTopicProperties> {
    /*
     * Provisioning state of the domain topic.
     */
    private DomainTopicProvisioningState provisioningState;

    /**
     * Creates an instance of DomainTopicProperties class.
     */
    public DomainTopicProperties() {
    }

    /**
     * Get the provisioningState property: Provisioning state of the domain topic.
     * 
     * @return the provisioningState value.
     */
    public DomainTopicProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DomainTopicProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DomainTopicProperties if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the DomainTopicProperties.
     */
    public static DomainTopicProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DomainTopicProperties deserializedDomainTopicProperties = new DomainTopicProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("provisioningState".equals(fieldName)) {
                    deserializedDomainTopicProperties.provisioningState
                        = DomainTopicProvisioningState.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDomainTopicProperties;
        });
    }
}
