// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.eventgrid.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventgrid.models.DeadLetterDestination;
import com.azure.resourcemanager.eventgrid.models.DeadLetterWithResourceIdentity;
import com.azure.resourcemanager.eventgrid.models.DeliveryWithResourceIdentity;
import com.azure.resourcemanager.eventgrid.models.EventDeliverySchema;
import com.azure.resourcemanager.eventgrid.models.EventSubscriptionDestination;
import com.azure.resourcemanager.eventgrid.models.EventSubscriptionFilter;
import com.azure.resourcemanager.eventgrid.models.EventSubscriptionProvisioningState;
import com.azure.resourcemanager.eventgrid.models.RetryPolicy;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;

/**
 * Event Subscription.
 */
@Fluent
public final class EventSubscriptionInner extends ProxyResource {
    /*
     * Properties of the event subscription.
     */
    private EventSubscriptionProperties innerProperties;

    /*
     * The system metadata relating to the Event Grid resource.
     */
    private SystemData systemData;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of EventSubscriptionInner class.
     */
    public EventSubscriptionInner() {
    }

    /**
     * Get the innerProperties property: Properties of the event subscription.
     * 
     * @return the innerProperties value.
     */
    private EventSubscriptionProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the systemData property: The system metadata relating to the Event Grid resource.
     * 
     * @return the systemData value.
     */
    public SystemData systemData() {
        return this.systemData;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Get the topic property: Name of the topic of the event subscription.
     * 
     * @return the topic value.
     */
    public String topic() {
        return this.innerProperties() == null ? null : this.innerProperties().topic();
    }

    /**
     * Get the provisioningState property: Provisioning state of the event subscription.
     * 
     * @return the provisioningState value.
     */
    public EventSubscriptionProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    /**
     * Get the destination property: Information about the destination where events have to be delivered for the event
     * subscription.
     * Uses Azure Event Grid's identity to acquire the authentication tokens being used during delivery /
     * dead-lettering.
     * 
     * @return the destination value.
     */
    public EventSubscriptionDestination destination() {
        return this.innerProperties() == null ? null : this.innerProperties().destination();
    }

    /**
     * Set the destination property: Information about the destination where events have to be delivered for the event
     * subscription.
     * Uses Azure Event Grid's identity to acquire the authentication tokens being used during delivery /
     * dead-lettering.
     * 
     * @param destination the destination value to set.
     * @return the EventSubscriptionInner object itself.
     */
    public EventSubscriptionInner withDestination(EventSubscriptionDestination destination) {
        if (this.innerProperties() == null) {
            this.innerProperties = new EventSubscriptionProperties();
        }
        this.innerProperties().withDestination(destination);
        return this;
    }

    /**
     * Get the deliveryWithResourceIdentity property: Information about the destination where events have to be
     * delivered for the event subscription.
     * Uses the managed identity setup on the parent resource (namely, topic or domain) to acquire the authentication
     * tokens being used during delivery / dead-lettering.
     * 
     * @return the deliveryWithResourceIdentity value.
     */
    public DeliveryWithResourceIdentity deliveryWithResourceIdentity() {
        return this.innerProperties() == null ? null : this.innerProperties().deliveryWithResourceIdentity();
    }

    /**
     * Set the deliveryWithResourceIdentity property: Information about the destination where events have to be
     * delivered for the event subscription.
     * Uses the managed identity setup on the parent resource (namely, topic or domain) to acquire the authentication
     * tokens being used during delivery / dead-lettering.
     * 
     * @param deliveryWithResourceIdentity the deliveryWithResourceIdentity value to set.
     * @return the EventSubscriptionInner object itself.
     */
    public EventSubscriptionInner
        withDeliveryWithResourceIdentity(DeliveryWithResourceIdentity deliveryWithResourceIdentity) {
        if (this.innerProperties() == null) {
            this.innerProperties = new EventSubscriptionProperties();
        }
        this.innerProperties().withDeliveryWithResourceIdentity(deliveryWithResourceIdentity);
        return this;
    }

    /**
     * Get the filter property: Information about the filter for the event subscription.
     * 
     * @return the filter value.
     */
    public EventSubscriptionFilter filter() {
        return this.innerProperties() == null ? null : this.innerProperties().filter();
    }

    /**
     * Set the filter property: Information about the filter for the event subscription.
     * 
     * @param filter the filter value to set.
     * @return the EventSubscriptionInner object itself.
     */
    public EventSubscriptionInner withFilter(EventSubscriptionFilter filter) {
        if (this.innerProperties() == null) {
            this.innerProperties = new EventSubscriptionProperties();
        }
        this.innerProperties().withFilter(filter);
        return this;
    }

    /**
     * Get the labels property: List of user defined labels.
     * 
     * @return the labels value.
     */
    public List<String> labels() {
        return this.innerProperties() == null ? null : this.innerProperties().labels();
    }

    /**
     * Set the labels property: List of user defined labels.
     * 
     * @param labels the labels value to set.
     * @return the EventSubscriptionInner object itself.
     */
    public EventSubscriptionInner withLabels(List<String> labels) {
        if (this.innerProperties() == null) {
            this.innerProperties = new EventSubscriptionProperties();
        }
        this.innerProperties().withLabels(labels);
        return this;
    }

    /**
     * Get the expirationTimeUtc property: Expiration time of the event subscription.
     * 
     * @return the expirationTimeUtc value.
     */
    public OffsetDateTime expirationTimeUtc() {
        return this.innerProperties() == null ? null : this.innerProperties().expirationTimeUtc();
    }

    /**
     * Set the expirationTimeUtc property: Expiration time of the event subscription.
     * 
     * @param expirationTimeUtc the expirationTimeUtc value to set.
     * @return the EventSubscriptionInner object itself.
     */
    public EventSubscriptionInner withExpirationTimeUtc(OffsetDateTime expirationTimeUtc) {
        if (this.innerProperties() == null) {
            this.innerProperties = new EventSubscriptionProperties();
        }
        this.innerProperties().withExpirationTimeUtc(expirationTimeUtc);
        return this;
    }

    /**
     * Get the eventDeliverySchema property: The event delivery schema for the event subscription.
     * 
     * @return the eventDeliverySchema value.
     */
    public EventDeliverySchema eventDeliverySchema() {
        return this.innerProperties() == null ? null : this.innerProperties().eventDeliverySchema();
    }

    /**
     * Set the eventDeliverySchema property: The event delivery schema for the event subscription.
     * 
     * @param eventDeliverySchema the eventDeliverySchema value to set.
     * @return the EventSubscriptionInner object itself.
     */
    public EventSubscriptionInner withEventDeliverySchema(EventDeliverySchema eventDeliverySchema) {
        if (this.innerProperties() == null) {
            this.innerProperties = new EventSubscriptionProperties();
        }
        this.innerProperties().withEventDeliverySchema(eventDeliverySchema);
        return this;
    }

    /**
     * Get the retryPolicy property: The retry policy for events. This can be used to configure maximum number of
     * delivery attempts and time to live for events.
     * 
     * @return the retryPolicy value.
     */
    public RetryPolicy retryPolicy() {
        return this.innerProperties() == null ? null : this.innerProperties().retryPolicy();
    }

    /**
     * Set the retryPolicy property: The retry policy for events. This can be used to configure maximum number of
     * delivery attempts and time to live for events.
     * 
     * @param retryPolicy the retryPolicy value to set.
     * @return the EventSubscriptionInner object itself.
     */
    public EventSubscriptionInner withRetryPolicy(RetryPolicy retryPolicy) {
        if (this.innerProperties() == null) {
            this.innerProperties = new EventSubscriptionProperties();
        }
        this.innerProperties().withRetryPolicy(retryPolicy);
        return this;
    }

    /**
     * Get the deadLetterDestination property: The dead letter destination of the event subscription. Any event that
     * cannot be delivered to its' destination is sent to the dead letter destination.
     * Uses Azure Event Grid's identity to acquire the authentication tokens being used during delivery /
     * dead-lettering.
     * 
     * @return the deadLetterDestination value.
     */
    public DeadLetterDestination deadLetterDestination() {
        return this.innerProperties() == null ? null : this.innerProperties().deadLetterDestination();
    }

    /**
     * Set the deadLetterDestination property: The dead letter destination of the event subscription. Any event that
     * cannot be delivered to its' destination is sent to the dead letter destination.
     * Uses Azure Event Grid's identity to acquire the authentication tokens being used during delivery /
     * dead-lettering.
     * 
     * @param deadLetterDestination the deadLetterDestination value to set.
     * @return the EventSubscriptionInner object itself.
     */
    public EventSubscriptionInner withDeadLetterDestination(DeadLetterDestination deadLetterDestination) {
        if (this.innerProperties() == null) {
            this.innerProperties = new EventSubscriptionProperties();
        }
        this.innerProperties().withDeadLetterDestination(deadLetterDestination);
        return this;
    }

    /**
     * Get the deadLetterWithResourceIdentity property: The dead letter destination of the event subscription. Any event
     * that cannot be delivered to its' destination is sent to the dead letter destination.
     * Uses the managed identity setup on the parent resource (namely, topic or domain) to acquire the authentication
     * tokens being used during delivery / dead-lettering.
     * 
     * @return the deadLetterWithResourceIdentity value.
     */
    public DeadLetterWithResourceIdentity deadLetterWithResourceIdentity() {
        return this.innerProperties() == null ? null : this.innerProperties().deadLetterWithResourceIdentity();
    }

    /**
     * Set the deadLetterWithResourceIdentity property: The dead letter destination of the event subscription. Any event
     * that cannot be delivered to its' destination is sent to the dead letter destination.
     * Uses the managed identity setup on the parent resource (namely, topic or domain) to acquire the authentication
     * tokens being used during delivery / dead-lettering.
     * 
     * @param deadLetterWithResourceIdentity the deadLetterWithResourceIdentity value to set.
     * @return the EventSubscriptionInner object itself.
     */
    public EventSubscriptionInner
        withDeadLetterWithResourceIdentity(DeadLetterWithResourceIdentity deadLetterWithResourceIdentity) {
        if (this.innerProperties() == null) {
            this.innerProperties = new EventSubscriptionProperties();
        }
        this.innerProperties().withDeadLetterWithResourceIdentity(deadLetterWithResourceIdentity);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of EventSubscriptionInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of EventSubscriptionInner if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the EventSubscriptionInner.
     */
    public static EventSubscriptionInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            EventSubscriptionInner deserializedEventSubscriptionInner = new EventSubscriptionInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedEventSubscriptionInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedEventSubscriptionInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedEventSubscriptionInner.type = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    deserializedEventSubscriptionInner.innerProperties = EventSubscriptionProperties.fromJson(reader);
                } else if ("systemData".equals(fieldName)) {
                    deserializedEventSubscriptionInner.systemData = SystemData.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedEventSubscriptionInner;
        });
    }
}
