// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.eventgrid.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventgrid.models.DeadLetterDestination;
import com.azure.resourcemanager.eventgrid.models.DeadLetterWithResourceIdentity;
import com.azure.resourcemanager.eventgrid.models.DeliveryWithResourceIdentity;
import com.azure.resourcemanager.eventgrid.models.EventDeliverySchema;
import com.azure.resourcemanager.eventgrid.models.EventSubscriptionDestination;
import com.azure.resourcemanager.eventgrid.models.EventSubscriptionFilter;
import com.azure.resourcemanager.eventgrid.models.EventSubscriptionProvisioningState;
import com.azure.resourcemanager.eventgrid.models.RetryPolicy;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;

/**
 * Properties of the Event Subscription.
 */
@Fluent
public final class EventSubscriptionProperties implements JsonSerializable<EventSubscriptionProperties> {
    /*
     * Name of the topic of the event subscription.
     */
    private String topic;

    /*
     * Provisioning state of the event subscription.
     */
    private EventSubscriptionProvisioningState provisioningState;

    /*
     * Information about the destination where events have to be delivered for the event subscription.
     * Uses Azure Event Grid's identity to acquire the authentication tokens being used during delivery /
     * dead-lettering.
     */
    private EventSubscriptionDestination destination;

    /*
     * Information about the destination where events have to be delivered for the event subscription.
     * Uses the managed identity setup on the parent resource (namely, topic or domain) to acquire the authentication
     * tokens being used during delivery / dead-lettering.
     */
    private DeliveryWithResourceIdentity deliveryWithResourceIdentity;

    /*
     * Information about the filter for the event subscription.
     */
    private EventSubscriptionFilter filter;

    /*
     * List of user defined labels.
     */
    private List<String> labels;

    /*
     * Expiration time of the event subscription.
     */
    private OffsetDateTime expirationTimeUtc;

    /*
     * The event delivery schema for the event subscription.
     */
    private EventDeliverySchema eventDeliverySchema;

    /*
     * The retry policy for events. This can be used to configure maximum number of delivery attempts and time to live
     * for events.
     */
    private RetryPolicy retryPolicy;

    /*
     * The dead letter destination of the event subscription. Any event that cannot be delivered to its' destination is
     * sent to the dead letter destination.
     * Uses Azure Event Grid's identity to acquire the authentication tokens being used during delivery /
     * dead-lettering.
     */
    private DeadLetterDestination deadLetterDestination;

    /*
     * The dead letter destination of the event subscription. Any event that cannot be delivered to its' destination is
     * sent to the dead letter destination.
     * Uses the managed identity setup on the parent resource (namely, topic or domain) to acquire the authentication
     * tokens being used during delivery / dead-lettering.
     */
    private DeadLetterWithResourceIdentity deadLetterWithResourceIdentity;

    /**
     * Creates an instance of EventSubscriptionProperties class.
     */
    public EventSubscriptionProperties() {
    }

    /**
     * Get the topic property: Name of the topic of the event subscription.
     * 
     * @return the topic value.
     */
    public String topic() {
        return this.topic;
    }

    /**
     * Get the provisioningState property: Provisioning state of the event subscription.
     * 
     * @return the provisioningState value.
     */
    public EventSubscriptionProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get the destination property: Information about the destination where events have to be delivered for the event
     * subscription.
     * Uses Azure Event Grid's identity to acquire the authentication tokens being used during delivery /
     * dead-lettering.
     * 
     * @return the destination value.
     */
    public EventSubscriptionDestination destination() {
        return this.destination;
    }

    /**
     * Set the destination property: Information about the destination where events have to be delivered for the event
     * subscription.
     * Uses Azure Event Grid's identity to acquire the authentication tokens being used during delivery /
     * dead-lettering.
     * 
     * @param destination the destination value to set.
     * @return the EventSubscriptionProperties object itself.
     */
    public EventSubscriptionProperties withDestination(EventSubscriptionDestination destination) {
        this.destination = destination;
        return this;
    }

    /**
     * Get the deliveryWithResourceIdentity property: Information about the destination where events have to be
     * delivered for the event subscription.
     * Uses the managed identity setup on the parent resource (namely, topic or domain) to acquire the authentication
     * tokens being used during delivery / dead-lettering.
     * 
     * @return the deliveryWithResourceIdentity value.
     */
    public DeliveryWithResourceIdentity deliveryWithResourceIdentity() {
        return this.deliveryWithResourceIdentity;
    }

    /**
     * Set the deliveryWithResourceIdentity property: Information about the destination where events have to be
     * delivered for the event subscription.
     * Uses the managed identity setup on the parent resource (namely, topic or domain) to acquire the authentication
     * tokens being used during delivery / dead-lettering.
     * 
     * @param deliveryWithResourceIdentity the deliveryWithResourceIdentity value to set.
     * @return the EventSubscriptionProperties object itself.
     */
    public EventSubscriptionProperties
        withDeliveryWithResourceIdentity(DeliveryWithResourceIdentity deliveryWithResourceIdentity) {
        this.deliveryWithResourceIdentity = deliveryWithResourceIdentity;
        return this;
    }

    /**
     * Get the filter property: Information about the filter for the event subscription.
     * 
     * @return the filter value.
     */
    public EventSubscriptionFilter filter() {
        return this.filter;
    }

    /**
     * Set the filter property: Information about the filter for the event subscription.
     * 
     * @param filter the filter value to set.
     * @return the EventSubscriptionProperties object itself.
     */
    public EventSubscriptionProperties withFilter(EventSubscriptionFilter filter) {
        this.filter = filter;
        return this;
    }

    /**
     * Get the labels property: List of user defined labels.
     * 
     * @return the labels value.
     */
    public List<String> labels() {
        return this.labels;
    }

    /**
     * Set the labels property: List of user defined labels.
     * 
     * @param labels the labels value to set.
     * @return the EventSubscriptionProperties object itself.
     */
    public EventSubscriptionProperties withLabels(List<String> labels) {
        this.labels = labels;
        return this;
    }

    /**
     * Get the expirationTimeUtc property: Expiration time of the event subscription.
     * 
     * @return the expirationTimeUtc value.
     */
    public OffsetDateTime expirationTimeUtc() {
        return this.expirationTimeUtc;
    }

    /**
     * Set the expirationTimeUtc property: Expiration time of the event subscription.
     * 
     * @param expirationTimeUtc the expirationTimeUtc value to set.
     * @return the EventSubscriptionProperties object itself.
     */
    public EventSubscriptionProperties withExpirationTimeUtc(OffsetDateTime expirationTimeUtc) {
        this.expirationTimeUtc = expirationTimeUtc;
        return this;
    }

    /**
     * Get the eventDeliverySchema property: The event delivery schema for the event subscription.
     * 
     * @return the eventDeliverySchema value.
     */
    public EventDeliverySchema eventDeliverySchema() {
        return this.eventDeliverySchema;
    }

    /**
     * Set the eventDeliverySchema property: The event delivery schema for the event subscription.
     * 
     * @param eventDeliverySchema the eventDeliverySchema value to set.
     * @return the EventSubscriptionProperties object itself.
     */
    public EventSubscriptionProperties withEventDeliverySchema(EventDeliverySchema eventDeliverySchema) {
        this.eventDeliverySchema = eventDeliverySchema;
        return this;
    }

    /**
     * Get the retryPolicy property: The retry policy for events. This can be used to configure maximum number of
     * delivery attempts and time to live for events.
     * 
     * @return the retryPolicy value.
     */
    public RetryPolicy retryPolicy() {
        return this.retryPolicy;
    }

    /**
     * Set the retryPolicy property: The retry policy for events. This can be used to configure maximum number of
     * delivery attempts and time to live for events.
     * 
     * @param retryPolicy the retryPolicy value to set.
     * @return the EventSubscriptionProperties object itself.
     */
    public EventSubscriptionProperties withRetryPolicy(RetryPolicy retryPolicy) {
        this.retryPolicy = retryPolicy;
        return this;
    }

    /**
     * Get the deadLetterDestination property: The dead letter destination of the event subscription. Any event that
     * cannot be delivered to its' destination is sent to the dead letter destination.
     * Uses Azure Event Grid's identity to acquire the authentication tokens being used during delivery /
     * dead-lettering.
     * 
     * @return the deadLetterDestination value.
     */
    public DeadLetterDestination deadLetterDestination() {
        return this.deadLetterDestination;
    }

    /**
     * Set the deadLetterDestination property: The dead letter destination of the event subscription. Any event that
     * cannot be delivered to its' destination is sent to the dead letter destination.
     * Uses Azure Event Grid's identity to acquire the authentication tokens being used during delivery /
     * dead-lettering.
     * 
     * @param deadLetterDestination the deadLetterDestination value to set.
     * @return the EventSubscriptionProperties object itself.
     */
    public EventSubscriptionProperties withDeadLetterDestination(DeadLetterDestination deadLetterDestination) {
        this.deadLetterDestination = deadLetterDestination;
        return this;
    }

    /**
     * Get the deadLetterWithResourceIdentity property: The dead letter destination of the event subscription. Any event
     * that cannot be delivered to its' destination is sent to the dead letter destination.
     * Uses the managed identity setup on the parent resource (namely, topic or domain) to acquire the authentication
     * tokens being used during delivery / dead-lettering.
     * 
     * @return the deadLetterWithResourceIdentity value.
     */
    public DeadLetterWithResourceIdentity deadLetterWithResourceIdentity() {
        return this.deadLetterWithResourceIdentity;
    }

    /**
     * Set the deadLetterWithResourceIdentity property: The dead letter destination of the event subscription. Any event
     * that cannot be delivered to its' destination is sent to the dead letter destination.
     * Uses the managed identity setup on the parent resource (namely, topic or domain) to acquire the authentication
     * tokens being used during delivery / dead-lettering.
     * 
     * @param deadLetterWithResourceIdentity the deadLetterWithResourceIdentity value to set.
     * @return the EventSubscriptionProperties object itself.
     */
    public EventSubscriptionProperties
        withDeadLetterWithResourceIdentity(DeadLetterWithResourceIdentity deadLetterWithResourceIdentity) {
        this.deadLetterWithResourceIdentity = deadLetterWithResourceIdentity;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (destination() != null) {
            destination().validate();
        }
        if (deliveryWithResourceIdentity() != null) {
            deliveryWithResourceIdentity().validate();
        }
        if (filter() != null) {
            filter().validate();
        }
        if (retryPolicy() != null) {
            retryPolicy().validate();
        }
        if (deadLetterDestination() != null) {
            deadLetterDestination().validate();
        }
        if (deadLetterWithResourceIdentity() != null) {
            deadLetterWithResourceIdentity().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("destination", this.destination);
        jsonWriter.writeJsonField("deliveryWithResourceIdentity", this.deliveryWithResourceIdentity);
        jsonWriter.writeJsonField("filter", this.filter);
        jsonWriter.writeArrayField("labels", this.labels, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("expirationTimeUtc",
            this.expirationTimeUtc == null
                ? null
                : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.expirationTimeUtc));
        jsonWriter.writeStringField("eventDeliverySchema",
            this.eventDeliverySchema == null ? null : this.eventDeliverySchema.toString());
        jsonWriter.writeJsonField("retryPolicy", this.retryPolicy);
        jsonWriter.writeJsonField("deadLetterDestination", this.deadLetterDestination);
        jsonWriter.writeJsonField("deadLetterWithResourceIdentity", this.deadLetterWithResourceIdentity);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of EventSubscriptionProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of EventSubscriptionProperties if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the EventSubscriptionProperties.
     */
    public static EventSubscriptionProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            EventSubscriptionProperties deserializedEventSubscriptionProperties = new EventSubscriptionProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("topic".equals(fieldName)) {
                    deserializedEventSubscriptionProperties.topic = reader.getString();
                } else if ("provisioningState".equals(fieldName)) {
                    deserializedEventSubscriptionProperties.provisioningState
                        = EventSubscriptionProvisioningState.fromString(reader.getString());
                } else if ("destination".equals(fieldName)) {
                    deserializedEventSubscriptionProperties.destination = EventSubscriptionDestination.fromJson(reader);
                } else if ("deliveryWithResourceIdentity".equals(fieldName)) {
                    deserializedEventSubscriptionProperties.deliveryWithResourceIdentity
                        = DeliveryWithResourceIdentity.fromJson(reader);
                } else if ("filter".equals(fieldName)) {
                    deserializedEventSubscriptionProperties.filter = EventSubscriptionFilter.fromJson(reader);
                } else if ("labels".equals(fieldName)) {
                    List<String> labels = reader.readArray(reader1 -> reader1.getString());
                    deserializedEventSubscriptionProperties.labels = labels;
                } else if ("expirationTimeUtc".equals(fieldName)) {
                    deserializedEventSubscriptionProperties.expirationTimeUtc = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("eventDeliverySchema".equals(fieldName)) {
                    deserializedEventSubscriptionProperties.eventDeliverySchema
                        = EventDeliverySchema.fromString(reader.getString());
                } else if ("retryPolicy".equals(fieldName)) {
                    deserializedEventSubscriptionProperties.retryPolicy = RetryPolicy.fromJson(reader);
                } else if ("deadLetterDestination".equals(fieldName)) {
                    deserializedEventSubscriptionProperties.deadLetterDestination
                        = DeadLetterDestination.fromJson(reader);
                } else if ("deadLetterWithResourceIdentity".equals(fieldName)) {
                    deserializedEventSubscriptionProperties.deadLetterWithResourceIdentity
                        = DeadLetterWithResourceIdentity.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedEventSubscriptionProperties;
        });
    }
}
