// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.eventgrid.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Properties of the event type.
 */
@Fluent
public final class EventTypeProperties implements JsonSerializable<EventTypeProperties> {
    /*
     * Display name of the event type.
     */
    private String displayName;

    /*
     * Description of the event type.
     */
    private String description;

    /*
     * URL of the schema for this event type.
     */
    private String schemaUrl;

    /*
     * IsInDefaultSet flag of the event type.
     */
    private Boolean isInDefaultSet;

    /**
     * Creates an instance of EventTypeProperties class.
     */
    public EventTypeProperties() {
    }

    /**
     * Get the displayName property: Display name of the event type.
     * 
     * @return the displayName value.
     */
    public String displayName() {
        return this.displayName;
    }

    /**
     * Set the displayName property: Display name of the event type.
     * 
     * @param displayName the displayName value to set.
     * @return the EventTypeProperties object itself.
     */
    public EventTypeProperties withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    /**
     * Get the description property: Description of the event type.
     * 
     * @return the description value.
     */
    public String description() {
        return this.description;
    }

    /**
     * Set the description property: Description of the event type.
     * 
     * @param description the description value to set.
     * @return the EventTypeProperties object itself.
     */
    public EventTypeProperties withDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * Get the schemaUrl property: URL of the schema for this event type.
     * 
     * @return the schemaUrl value.
     */
    public String schemaUrl() {
        return this.schemaUrl;
    }

    /**
     * Set the schemaUrl property: URL of the schema for this event type.
     * 
     * @param schemaUrl the schemaUrl value to set.
     * @return the EventTypeProperties object itself.
     */
    public EventTypeProperties withSchemaUrl(String schemaUrl) {
        this.schemaUrl = schemaUrl;
        return this;
    }

    /**
     * Get the isInDefaultSet property: IsInDefaultSet flag of the event type.
     * 
     * @return the isInDefaultSet value.
     */
    public Boolean isInDefaultSet() {
        return this.isInDefaultSet;
    }

    /**
     * Set the isInDefaultSet property: IsInDefaultSet flag of the event type.
     * 
     * @param isInDefaultSet the isInDefaultSet value to set.
     * @return the EventTypeProperties object itself.
     */
    public EventTypeProperties withIsInDefaultSet(Boolean isInDefaultSet) {
        this.isInDefaultSet = isInDefaultSet;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("displayName", this.displayName);
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeStringField("schemaUrl", this.schemaUrl);
        jsonWriter.writeBooleanField("isInDefaultSet", this.isInDefaultSet);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of EventTypeProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of EventTypeProperties if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the EventTypeProperties.
     */
    public static EventTypeProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            EventTypeProperties deserializedEventTypeProperties = new EventTypeProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("displayName".equals(fieldName)) {
                    deserializedEventTypeProperties.displayName = reader.getString();
                } else if ("description".equals(fieldName)) {
                    deserializedEventTypeProperties.description = reader.getString();
                } else if ("schemaUrl".equals(fieldName)) {
                    deserializedEventTypeProperties.schemaUrl = reader.getString();
                } else if ("isInDefaultSet".equals(fieldName)) {
                    deserializedEventTypeProperties.isInDefaultSet = reader.getNullable(JsonReader::getBoolean);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedEventTypeProperties;
        });
    }
}
