// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.eventgrid.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Event grid Extension Topic. This is used for getting Event Grid related metrics for Azure resources.
 */
@Fluent
public final class ExtensionTopicInner extends ProxyResource {
    /*
     * Properties of the extension topic.
     */
    private ExtensionTopicProperties innerProperties;

    /*
     * The system metadata relating to the Event Grid resource.
     */
    private SystemData systemData;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of ExtensionTopicInner class.
     */
    public ExtensionTopicInner() {
    }

    /**
     * Get the innerProperties property: Properties of the extension topic.
     * 
     * @return the innerProperties value.
     */
    private ExtensionTopicProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the systemData property: The system metadata relating to the Event Grid resource.
     * 
     * @return the systemData value.
     */
    public SystemData systemData() {
        return this.systemData;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Get the description property: Description of the extension topic.
     * 
     * @return the description value.
     */
    public String description() {
        return this.innerProperties() == null ? null : this.innerProperties().description();
    }

    /**
     * Set the description property: Description of the extension topic.
     * 
     * @param description the description value to set.
     * @return the ExtensionTopicInner object itself.
     */
    public ExtensionTopicInner withDescription(String description) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ExtensionTopicProperties();
        }
        this.innerProperties().withDescription(description);
        return this;
    }

    /**
     * Get the systemTopic property: System topic resource id which is mapped to the source.
     * 
     * @return the systemTopic value.
     */
    public String systemTopic() {
        return this.innerProperties() == null ? null : this.innerProperties().systemTopic();
    }

    /**
     * Set the systemTopic property: System topic resource id which is mapped to the source.
     * 
     * @param systemTopic the systemTopic value to set.
     * @return the ExtensionTopicInner object itself.
     */
    public ExtensionTopicInner withSystemTopic(String systemTopic) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ExtensionTopicProperties();
        }
        this.innerProperties().withSystemTopic(systemTopic);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ExtensionTopicInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ExtensionTopicInner if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ExtensionTopicInner.
     */
    public static ExtensionTopicInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ExtensionTopicInner deserializedExtensionTopicInner = new ExtensionTopicInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedExtensionTopicInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedExtensionTopicInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedExtensionTopicInner.type = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    deserializedExtensionTopicInner.innerProperties = ExtensionTopicProperties.fromJson(reader);
                } else if ("systemData".equals(fieldName)) {
                    deserializedExtensionTopicInner.systemData = SystemData.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedExtensionTopicInner;
        });
    }
}
