// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.eventgrid.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventgrid.models.InboundIpRule;
import com.azure.resourcemanager.eventgrid.models.NamespaceProvisioningState;
import com.azure.resourcemanager.eventgrid.models.PublicNetworkAccess;
import com.azure.resourcemanager.eventgrid.models.TlsVersion;
import com.azure.resourcemanager.eventgrid.models.TopicSpacesConfiguration;
import com.azure.resourcemanager.eventgrid.models.TopicsConfiguration;
import java.io.IOException;
import java.util.List;

/**
 * Properties of the namespace resource.
 */
@Fluent
public final class NamespaceProperties implements JsonSerializable<NamespaceProperties> {
    /*
     * List of private endpoint connections.
     */
    private List<PrivateEndpointConnectionInner> privateEndpointConnections;

    /*
     * Provisioning state of the namespace resource.
     */
    private NamespaceProvisioningState provisioningState;

    /*
     * Topics configuration information for the namespace resource
     */
    private TopicsConfiguration topicsConfiguration;

    /*
     * Topic spaces configuration information for the namespace resource
     */
    private TopicSpacesConfiguration topicSpacesConfiguration;

    /*
     * This is an optional property and it allows the user to specify if the namespace resource supports zone-redundancy
     * capability or not. If this
     * property is not specified explicitly by the user, its default value depends on the following conditions:
     * a. For Availability Zones enabled regions - The default property value would be true.
     * b. For non-Availability Zones enabled regions - The default property value would be false.
     * Once specified, this property cannot be updated.
     */
    private Boolean isZoneRedundant;

    /*
     * This determines if traffic is allowed over public network. By default it is enabled.
     * You can further restrict to specific IPs by configuring <seealso
     * cref="P:Microsoft.Azure.Events.ResourceProvider.Common.Contracts.PubSub.NamespaceProperties.InboundIpRules" />
     */
    private PublicNetworkAccess publicNetworkAccess;

    /*
     * This can be used to restrict traffic from specific IPs instead of all IPs. Note: These are considered only if
     * PublicNetworkAccess is enabled.
     */
    private List<InboundIpRule> inboundIpRules;

    /*
     * Minimum TLS version of the publisher allowed to publish to this namespace. Only TLS version 1.2 is supported.
     */
    private TlsVersion minimumTlsVersionAllowed;

    /**
     * Creates an instance of NamespaceProperties class.
     */
    public NamespaceProperties() {
    }

    /**
     * Get the privateEndpointConnections property: List of private endpoint connections.
     * 
     * @return the privateEndpointConnections value.
     */
    public List<PrivateEndpointConnectionInner> privateEndpointConnections() {
        return this.privateEndpointConnections;
    }

    /**
     * Set the privateEndpointConnections property: List of private endpoint connections.
     * 
     * @param privateEndpointConnections the privateEndpointConnections value to set.
     * @return the NamespaceProperties object itself.
     */
    public NamespaceProperties
        withPrivateEndpointConnections(List<PrivateEndpointConnectionInner> privateEndpointConnections) {
        this.privateEndpointConnections = privateEndpointConnections;
        return this;
    }

    /**
     * Get the provisioningState property: Provisioning state of the namespace resource.
     * 
     * @return the provisioningState value.
     */
    public NamespaceProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get the topicsConfiguration property: Topics configuration information for the namespace resource.
     * 
     * @return the topicsConfiguration value.
     */
    public TopicsConfiguration topicsConfiguration() {
        return this.topicsConfiguration;
    }

    /**
     * Set the topicsConfiguration property: Topics configuration information for the namespace resource.
     * 
     * @param topicsConfiguration the topicsConfiguration value to set.
     * @return the NamespaceProperties object itself.
     */
    public NamespaceProperties withTopicsConfiguration(TopicsConfiguration topicsConfiguration) {
        this.topicsConfiguration = topicsConfiguration;
        return this;
    }

    /**
     * Get the topicSpacesConfiguration property: Topic spaces configuration information for the namespace resource.
     * 
     * @return the topicSpacesConfiguration value.
     */
    public TopicSpacesConfiguration topicSpacesConfiguration() {
        return this.topicSpacesConfiguration;
    }

    /**
     * Set the topicSpacesConfiguration property: Topic spaces configuration information for the namespace resource.
     * 
     * @param topicSpacesConfiguration the topicSpacesConfiguration value to set.
     * @return the NamespaceProperties object itself.
     */
    public NamespaceProperties withTopicSpacesConfiguration(TopicSpacesConfiguration topicSpacesConfiguration) {
        this.topicSpacesConfiguration = topicSpacesConfiguration;
        return this;
    }

    /**
     * Get the isZoneRedundant property: This is an optional property and it allows the user to specify if the namespace
     * resource supports zone-redundancy capability or not. If this
     * property is not specified explicitly by the user, its default value depends on the following conditions:
     * a. For Availability Zones enabled regions - The default property value would be true.
     * b. For non-Availability Zones enabled regions - The default property value would be false.
     * Once specified, this property cannot be updated.
     * 
     * @return the isZoneRedundant value.
     */
    public Boolean isZoneRedundant() {
        return this.isZoneRedundant;
    }

    /**
     * Set the isZoneRedundant property: This is an optional property and it allows the user to specify if the namespace
     * resource supports zone-redundancy capability or not. If this
     * property is not specified explicitly by the user, its default value depends on the following conditions:
     * a. For Availability Zones enabled regions - The default property value would be true.
     * b. For non-Availability Zones enabled regions - The default property value would be false.
     * Once specified, this property cannot be updated.
     * 
     * @param isZoneRedundant the isZoneRedundant value to set.
     * @return the NamespaceProperties object itself.
     */
    public NamespaceProperties withIsZoneRedundant(Boolean isZoneRedundant) {
        this.isZoneRedundant = isZoneRedundant;
        return this;
    }

    /**
     * Get the publicNetworkAccess property: This determines if traffic is allowed over public network. By default it is
     * enabled.
     * You can further restrict to specific IPs by configuring &lt;seealso
     * cref="P:Microsoft.Azure.Events.ResourceProvider.Common.Contracts.PubSub.NamespaceProperties.InboundIpRules"
     * /&gt;.
     * 
     * @return the publicNetworkAccess value.
     */
    public PublicNetworkAccess publicNetworkAccess() {
        return this.publicNetworkAccess;
    }

    /**
     * Set the publicNetworkAccess property: This determines if traffic is allowed over public network. By default it is
     * enabled.
     * You can further restrict to specific IPs by configuring &lt;seealso
     * cref="P:Microsoft.Azure.Events.ResourceProvider.Common.Contracts.PubSub.NamespaceProperties.InboundIpRules"
     * /&gt;.
     * 
     * @param publicNetworkAccess the publicNetworkAccess value to set.
     * @return the NamespaceProperties object itself.
     */
    public NamespaceProperties withPublicNetworkAccess(PublicNetworkAccess publicNetworkAccess) {
        this.publicNetworkAccess = publicNetworkAccess;
        return this;
    }

    /**
     * Get the inboundIpRules property: This can be used to restrict traffic from specific IPs instead of all IPs. Note:
     * These are considered only if PublicNetworkAccess is enabled.
     * 
     * @return the inboundIpRules value.
     */
    public List<InboundIpRule> inboundIpRules() {
        return this.inboundIpRules;
    }

    /**
     * Set the inboundIpRules property: This can be used to restrict traffic from specific IPs instead of all IPs. Note:
     * These are considered only if PublicNetworkAccess is enabled.
     * 
     * @param inboundIpRules the inboundIpRules value to set.
     * @return the NamespaceProperties object itself.
     */
    public NamespaceProperties withInboundIpRules(List<InboundIpRule> inboundIpRules) {
        this.inboundIpRules = inboundIpRules;
        return this;
    }

    /**
     * Get the minimumTlsVersionAllowed property: Minimum TLS version of the publisher allowed to publish to this
     * namespace. Only TLS version 1.2 is supported.
     * 
     * @return the minimumTlsVersionAllowed value.
     */
    public TlsVersion minimumTlsVersionAllowed() {
        return this.minimumTlsVersionAllowed;
    }

    /**
     * Set the minimumTlsVersionAllowed property: Minimum TLS version of the publisher allowed to publish to this
     * namespace. Only TLS version 1.2 is supported.
     * 
     * @param minimumTlsVersionAllowed the minimumTlsVersionAllowed value to set.
     * @return the NamespaceProperties object itself.
     */
    public NamespaceProperties withMinimumTlsVersionAllowed(TlsVersion minimumTlsVersionAllowed) {
        this.minimumTlsVersionAllowed = minimumTlsVersionAllowed;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (privateEndpointConnections() != null) {
            privateEndpointConnections().forEach(e -> e.validate());
        }
        if (topicsConfiguration() != null) {
            topicsConfiguration().validate();
        }
        if (topicSpacesConfiguration() != null) {
            topicSpacesConfiguration().validate();
        }
        if (inboundIpRules() != null) {
            inboundIpRules().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("privateEndpointConnections", this.privateEndpointConnections,
            (writer, element) -> writer.writeJson(element));
        jsonWriter.writeJsonField("topicsConfiguration", this.topicsConfiguration);
        jsonWriter.writeJsonField("topicSpacesConfiguration", this.topicSpacesConfiguration);
        jsonWriter.writeBooleanField("isZoneRedundant", this.isZoneRedundant);
        jsonWriter.writeStringField("publicNetworkAccess",
            this.publicNetworkAccess == null ? null : this.publicNetworkAccess.toString());
        jsonWriter.writeArrayField("inboundIpRules", this.inboundIpRules,
            (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("minimumTlsVersionAllowed",
            this.minimumTlsVersionAllowed == null ? null : this.minimumTlsVersionAllowed.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of NamespaceProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of NamespaceProperties if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the NamespaceProperties.
     */
    public static NamespaceProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            NamespaceProperties deserializedNamespaceProperties = new NamespaceProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("privateEndpointConnections".equals(fieldName)) {
                    List<PrivateEndpointConnectionInner> privateEndpointConnections
                        = reader.readArray(reader1 -> PrivateEndpointConnectionInner.fromJson(reader1));
                    deserializedNamespaceProperties.privateEndpointConnections = privateEndpointConnections;
                } else if ("provisioningState".equals(fieldName)) {
                    deserializedNamespaceProperties.provisioningState
                        = NamespaceProvisioningState.fromString(reader.getString());
                } else if ("topicsConfiguration".equals(fieldName)) {
                    deserializedNamespaceProperties.topicsConfiguration = TopicsConfiguration.fromJson(reader);
                } else if ("topicSpacesConfiguration".equals(fieldName)) {
                    deserializedNamespaceProperties.topicSpacesConfiguration
                        = TopicSpacesConfiguration.fromJson(reader);
                } else if ("isZoneRedundant".equals(fieldName)) {
                    deserializedNamespaceProperties.isZoneRedundant = reader.getNullable(JsonReader::getBoolean);
                } else if ("publicNetworkAccess".equals(fieldName)) {
                    deserializedNamespaceProperties.publicNetworkAccess
                        = PublicNetworkAccess.fromString(reader.getString());
                } else if ("inboundIpRules".equals(fieldName)) {
                    List<InboundIpRule> inboundIpRules = reader.readArray(reader1 -> InboundIpRule.fromJson(reader1));
                    deserializedNamespaceProperties.inboundIpRules = inboundIpRules;
                } else if ("minimumTlsVersionAllowed".equals(fieldName)) {
                    deserializedNamespaceProperties.minimumTlsVersionAllowed
                        = TlsVersion.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedNamespaceProperties;
        });
    }
}
