// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.eventgrid.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Shared access keys of the Namespace.
 */
@Fluent
public final class NamespaceSharedAccessKeysInner implements JsonSerializable<NamespaceSharedAccessKeysInner> {
    /*
     * Shared access key1 for the namespace.
     */
    private String key1;

    /*
     * Shared access key2 for the namespace.
     */
    private String key2;

    /**
     * Creates an instance of NamespaceSharedAccessKeysInner class.
     */
    public NamespaceSharedAccessKeysInner() {
    }

    /**
     * Get the key1 property: Shared access key1 for the namespace.
     * 
     * @return the key1 value.
     */
    public String key1() {
        return this.key1;
    }

    /**
     * Set the key1 property: Shared access key1 for the namespace.
     * 
     * @param key1 the key1 value to set.
     * @return the NamespaceSharedAccessKeysInner object itself.
     */
    public NamespaceSharedAccessKeysInner withKey1(String key1) {
        this.key1 = key1;
        return this;
    }

    /**
     * Get the key2 property: Shared access key2 for the namespace.
     * 
     * @return the key2 value.
     */
    public String key2() {
        return this.key2;
    }

    /**
     * Set the key2 property: Shared access key2 for the namespace.
     * 
     * @param key2 the key2 value to set.
     * @return the NamespaceSharedAccessKeysInner object itself.
     */
    public NamespaceSharedAccessKeysInner withKey2(String key2) {
        this.key2 = key2;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("key1", this.key1);
        jsonWriter.writeStringField("key2", this.key2);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of NamespaceSharedAccessKeysInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of NamespaceSharedAccessKeysInner if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the NamespaceSharedAccessKeysInner.
     */
    public static NamespaceSharedAccessKeysInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            NamespaceSharedAccessKeysInner deserializedNamespaceSharedAccessKeysInner
                = new NamespaceSharedAccessKeysInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("key1".equals(fieldName)) {
                    deserializedNamespaceSharedAccessKeysInner.key1 = reader.getString();
                } else if ("key2".equals(fieldName)) {
                    deserializedNamespaceSharedAccessKeysInner.key2 = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedNamespaceSharedAccessKeysInner;
        });
    }
}
