// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.eventgrid.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The properties that represent the Event Grid Namespace Topic destination of an event subscription.
 */
@Fluent
public final class NamespaceTopicEventSubscriptionDestinationProperties
    implements JsonSerializable<NamespaceTopicEventSubscriptionDestinationProperties> {
    /*
     * The Azure resource Id that represents the endpoint of the Event Grid Namespace Topic destination of an event
     * subscription.
     * This field is required and the Namespace Topic resource listed must already exist.
     * The resource ARM Id should follow this pattern:
     * /subscriptions/{AzureSubscriptionId}/resourceGroups/{ResourceGroupName}/providers/Microsoft.EventGrid/namespaces/
     * {NamespaceName}/topics/{TopicName}.
     */
    private String resourceId;

    /**
     * Creates an instance of NamespaceTopicEventSubscriptionDestinationProperties class.
     */
    public NamespaceTopicEventSubscriptionDestinationProperties() {
    }

    /**
     * Get the resourceId property: The Azure resource Id that represents the endpoint of the Event Grid Namespace Topic
     * destination of an event subscription.
     * This field is required and the Namespace Topic resource listed must already exist.
     * The resource ARM Id should follow this pattern:
     * /subscriptions/{AzureSubscriptionId}/resourceGroups/{ResourceGroupName}/providers/Microsoft.EventGrid/namespaces/{NamespaceName}/topics/{TopicName}.
     * 
     * @return the resourceId value.
     */
    public String resourceId() {
        return this.resourceId;
    }

    /**
     * Set the resourceId property: The Azure resource Id that represents the endpoint of the Event Grid Namespace Topic
     * destination of an event subscription.
     * This field is required and the Namespace Topic resource listed must already exist.
     * The resource ARM Id should follow this pattern:
     * /subscriptions/{AzureSubscriptionId}/resourceGroups/{ResourceGroupName}/providers/Microsoft.EventGrid/namespaces/{NamespaceName}/topics/{TopicName}.
     * 
     * @param resourceId the resourceId value to set.
     * @return the NamespaceTopicEventSubscriptionDestinationProperties object itself.
     */
    public NamespaceTopicEventSubscriptionDestinationProperties withResourceId(String resourceId) {
        this.resourceId = resourceId;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("resourceId", this.resourceId);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of NamespaceTopicEventSubscriptionDestinationProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of NamespaceTopicEventSubscriptionDestinationProperties if the JsonReader was pointing to an
     * instance of it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the NamespaceTopicEventSubscriptionDestinationProperties.
     */
    public static NamespaceTopicEventSubscriptionDestinationProperties fromJson(JsonReader jsonReader)
        throws IOException {
        return jsonReader.readObject(reader -> {
            NamespaceTopicEventSubscriptionDestinationProperties deserializedNamespaceTopicEventSubscriptionDestinationProperties
                = new NamespaceTopicEventSubscriptionDestinationProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("resourceId".equals(fieldName)) {
                    deserializedNamespaceTopicEventSubscriptionDestinationProperties.resourceId = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedNamespaceTopicEventSubscriptionDestinationProperties;
        });
    }
}
