// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.eventgrid.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventgrid.models.EventInputSchema;
import com.azure.resourcemanager.eventgrid.models.NamespaceTopicProvisioningState;
import com.azure.resourcemanager.eventgrid.models.PublisherType;
import java.io.IOException;

/**
 * Namespace topic details.
 */
@Fluent
public final class NamespaceTopicInner extends ProxyResource {
    /*
     * Properties of the namespace topic.
     */
    private NamespaceTopicProperties innerProperties;

    /*
     * The system metadata relating to the Event Grid resource.
     */
    private SystemData systemData;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of NamespaceTopicInner class.
     */
    public NamespaceTopicInner() {
    }

    /**
     * Get the innerProperties property: Properties of the namespace topic.
     * 
     * @return the innerProperties value.
     */
    private NamespaceTopicProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the systemData property: The system metadata relating to the Event Grid resource.
     * 
     * @return the systemData value.
     */
    public SystemData systemData() {
        return this.systemData;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Get the provisioningState property: Provisioning state of the namespace topic.
     * 
     * @return the provisioningState value.
     */
    public NamespaceTopicProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    /**
     * Get the publisherType property: Publisher type of the namespace topic.
     * 
     * @return the publisherType value.
     */
    public PublisherType publisherType() {
        return this.innerProperties() == null ? null : this.innerProperties().publisherType();
    }

    /**
     * Set the publisherType property: Publisher type of the namespace topic.
     * 
     * @param publisherType the publisherType value to set.
     * @return the NamespaceTopicInner object itself.
     */
    public NamespaceTopicInner withPublisherType(PublisherType publisherType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new NamespaceTopicProperties();
        }
        this.innerProperties().withPublisherType(publisherType);
        return this;
    }

    /**
     * Get the inputSchema property: This determines the format that is expected for incoming events published to the
     * topic.
     * 
     * @return the inputSchema value.
     */
    public EventInputSchema inputSchema() {
        return this.innerProperties() == null ? null : this.innerProperties().inputSchema();
    }

    /**
     * Set the inputSchema property: This determines the format that is expected for incoming events published to the
     * topic.
     * 
     * @param inputSchema the inputSchema value to set.
     * @return the NamespaceTopicInner object itself.
     */
    public NamespaceTopicInner withInputSchema(EventInputSchema inputSchema) {
        if (this.innerProperties() == null) {
            this.innerProperties = new NamespaceTopicProperties();
        }
        this.innerProperties().withInputSchema(inputSchema);
        return this;
    }

    /**
     * Get the eventRetentionInDays property: Event retention for the namespace topic expressed in days. The property
     * default value is 1 day.
     * Min event retention duration value is 1 day and max event retention duration value is 1 day.
     * 
     * @return the eventRetentionInDays value.
     */
    public Integer eventRetentionInDays() {
        return this.innerProperties() == null ? null : this.innerProperties().eventRetentionInDays();
    }

    /**
     * Set the eventRetentionInDays property: Event retention for the namespace topic expressed in days. The property
     * default value is 1 day.
     * Min event retention duration value is 1 day and max event retention duration value is 1 day.
     * 
     * @param eventRetentionInDays the eventRetentionInDays value to set.
     * @return the NamespaceTopicInner object itself.
     */
    public NamespaceTopicInner withEventRetentionInDays(Integer eventRetentionInDays) {
        if (this.innerProperties() == null) {
            this.innerProperties = new NamespaceTopicProperties();
        }
        this.innerProperties().withEventRetentionInDays(eventRetentionInDays);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of NamespaceTopicInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of NamespaceTopicInner if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the NamespaceTopicInner.
     */
    public static NamespaceTopicInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            NamespaceTopicInner deserializedNamespaceTopicInner = new NamespaceTopicInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedNamespaceTopicInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedNamespaceTopicInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedNamespaceTopicInner.type = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    deserializedNamespaceTopicInner.innerProperties = NamespaceTopicProperties.fromJson(reader);
                } else if ("systemData".equals(fieldName)) {
                    deserializedNamespaceTopicInner.systemData = SystemData.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedNamespaceTopicInner;
        });
    }
}
