// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.eventgrid.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventgrid.models.EventInputSchema;
import com.azure.resourcemanager.eventgrid.models.NamespaceTopicProvisioningState;
import com.azure.resourcemanager.eventgrid.models.PublisherType;
import java.io.IOException;

/**
 * Properties of the namespace topic.
 */
@Fluent
public final class NamespaceTopicProperties implements JsonSerializable<NamespaceTopicProperties> {
    /*
     * Provisioning state of the namespace topic.
     */
    private NamespaceTopicProvisioningState provisioningState;

    /*
     * Publisher type of the namespace topic.
     */
    private PublisherType publisherType;

    /*
     * This determines the format that is expected for incoming events published to the topic.
     */
    private EventInputSchema inputSchema;

    /*
     * Event retention for the namespace topic expressed in days. The property default value is 1 day.
     * Min event retention duration value is 1 day and max event retention duration value is 1 day.
     */
    private Integer eventRetentionInDays;

    /**
     * Creates an instance of NamespaceTopicProperties class.
     */
    public NamespaceTopicProperties() {
    }

    /**
     * Get the provisioningState property: Provisioning state of the namespace topic.
     * 
     * @return the provisioningState value.
     */
    public NamespaceTopicProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get the publisherType property: Publisher type of the namespace topic.
     * 
     * @return the publisherType value.
     */
    public PublisherType publisherType() {
        return this.publisherType;
    }

    /**
     * Set the publisherType property: Publisher type of the namespace topic.
     * 
     * @param publisherType the publisherType value to set.
     * @return the NamespaceTopicProperties object itself.
     */
    public NamespaceTopicProperties withPublisherType(PublisherType publisherType) {
        this.publisherType = publisherType;
        return this;
    }

    /**
     * Get the inputSchema property: This determines the format that is expected for incoming events published to the
     * topic.
     * 
     * @return the inputSchema value.
     */
    public EventInputSchema inputSchema() {
        return this.inputSchema;
    }

    /**
     * Set the inputSchema property: This determines the format that is expected for incoming events published to the
     * topic.
     * 
     * @param inputSchema the inputSchema value to set.
     * @return the NamespaceTopicProperties object itself.
     */
    public NamespaceTopicProperties withInputSchema(EventInputSchema inputSchema) {
        this.inputSchema = inputSchema;
        return this;
    }

    /**
     * Get the eventRetentionInDays property: Event retention for the namespace topic expressed in days. The property
     * default value is 1 day.
     * Min event retention duration value is 1 day and max event retention duration value is 1 day.
     * 
     * @return the eventRetentionInDays value.
     */
    public Integer eventRetentionInDays() {
        return this.eventRetentionInDays;
    }

    /**
     * Set the eventRetentionInDays property: Event retention for the namespace topic expressed in days. The property
     * default value is 1 day.
     * Min event retention duration value is 1 day and max event retention duration value is 1 day.
     * 
     * @param eventRetentionInDays the eventRetentionInDays value to set.
     * @return the NamespaceTopicProperties object itself.
     */
    public NamespaceTopicProperties withEventRetentionInDays(Integer eventRetentionInDays) {
        this.eventRetentionInDays = eventRetentionInDays;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("publisherType", this.publisherType == null ? null : this.publisherType.toString());
        jsonWriter.writeStringField("inputSchema", this.inputSchema == null ? null : this.inputSchema.toString());
        jsonWriter.writeNumberField("eventRetentionInDays", this.eventRetentionInDays);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of NamespaceTopicProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of NamespaceTopicProperties if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the NamespaceTopicProperties.
     */
    public static NamespaceTopicProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            NamespaceTopicProperties deserializedNamespaceTopicProperties = new NamespaceTopicProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("provisioningState".equals(fieldName)) {
                    deserializedNamespaceTopicProperties.provisioningState
                        = NamespaceTopicProvisioningState.fromString(reader.getString());
                } else if ("publisherType".equals(fieldName)) {
                    deserializedNamespaceTopicProperties.publisherType = PublisherType.fromString(reader.getString());
                } else if ("inputSchema".equals(fieldName)) {
                    deserializedNamespaceTopicProperties.inputSchema = EventInputSchema.fromString(reader.getString());
                } else if ("eventRetentionInDays".equals(fieldName)) {
                    deserializedNamespaceTopicProperties.eventRetentionInDays = reader.getNullable(JsonReader::getInt);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedNamespaceTopicProperties;
        });
    }
}
