// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.eventgrid.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventgrid.models.InboundIpRule;
import com.azure.resourcemanager.eventgrid.models.PublicNetworkAccess;
import com.azure.resourcemanager.eventgrid.models.UpdateTopicSpacesConfigurationInfo;
import com.azure.resourcemanager.eventgrid.models.UpdateTopicsConfigurationInfo;
import java.io.IOException;
import java.util.List;

/**
 * Information of namespace update parameter properties.
 */
@Fluent
public final class NamespaceUpdateParameterProperties implements JsonSerializable<NamespaceUpdateParameterProperties> {
    /*
     * Topic spaces configuration properties that can be updated.
     */
    private UpdateTopicSpacesConfigurationInfo topicSpacesConfiguration;

    /*
     * Topics configuration properties that can be updated.
     */
    private UpdateTopicsConfigurationInfo topicsConfiguration;

    /*
     * This determines if traffic is allowed over public network. By default it is enabled.
     * You can further restrict to specific IPs by configuring <seealso cref=
     * "P:Microsoft.Azure.Events.ResourceProvider.Common.Contracts.PubSub.NamespaceUpdateParameterProperties.InboundIpRules"
     * />
     */
    private PublicNetworkAccess publicNetworkAccess;

    /*
     * This can be used to restrict traffic from specific IPs instead of all IPs. Note: These are considered only if
     * PublicNetworkAccess is enabled.
     */
    private List<InboundIpRule> inboundIpRules;

    /**
     * Creates an instance of NamespaceUpdateParameterProperties class.
     */
    public NamespaceUpdateParameterProperties() {
    }

    /**
     * Get the topicSpacesConfiguration property: Topic spaces configuration properties that can be updated.
     * 
     * @return the topicSpacesConfiguration value.
     */
    public UpdateTopicSpacesConfigurationInfo topicSpacesConfiguration() {
        return this.topicSpacesConfiguration;
    }

    /**
     * Set the topicSpacesConfiguration property: Topic spaces configuration properties that can be updated.
     * 
     * @param topicSpacesConfiguration the topicSpacesConfiguration value to set.
     * @return the NamespaceUpdateParameterProperties object itself.
     */
    public NamespaceUpdateParameterProperties
        withTopicSpacesConfiguration(UpdateTopicSpacesConfigurationInfo topicSpacesConfiguration) {
        this.topicSpacesConfiguration = topicSpacesConfiguration;
        return this;
    }

    /**
     * Get the topicsConfiguration property: Topics configuration properties that can be updated.
     * 
     * @return the topicsConfiguration value.
     */
    public UpdateTopicsConfigurationInfo topicsConfiguration() {
        return this.topicsConfiguration;
    }

    /**
     * Set the topicsConfiguration property: Topics configuration properties that can be updated.
     * 
     * @param topicsConfiguration the topicsConfiguration value to set.
     * @return the NamespaceUpdateParameterProperties object itself.
     */
    public NamespaceUpdateParameterProperties
        withTopicsConfiguration(UpdateTopicsConfigurationInfo topicsConfiguration) {
        this.topicsConfiguration = topicsConfiguration;
        return this;
    }

    /**
     * Get the publicNetworkAccess property: This determines if traffic is allowed over public network. By default it is
     * enabled.
     * You can further restrict to specific IPs by configuring &lt;seealso
     * cref="P:Microsoft.Azure.Events.ResourceProvider.Common.Contracts.PubSub.NamespaceUpdateParameterProperties.InboundIpRules"
     * /&gt;.
     * 
     * @return the publicNetworkAccess value.
     */
    public PublicNetworkAccess publicNetworkAccess() {
        return this.publicNetworkAccess;
    }

    /**
     * Set the publicNetworkAccess property: This determines if traffic is allowed over public network. By default it is
     * enabled.
     * You can further restrict to specific IPs by configuring &lt;seealso
     * cref="P:Microsoft.Azure.Events.ResourceProvider.Common.Contracts.PubSub.NamespaceUpdateParameterProperties.InboundIpRules"
     * /&gt;.
     * 
     * @param publicNetworkAccess the publicNetworkAccess value to set.
     * @return the NamespaceUpdateParameterProperties object itself.
     */
    public NamespaceUpdateParameterProperties withPublicNetworkAccess(PublicNetworkAccess publicNetworkAccess) {
        this.publicNetworkAccess = publicNetworkAccess;
        return this;
    }

    /**
     * Get the inboundIpRules property: This can be used to restrict traffic from specific IPs instead of all IPs. Note:
     * These are considered only if PublicNetworkAccess is enabled.
     * 
     * @return the inboundIpRules value.
     */
    public List<InboundIpRule> inboundIpRules() {
        return this.inboundIpRules;
    }

    /**
     * Set the inboundIpRules property: This can be used to restrict traffic from specific IPs instead of all IPs. Note:
     * These are considered only if PublicNetworkAccess is enabled.
     * 
     * @param inboundIpRules the inboundIpRules value to set.
     * @return the NamespaceUpdateParameterProperties object itself.
     */
    public NamespaceUpdateParameterProperties withInboundIpRules(List<InboundIpRule> inboundIpRules) {
        this.inboundIpRules = inboundIpRules;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (topicSpacesConfiguration() != null) {
            topicSpacesConfiguration().validate();
        }
        if (topicsConfiguration() != null) {
            topicsConfiguration().validate();
        }
        if (inboundIpRules() != null) {
            inboundIpRules().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("topicSpacesConfiguration", this.topicSpacesConfiguration);
        jsonWriter.writeJsonField("topicsConfiguration", this.topicsConfiguration);
        jsonWriter.writeStringField("publicNetworkAccess",
            this.publicNetworkAccess == null ? null : this.publicNetworkAccess.toString());
        jsonWriter.writeArrayField("inboundIpRules", this.inboundIpRules,
            (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of NamespaceUpdateParameterProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of NamespaceUpdateParameterProperties if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the NamespaceUpdateParameterProperties.
     */
    public static NamespaceUpdateParameterProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            NamespaceUpdateParameterProperties deserializedNamespaceUpdateParameterProperties
                = new NamespaceUpdateParameterProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("topicSpacesConfiguration".equals(fieldName)) {
                    deserializedNamespaceUpdateParameterProperties.topicSpacesConfiguration
                        = UpdateTopicSpacesConfigurationInfo.fromJson(reader);
                } else if ("topicsConfiguration".equals(fieldName)) {
                    deserializedNamespaceUpdateParameterProperties.topicsConfiguration
                        = UpdateTopicsConfigurationInfo.fromJson(reader);
                } else if ("publicNetworkAccess".equals(fieldName)) {
                    deserializedNamespaceUpdateParameterProperties.publicNetworkAccess
                        = PublicNetworkAccess.fromString(reader.getString());
                } else if ("inboundIpRules".equals(fieldName)) {
                    List<InboundIpRule> inboundIpRules = reader.readArray(reader1 -> InboundIpRule.fromJson(reader1));
                    deserializedNamespaceUpdateParameterProperties.inboundIpRules = inboundIpRules;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedNamespaceUpdateParameterProperties;
        });
    }
}
