// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.eventgrid.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventgrid.models.PartnerAuthorization;
import com.azure.resourcemanager.eventgrid.models.PartnerConfigurationProvisioningState;
import java.io.IOException;
import java.util.Map;

/**
 * Partner configuration information.
 */
@Fluent
public final class PartnerConfigurationInner extends ProxyResource {
    /*
     * Properties of the partner configuration.
     */
    private PartnerConfigurationProperties innerProperties;

    /*
     * The system metadata relating to the Event Grid resource.
     */
    private SystemData systemData;

    /*
     * Location of the resource.
     */
    private String location;

    /*
     * Tags of the resource.
     */
    private Map<String, String> tags;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of PartnerConfigurationInner class.
     */
    public PartnerConfigurationInner() {
    }

    /**
     * Get the innerProperties property: Properties of the partner configuration.
     * 
     * @return the innerProperties value.
     */
    private PartnerConfigurationProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the systemData property: The system metadata relating to the Event Grid resource.
     * 
     * @return the systemData value.
     */
    public SystemData systemData() {
        return this.systemData;
    }

    /**
     * Get the location property: Location of the resource.
     * 
     * @return the location value.
     */
    public String location() {
        return this.location;
    }

    /**
     * Set the location property: Location of the resource.
     * 
     * @param location the location value to set.
     * @return the PartnerConfigurationInner object itself.
     */
    public PartnerConfigurationInner withLocation(String location) {
        this.location = location;
        return this;
    }

    /**
     * Get the tags property: Tags of the resource.
     * 
     * @return the tags value.
     */
    public Map<String, String> tags() {
        return this.tags;
    }

    /**
     * Set the tags property: Tags of the resource.
     * 
     * @param tags the tags value to set.
     * @return the PartnerConfigurationInner object itself.
     */
    public PartnerConfigurationInner withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Get the partnerAuthorization property: The details of authorized partners.
     * 
     * @return the partnerAuthorization value.
     */
    public PartnerAuthorization partnerAuthorization() {
        return this.innerProperties() == null ? null : this.innerProperties().partnerAuthorization();
    }

    /**
     * Set the partnerAuthorization property: The details of authorized partners.
     * 
     * @param partnerAuthorization the partnerAuthorization value to set.
     * @return the PartnerConfigurationInner object itself.
     */
    public PartnerConfigurationInner withPartnerAuthorization(PartnerAuthorization partnerAuthorization) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PartnerConfigurationProperties();
        }
        this.innerProperties().withPartnerAuthorization(partnerAuthorization);
        return this;
    }

    /**
     * Get the provisioningState property: Provisioning state of the partner configuration.
     * 
     * @return the provisioningState value.
     */
    public PartnerConfigurationProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    /**
     * Set the provisioningState property: Provisioning state of the partner configuration.
     * 
     * @param provisioningState the provisioningState value to set.
     * @return the PartnerConfigurationInner object itself.
     */
    public PartnerConfigurationInner withProvisioningState(PartnerConfigurationProvisioningState provisioningState) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PartnerConfigurationProperties();
        }
        this.innerProperties().withProvisioningState(provisioningState);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerProperties);
        jsonWriter.writeStringField("location", this.location);
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of PartnerConfigurationInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of PartnerConfigurationInner if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the PartnerConfigurationInner.
     */
    public static PartnerConfigurationInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            PartnerConfigurationInner deserializedPartnerConfigurationInner = new PartnerConfigurationInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedPartnerConfigurationInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedPartnerConfigurationInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedPartnerConfigurationInner.type = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    deserializedPartnerConfigurationInner.innerProperties
                        = PartnerConfigurationProperties.fromJson(reader);
                } else if ("systemData".equals(fieldName)) {
                    deserializedPartnerConfigurationInner.systemData = SystemData.fromJson(reader);
                } else if ("location".equals(fieldName)) {
                    deserializedPartnerConfigurationInner.location = reader.getString();
                } else if ("tags".equals(fieldName)) {
                    Map<String, String> tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedPartnerConfigurationInner.tags = tags;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedPartnerConfigurationInner;
        });
    }
}
