// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.eventgrid.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventgrid.models.PartnerAuthorization;
import com.azure.resourcemanager.eventgrid.models.PartnerConfigurationProvisioningState;
import java.io.IOException;

/**
 * Properties of the partner configuration.
 */
@Fluent
public final class PartnerConfigurationProperties implements JsonSerializable<PartnerConfigurationProperties> {
    /*
     * The details of authorized partners.
     */
    private PartnerAuthorization partnerAuthorization;

    /*
     * Provisioning state of the partner configuration.
     */
    private PartnerConfigurationProvisioningState provisioningState;

    /**
     * Creates an instance of PartnerConfigurationProperties class.
     */
    public PartnerConfigurationProperties() {
    }

    /**
     * Get the partnerAuthorization property: The details of authorized partners.
     * 
     * @return the partnerAuthorization value.
     */
    public PartnerAuthorization partnerAuthorization() {
        return this.partnerAuthorization;
    }

    /**
     * Set the partnerAuthorization property: The details of authorized partners.
     * 
     * @param partnerAuthorization the partnerAuthorization value to set.
     * @return the PartnerConfigurationProperties object itself.
     */
    public PartnerConfigurationProperties withPartnerAuthorization(PartnerAuthorization partnerAuthorization) {
        this.partnerAuthorization = partnerAuthorization;
        return this;
    }

    /**
     * Get the provisioningState property: Provisioning state of the partner configuration.
     * 
     * @return the provisioningState value.
     */
    public PartnerConfigurationProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Set the provisioningState property: Provisioning state of the partner configuration.
     * 
     * @param provisioningState the provisioningState value to set.
     * @return the PartnerConfigurationProperties object itself.
     */
    public PartnerConfigurationProperties
        withProvisioningState(PartnerConfigurationProvisioningState provisioningState) {
        this.provisioningState = provisioningState;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (partnerAuthorization() != null) {
            partnerAuthorization().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("partnerAuthorization", this.partnerAuthorization);
        jsonWriter.writeStringField("provisioningState",
            this.provisioningState == null ? null : this.provisioningState.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of PartnerConfigurationProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of PartnerConfigurationProperties if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the PartnerConfigurationProperties.
     */
    public static PartnerConfigurationProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            PartnerConfigurationProperties deserializedPartnerConfigurationProperties
                = new PartnerConfigurationProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("partnerAuthorization".equals(fieldName)) {
                    deserializedPartnerConfigurationProperties.partnerAuthorization
                        = PartnerAuthorization.fromJson(reader);
                } else if ("provisioningState".equals(fieldName)) {
                    deserializedPartnerConfigurationProperties.provisioningState
                        = PartnerConfigurationProvisioningState.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedPartnerConfigurationProperties;
        });
    }
}
