// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.eventgrid.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Information of partner configuration update parameter properties.
 */
@Fluent
public final class PartnerConfigurationUpdateParameterProperties
    implements JsonSerializable<PartnerConfigurationUpdateParameterProperties> {
    /*
     * The default time used to validate the maximum expiration time for each authorized partners in days. Allowed
     * values ar between 1 and 365 days.
     */
    private Integer defaultMaximumExpirationTimeInDays;

    /**
     * Creates an instance of PartnerConfigurationUpdateParameterProperties class.
     */
    public PartnerConfigurationUpdateParameterProperties() {
    }

    /**
     * Get the defaultMaximumExpirationTimeInDays property: The default time used to validate the maximum expiration
     * time for each authorized partners in days. Allowed values ar between 1 and 365 days.
     * 
     * @return the defaultMaximumExpirationTimeInDays value.
     */
    public Integer defaultMaximumExpirationTimeInDays() {
        return this.defaultMaximumExpirationTimeInDays;
    }

    /**
     * Set the defaultMaximumExpirationTimeInDays property: The default time used to validate the maximum expiration
     * time for each authorized partners in days. Allowed values ar between 1 and 365 days.
     * 
     * @param defaultMaximumExpirationTimeInDays the defaultMaximumExpirationTimeInDays value to set.
     * @return the PartnerConfigurationUpdateParameterProperties object itself.
     */
    public PartnerConfigurationUpdateParameterProperties
        withDefaultMaximumExpirationTimeInDays(Integer defaultMaximumExpirationTimeInDays) {
        this.defaultMaximumExpirationTimeInDays = defaultMaximumExpirationTimeInDays;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("defaultMaximumExpirationTimeInDays", this.defaultMaximumExpirationTimeInDays);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of PartnerConfigurationUpdateParameterProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of PartnerConfigurationUpdateParameterProperties if the JsonReader was pointing to an
     * instance of it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the PartnerConfigurationUpdateParameterProperties.
     */
    public static PartnerConfigurationUpdateParameterProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            PartnerConfigurationUpdateParameterProperties deserializedPartnerConfigurationUpdateParameterProperties
                = new PartnerConfigurationUpdateParameterProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("defaultMaximumExpirationTimeInDays".equals(fieldName)) {
                    deserializedPartnerConfigurationUpdateParameterProperties.defaultMaximumExpirationTimeInDays
                        = reader.getNullable(JsonReader::getInt);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedPartnerConfigurationUpdateParameterProperties;
        });
    }
}
