// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.eventgrid.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventgrid.models.InboundIpRule;
import com.azure.resourcemanager.eventgrid.models.PublicNetworkAccess;
import com.azure.resourcemanager.eventgrid.models.TlsVersion;
import java.io.IOException;
import java.util.List;

/**
 * Information of Partner Namespace update parameter properties.
 */
@Fluent
public final class PartnerNamespaceUpdateParameterProperties
    implements JsonSerializable<PartnerNamespaceUpdateParameterProperties> {
    /*
     * This determines if traffic is allowed over public network. By default it is enabled.
     * You can further restrict to specific IPs by configuring <seealso cref=
     * "P:Microsoft.Azure.Events.ResourceProvider.Common.Contracts.PartnerNamespaceUpdateParameterProperties.InboundIpRules"
     * />
     */
    private PublicNetworkAccess publicNetworkAccess;

    /*
     * This can be used to restrict traffic from specific IPs instead of all IPs. Note: These are considered only if
     * PublicNetworkAccess is enabled.
     */
    private List<InboundIpRule> inboundIpRules;

    /*
     * Minimum TLS version of the publisher allowed to publish to this domain
     */
    private TlsVersion minimumTlsVersionAllowed;

    /*
     * This boolean is used to enable or disable local auth. Default value is false. When the property is set to true,
     * only AAD token will be used to authenticate if user is allowed to publish to the partner namespace.
     */
    private Boolean disableLocalAuth;

    /**
     * Creates an instance of PartnerNamespaceUpdateParameterProperties class.
     */
    public PartnerNamespaceUpdateParameterProperties() {
    }

    /**
     * Get the publicNetworkAccess property: This determines if traffic is allowed over public network. By default it is
     * enabled.
     * You can further restrict to specific IPs by configuring &lt;seealso
     * cref="P:Microsoft.Azure.Events.ResourceProvider.Common.Contracts.PartnerNamespaceUpdateParameterProperties.InboundIpRules"
     * /&gt;.
     * 
     * @return the publicNetworkAccess value.
     */
    public PublicNetworkAccess publicNetworkAccess() {
        return this.publicNetworkAccess;
    }

    /**
     * Set the publicNetworkAccess property: This determines if traffic is allowed over public network. By default it is
     * enabled.
     * You can further restrict to specific IPs by configuring &lt;seealso
     * cref="P:Microsoft.Azure.Events.ResourceProvider.Common.Contracts.PartnerNamespaceUpdateParameterProperties.InboundIpRules"
     * /&gt;.
     * 
     * @param publicNetworkAccess the publicNetworkAccess value to set.
     * @return the PartnerNamespaceUpdateParameterProperties object itself.
     */
    public PartnerNamespaceUpdateParameterProperties withPublicNetworkAccess(PublicNetworkAccess publicNetworkAccess) {
        this.publicNetworkAccess = publicNetworkAccess;
        return this;
    }

    /**
     * Get the inboundIpRules property: This can be used to restrict traffic from specific IPs instead of all IPs. Note:
     * These are considered only if PublicNetworkAccess is enabled.
     * 
     * @return the inboundIpRules value.
     */
    public List<InboundIpRule> inboundIpRules() {
        return this.inboundIpRules;
    }

    /**
     * Set the inboundIpRules property: This can be used to restrict traffic from specific IPs instead of all IPs. Note:
     * These are considered only if PublicNetworkAccess is enabled.
     * 
     * @param inboundIpRules the inboundIpRules value to set.
     * @return the PartnerNamespaceUpdateParameterProperties object itself.
     */
    public PartnerNamespaceUpdateParameterProperties withInboundIpRules(List<InboundIpRule> inboundIpRules) {
        this.inboundIpRules = inboundIpRules;
        return this;
    }

    /**
     * Get the minimumTlsVersionAllowed property: Minimum TLS version of the publisher allowed to publish to this
     * domain.
     * 
     * @return the minimumTlsVersionAllowed value.
     */
    public TlsVersion minimumTlsVersionAllowed() {
        return this.minimumTlsVersionAllowed;
    }

    /**
     * Set the minimumTlsVersionAllowed property: Minimum TLS version of the publisher allowed to publish to this
     * domain.
     * 
     * @param minimumTlsVersionAllowed the minimumTlsVersionAllowed value to set.
     * @return the PartnerNamespaceUpdateParameterProperties object itself.
     */
    public PartnerNamespaceUpdateParameterProperties withMinimumTlsVersionAllowed(TlsVersion minimumTlsVersionAllowed) {
        this.minimumTlsVersionAllowed = minimumTlsVersionAllowed;
        return this;
    }

    /**
     * Get the disableLocalAuth property: This boolean is used to enable or disable local auth. Default value is false.
     * When the property is set to true, only AAD token will be used to authenticate if user is allowed to publish to
     * the partner namespace.
     * 
     * @return the disableLocalAuth value.
     */
    public Boolean disableLocalAuth() {
        return this.disableLocalAuth;
    }

    /**
     * Set the disableLocalAuth property: This boolean is used to enable or disable local auth. Default value is false.
     * When the property is set to true, only AAD token will be used to authenticate if user is allowed to publish to
     * the partner namespace.
     * 
     * @param disableLocalAuth the disableLocalAuth value to set.
     * @return the PartnerNamespaceUpdateParameterProperties object itself.
     */
    public PartnerNamespaceUpdateParameterProperties withDisableLocalAuth(Boolean disableLocalAuth) {
        this.disableLocalAuth = disableLocalAuth;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (inboundIpRules() != null) {
            inboundIpRules().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("publicNetworkAccess",
            this.publicNetworkAccess == null ? null : this.publicNetworkAccess.toString());
        jsonWriter.writeArrayField("inboundIpRules", this.inboundIpRules,
            (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("minimumTlsVersionAllowed",
            this.minimumTlsVersionAllowed == null ? null : this.minimumTlsVersionAllowed.toString());
        jsonWriter.writeBooleanField("disableLocalAuth", this.disableLocalAuth);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of PartnerNamespaceUpdateParameterProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of PartnerNamespaceUpdateParameterProperties if the JsonReader was pointing to an instance of
     * it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the PartnerNamespaceUpdateParameterProperties.
     */
    public static PartnerNamespaceUpdateParameterProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            PartnerNamespaceUpdateParameterProperties deserializedPartnerNamespaceUpdateParameterProperties
                = new PartnerNamespaceUpdateParameterProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("publicNetworkAccess".equals(fieldName)) {
                    deserializedPartnerNamespaceUpdateParameterProperties.publicNetworkAccess
                        = PublicNetworkAccess.fromString(reader.getString());
                } else if ("inboundIpRules".equals(fieldName)) {
                    List<InboundIpRule> inboundIpRules = reader.readArray(reader1 -> InboundIpRule.fromJson(reader1));
                    deserializedPartnerNamespaceUpdateParameterProperties.inboundIpRules = inboundIpRules;
                } else if ("minimumTlsVersionAllowed".equals(fieldName)) {
                    deserializedPartnerNamespaceUpdateParameterProperties.minimumTlsVersionAllowed
                        = TlsVersion.fromString(reader.getString());
                } else if ("disableLocalAuth".equals(fieldName)) {
                    deserializedPartnerNamespaceUpdateParameterProperties.disableLocalAuth
                        = reader.getNullable(JsonReader::getBoolean);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedPartnerNamespaceUpdateParameterProperties;
        });
    }
}
