// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.eventgrid.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.Resource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventgrid.models.PartnerRegistrationProvisioningState;
import java.io.IOException;
import java.util.Map;
import java.util.UUID;

/**
 * Information about a partner registration.
 */
@Fluent
public final class PartnerRegistrationInner extends Resource {
    /*
     * Properties of the partner registration.
     */
    private PartnerRegistrationProperties innerProperties;

    /*
     * The system metadata relating to the Event Grid resource.
     */
    private SystemData systemData;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of PartnerRegistrationInner class.
     */
    public PartnerRegistrationInner() {
    }

    /**
     * Get the innerProperties property: Properties of the partner registration.
     * 
     * @return the innerProperties value.
     */
    private PartnerRegistrationProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the systemData property: The system metadata relating to the Event Grid resource.
     * 
     * @return the systemData value.
     */
    public SystemData systemData() {
        return this.systemData;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public PartnerRegistrationInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public PartnerRegistrationInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    /**
     * Get the provisioningState property: Provisioning state of the partner registration.
     * 
     * @return the provisioningState value.
     */
    public PartnerRegistrationProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    /**
     * Get the partnerRegistrationImmutableId property: The immutableId of the corresponding partner registration.
     * Note: This property is marked for deprecation and is not supported in any future GA API version.
     * 
     * @return the partnerRegistrationImmutableId value.
     */
    public UUID partnerRegistrationImmutableId() {
        return this.innerProperties() == null ? null : this.innerProperties().partnerRegistrationImmutableId();
    }

    /**
     * Set the partnerRegistrationImmutableId property: The immutableId of the corresponding partner registration.
     * Note: This property is marked for deprecation and is not supported in any future GA API version.
     * 
     * @param partnerRegistrationImmutableId the partnerRegistrationImmutableId value to set.
     * @return the PartnerRegistrationInner object itself.
     */
    public PartnerRegistrationInner withPartnerRegistrationImmutableId(UUID partnerRegistrationImmutableId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PartnerRegistrationProperties();
        }
        this.innerProperties().withPartnerRegistrationImmutableId(partnerRegistrationImmutableId);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", location());
        jsonWriter.writeMapField("tags", tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of PartnerRegistrationInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of PartnerRegistrationInner if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the PartnerRegistrationInner.
     */
    public static PartnerRegistrationInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            PartnerRegistrationInner deserializedPartnerRegistrationInner = new PartnerRegistrationInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedPartnerRegistrationInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedPartnerRegistrationInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedPartnerRegistrationInner.type = reader.getString();
                } else if ("location".equals(fieldName)) {
                    deserializedPartnerRegistrationInner.withLocation(reader.getString());
                } else if ("tags".equals(fieldName)) {
                    Map<String, String> tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedPartnerRegistrationInner.withTags(tags);
                } else if ("properties".equals(fieldName)) {
                    deserializedPartnerRegistrationInner.innerProperties
                        = PartnerRegistrationProperties.fromJson(reader);
                } else if ("systemData".equals(fieldName)) {
                    deserializedPartnerRegistrationInner.systemData = SystemData.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedPartnerRegistrationInner;
        });
    }
}
