// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.eventgrid.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventgrid.models.PartnerRegistrationProvisioningState;
import java.io.IOException;
import java.util.Objects;
import java.util.UUID;

/**
 * Properties of the partner registration.
 */
@Fluent
public final class PartnerRegistrationProperties implements JsonSerializable<PartnerRegistrationProperties> {
    /*
     * Provisioning state of the partner registration.
     */
    private PartnerRegistrationProvisioningState provisioningState;

    /*
     * The immutableId of the corresponding partner registration.
     * Note: This property is marked for deprecation and is not supported in any future GA API version
     */
    private UUID partnerRegistrationImmutableId;

    /**
     * Creates an instance of PartnerRegistrationProperties class.
     */
    public PartnerRegistrationProperties() {
    }

    /**
     * Get the provisioningState property: Provisioning state of the partner registration.
     * 
     * @return the provisioningState value.
     */
    public PartnerRegistrationProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get the partnerRegistrationImmutableId property: The immutableId of the corresponding partner registration.
     * Note: This property is marked for deprecation and is not supported in any future GA API version.
     * 
     * @return the partnerRegistrationImmutableId value.
     */
    public UUID partnerRegistrationImmutableId() {
        return this.partnerRegistrationImmutableId;
    }

    /**
     * Set the partnerRegistrationImmutableId property: The immutableId of the corresponding partner registration.
     * Note: This property is marked for deprecation and is not supported in any future GA API version.
     * 
     * @param partnerRegistrationImmutableId the partnerRegistrationImmutableId value to set.
     * @return the PartnerRegistrationProperties object itself.
     */
    public PartnerRegistrationProperties withPartnerRegistrationImmutableId(UUID partnerRegistrationImmutableId) {
        this.partnerRegistrationImmutableId = partnerRegistrationImmutableId;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("partnerRegistrationImmutableId",
            Objects.toString(this.partnerRegistrationImmutableId, null));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of PartnerRegistrationProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of PartnerRegistrationProperties if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the PartnerRegistrationProperties.
     */
    public static PartnerRegistrationProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            PartnerRegistrationProperties deserializedPartnerRegistrationProperties
                = new PartnerRegistrationProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("provisioningState".equals(fieldName)) {
                    deserializedPartnerRegistrationProperties.provisioningState
                        = PartnerRegistrationProvisioningState.fromString(reader.getString());
                } else if ("partnerRegistrationImmutableId".equals(fieldName)) {
                    deserializedPartnerRegistrationProperties.partnerRegistrationImmutableId
                        = reader.getNullable(nonNullReader -> UUID.fromString(nonNullReader.getString()));
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedPartnerRegistrationProperties;
        });
    }
}
