// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.eventgrid.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.Resource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventgrid.models.EventTypeInfo;
import com.azure.resourcemanager.eventgrid.models.IdentityInfo;
import com.azure.resourcemanager.eventgrid.models.PartnerTopicActivationState;
import com.azure.resourcemanager.eventgrid.models.PartnerTopicProvisioningState;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.Map;
import java.util.UUID;

/**
 * Event Grid Partner Topic.
 */
@Fluent
public final class PartnerTopicInner extends Resource {
    /*
     * Properties of the Partner Topic.
     */
    private PartnerTopicProperties innerProperties;

    /*
     * The system metadata relating to the Event Grid resource.
     */
    private SystemData systemData;

    /*
     * Identity information for the Partner Topic resource.
     */
    private IdentityInfo identity;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of PartnerTopicInner class.
     */
    public PartnerTopicInner() {
    }

    /**
     * Get the innerProperties property: Properties of the Partner Topic.
     * 
     * @return the innerProperties value.
     */
    private PartnerTopicProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the systemData property: The system metadata relating to the Event Grid resource.
     * 
     * @return the systemData value.
     */
    public SystemData systemData() {
        return this.systemData;
    }

    /**
     * Get the identity property: Identity information for the Partner Topic resource.
     * 
     * @return the identity value.
     */
    public IdentityInfo identity() {
        return this.identity;
    }

    /**
     * Set the identity property: Identity information for the Partner Topic resource.
     * 
     * @param identity the identity value to set.
     * @return the PartnerTopicInner object itself.
     */
    public PartnerTopicInner withIdentity(IdentityInfo identity) {
        this.identity = identity;
        return this;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public PartnerTopicInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public PartnerTopicInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    /**
     * Get the partnerRegistrationImmutableId property: The immutableId of the corresponding partner registration.
     * 
     * @return the partnerRegistrationImmutableId value.
     */
    public UUID partnerRegistrationImmutableId() {
        return this.innerProperties() == null ? null : this.innerProperties().partnerRegistrationImmutableId();
    }

    /**
     * Set the partnerRegistrationImmutableId property: The immutableId of the corresponding partner registration.
     * 
     * @param partnerRegistrationImmutableId the partnerRegistrationImmutableId value to set.
     * @return the PartnerTopicInner object itself.
     */
    public PartnerTopicInner withPartnerRegistrationImmutableId(UUID partnerRegistrationImmutableId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PartnerTopicProperties();
        }
        this.innerProperties().withPartnerRegistrationImmutableId(partnerRegistrationImmutableId);
        return this;
    }

    /**
     * Get the source property: Source associated with this partner topic. This represents a unique partner resource.
     * 
     * @return the source value.
     */
    public String source() {
        return this.innerProperties() == null ? null : this.innerProperties().source();
    }

    /**
     * Set the source property: Source associated with this partner topic. This represents a unique partner resource.
     * 
     * @param source the source value to set.
     * @return the PartnerTopicInner object itself.
     */
    public PartnerTopicInner withSource(String source) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PartnerTopicProperties();
        }
        this.innerProperties().withSource(source);
        return this;
    }

    /**
     * Get the eventTypeInfo property: Event Type information from the corresponding event channel.
     * 
     * @return the eventTypeInfo value.
     */
    public EventTypeInfo eventTypeInfo() {
        return this.innerProperties() == null ? null : this.innerProperties().eventTypeInfo();
    }

    /**
     * Set the eventTypeInfo property: Event Type information from the corresponding event channel.
     * 
     * @param eventTypeInfo the eventTypeInfo value to set.
     * @return the PartnerTopicInner object itself.
     */
    public PartnerTopicInner withEventTypeInfo(EventTypeInfo eventTypeInfo) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PartnerTopicProperties();
        }
        this.innerProperties().withEventTypeInfo(eventTypeInfo);
        return this;
    }

    /**
     * Get the expirationTimeIfNotActivatedUtc property: Expiration time of the partner topic. If this timer expires
     * while the partner topic is still never activated,
     * the partner topic and corresponding event channel are deleted.
     * 
     * @return the expirationTimeIfNotActivatedUtc value.
     */
    public OffsetDateTime expirationTimeIfNotActivatedUtc() {
        return this.innerProperties() == null ? null : this.innerProperties().expirationTimeIfNotActivatedUtc();
    }

    /**
     * Set the expirationTimeIfNotActivatedUtc property: Expiration time of the partner topic. If this timer expires
     * while the partner topic is still never activated,
     * the partner topic and corresponding event channel are deleted.
     * 
     * @param expirationTimeIfNotActivatedUtc the expirationTimeIfNotActivatedUtc value to set.
     * @return the PartnerTopicInner object itself.
     */
    public PartnerTopicInner withExpirationTimeIfNotActivatedUtc(OffsetDateTime expirationTimeIfNotActivatedUtc) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PartnerTopicProperties();
        }
        this.innerProperties().withExpirationTimeIfNotActivatedUtc(expirationTimeIfNotActivatedUtc);
        return this;
    }

    /**
     * Get the provisioningState property: Provisioning state of the partner topic.
     * 
     * @return the provisioningState value.
     */
    public PartnerTopicProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    /**
     * Get the activationState property: Activation state of the partner topic.
     * 
     * @return the activationState value.
     */
    public PartnerTopicActivationState activationState() {
        return this.innerProperties() == null ? null : this.innerProperties().activationState();
    }

    /**
     * Set the activationState property: Activation state of the partner topic.
     * 
     * @param activationState the activationState value to set.
     * @return the PartnerTopicInner object itself.
     */
    public PartnerTopicInner withActivationState(PartnerTopicActivationState activationState) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PartnerTopicProperties();
        }
        this.innerProperties().withActivationState(activationState);
        return this;
    }

    /**
     * Get the partnerTopicFriendlyDescription property: Friendly description about the topic. This can be set by the
     * publisher/partner to show custom description for the customer partner topic.
     * This will be helpful to remove any ambiguity of the origin of creation of the partner topic for the customer.
     * 
     * @return the partnerTopicFriendlyDescription value.
     */
    public String partnerTopicFriendlyDescription() {
        return this.innerProperties() == null ? null : this.innerProperties().partnerTopicFriendlyDescription();
    }

    /**
     * Set the partnerTopicFriendlyDescription property: Friendly description about the topic. This can be set by the
     * publisher/partner to show custom description for the customer partner topic.
     * This will be helpful to remove any ambiguity of the origin of creation of the partner topic for the customer.
     * 
     * @param partnerTopicFriendlyDescription the partnerTopicFriendlyDescription value to set.
     * @return the PartnerTopicInner object itself.
     */
    public PartnerTopicInner withPartnerTopicFriendlyDescription(String partnerTopicFriendlyDescription) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PartnerTopicProperties();
        }
        this.innerProperties().withPartnerTopicFriendlyDescription(partnerTopicFriendlyDescription);
        return this;
    }

    /**
     * Get the messageForActivation property: Context or helpful message that can be used during the approval process by
     * the subscriber.
     * 
     * @return the messageForActivation value.
     */
    public String messageForActivation() {
        return this.innerProperties() == null ? null : this.innerProperties().messageForActivation();
    }

    /**
     * Set the messageForActivation property: Context or helpful message that can be used during the approval process by
     * the subscriber.
     * 
     * @param messageForActivation the messageForActivation value to set.
     * @return the PartnerTopicInner object itself.
     */
    public PartnerTopicInner withMessageForActivation(String messageForActivation) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PartnerTopicProperties();
        }
        this.innerProperties().withMessageForActivation(messageForActivation);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
        if (identity() != null) {
            identity().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", location());
        jsonWriter.writeMapField("tags", tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", this.innerProperties);
        jsonWriter.writeJsonField("identity", this.identity);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of PartnerTopicInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of PartnerTopicInner if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the PartnerTopicInner.
     */
    public static PartnerTopicInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            PartnerTopicInner deserializedPartnerTopicInner = new PartnerTopicInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedPartnerTopicInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedPartnerTopicInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedPartnerTopicInner.type = reader.getString();
                } else if ("location".equals(fieldName)) {
                    deserializedPartnerTopicInner.withLocation(reader.getString());
                } else if ("tags".equals(fieldName)) {
                    Map<String, String> tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedPartnerTopicInner.withTags(tags);
                } else if ("properties".equals(fieldName)) {
                    deserializedPartnerTopicInner.innerProperties = PartnerTopicProperties.fromJson(reader);
                } else if ("systemData".equals(fieldName)) {
                    deserializedPartnerTopicInner.systemData = SystemData.fromJson(reader);
                } else if ("identity".equals(fieldName)) {
                    deserializedPartnerTopicInner.identity = IdentityInfo.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedPartnerTopicInner;
        });
    }
}
