// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.eventgrid.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventgrid.models.EventTypeInfo;
import com.azure.resourcemanager.eventgrid.models.PartnerTopicActivationState;
import com.azure.resourcemanager.eventgrid.models.PartnerTopicProvisioningState;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import java.util.UUID;

/**
 * Properties of the Partner Topic.
 */
@Fluent
public final class PartnerTopicProperties implements JsonSerializable<PartnerTopicProperties> {
    /*
     * The immutableId of the corresponding partner registration.
     */
    private UUID partnerRegistrationImmutableId;

    /*
     * Source associated with this partner topic. This represents a unique partner resource.
     */
    private String source;

    /*
     * Event Type information from the corresponding event channel.
     */
    private EventTypeInfo eventTypeInfo;

    /*
     * Expiration time of the partner topic. If this timer expires while the partner topic is still never activated,
     * the partner topic and corresponding event channel are deleted.
     */
    private OffsetDateTime expirationTimeIfNotActivatedUtc;

    /*
     * Provisioning state of the partner topic.
     */
    private PartnerTopicProvisioningState provisioningState;

    /*
     * Activation state of the partner topic.
     */
    private PartnerTopicActivationState activationState;

    /*
     * Friendly description about the topic. This can be set by the publisher/partner to show custom description for the
     * customer partner topic.
     * This will be helpful to remove any ambiguity of the origin of creation of the partner topic for the customer.
     */
    private String partnerTopicFriendlyDescription;

    /*
     * Context or helpful message that can be used during the approval process by the subscriber.
     */
    private String messageForActivation;

    /**
     * Creates an instance of PartnerTopicProperties class.
     */
    public PartnerTopicProperties() {
    }

    /**
     * Get the partnerRegistrationImmutableId property: The immutableId of the corresponding partner registration.
     * 
     * @return the partnerRegistrationImmutableId value.
     */
    public UUID partnerRegistrationImmutableId() {
        return this.partnerRegistrationImmutableId;
    }

    /**
     * Set the partnerRegistrationImmutableId property: The immutableId of the corresponding partner registration.
     * 
     * @param partnerRegistrationImmutableId the partnerRegistrationImmutableId value to set.
     * @return the PartnerTopicProperties object itself.
     */
    public PartnerTopicProperties withPartnerRegistrationImmutableId(UUID partnerRegistrationImmutableId) {
        this.partnerRegistrationImmutableId = partnerRegistrationImmutableId;
        return this;
    }

    /**
     * Get the source property: Source associated with this partner topic. This represents a unique partner resource.
     * 
     * @return the source value.
     */
    public String source() {
        return this.source;
    }

    /**
     * Set the source property: Source associated with this partner topic. This represents a unique partner resource.
     * 
     * @param source the source value to set.
     * @return the PartnerTopicProperties object itself.
     */
    public PartnerTopicProperties withSource(String source) {
        this.source = source;
        return this;
    }

    /**
     * Get the eventTypeInfo property: Event Type information from the corresponding event channel.
     * 
     * @return the eventTypeInfo value.
     */
    public EventTypeInfo eventTypeInfo() {
        return this.eventTypeInfo;
    }

    /**
     * Set the eventTypeInfo property: Event Type information from the corresponding event channel.
     * 
     * @param eventTypeInfo the eventTypeInfo value to set.
     * @return the PartnerTopicProperties object itself.
     */
    public PartnerTopicProperties withEventTypeInfo(EventTypeInfo eventTypeInfo) {
        this.eventTypeInfo = eventTypeInfo;
        return this;
    }

    /**
     * Get the expirationTimeIfNotActivatedUtc property: Expiration time of the partner topic. If this timer expires
     * while the partner topic is still never activated,
     * the partner topic and corresponding event channel are deleted.
     * 
     * @return the expirationTimeIfNotActivatedUtc value.
     */
    public OffsetDateTime expirationTimeIfNotActivatedUtc() {
        return this.expirationTimeIfNotActivatedUtc;
    }

    /**
     * Set the expirationTimeIfNotActivatedUtc property: Expiration time of the partner topic. If this timer expires
     * while the partner topic is still never activated,
     * the partner topic and corresponding event channel are deleted.
     * 
     * @param expirationTimeIfNotActivatedUtc the expirationTimeIfNotActivatedUtc value to set.
     * @return the PartnerTopicProperties object itself.
     */
    public PartnerTopicProperties withExpirationTimeIfNotActivatedUtc(OffsetDateTime expirationTimeIfNotActivatedUtc) {
        this.expirationTimeIfNotActivatedUtc = expirationTimeIfNotActivatedUtc;
        return this;
    }

    /**
     * Get the provisioningState property: Provisioning state of the partner topic.
     * 
     * @return the provisioningState value.
     */
    public PartnerTopicProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get the activationState property: Activation state of the partner topic.
     * 
     * @return the activationState value.
     */
    public PartnerTopicActivationState activationState() {
        return this.activationState;
    }

    /**
     * Set the activationState property: Activation state of the partner topic.
     * 
     * @param activationState the activationState value to set.
     * @return the PartnerTopicProperties object itself.
     */
    public PartnerTopicProperties withActivationState(PartnerTopicActivationState activationState) {
        this.activationState = activationState;
        return this;
    }

    /**
     * Get the partnerTopicFriendlyDescription property: Friendly description about the topic. This can be set by the
     * publisher/partner to show custom description for the customer partner topic.
     * This will be helpful to remove any ambiguity of the origin of creation of the partner topic for the customer.
     * 
     * @return the partnerTopicFriendlyDescription value.
     */
    public String partnerTopicFriendlyDescription() {
        return this.partnerTopicFriendlyDescription;
    }

    /**
     * Set the partnerTopicFriendlyDescription property: Friendly description about the topic. This can be set by the
     * publisher/partner to show custom description for the customer partner topic.
     * This will be helpful to remove any ambiguity of the origin of creation of the partner topic for the customer.
     * 
     * @param partnerTopicFriendlyDescription the partnerTopicFriendlyDescription value to set.
     * @return the PartnerTopicProperties object itself.
     */
    public PartnerTopicProperties withPartnerTopicFriendlyDescription(String partnerTopicFriendlyDescription) {
        this.partnerTopicFriendlyDescription = partnerTopicFriendlyDescription;
        return this;
    }

    /**
     * Get the messageForActivation property: Context or helpful message that can be used during the approval process by
     * the subscriber.
     * 
     * @return the messageForActivation value.
     */
    public String messageForActivation() {
        return this.messageForActivation;
    }

    /**
     * Set the messageForActivation property: Context or helpful message that can be used during the approval process by
     * the subscriber.
     * 
     * @param messageForActivation the messageForActivation value to set.
     * @return the PartnerTopicProperties object itself.
     */
    public PartnerTopicProperties withMessageForActivation(String messageForActivation) {
        this.messageForActivation = messageForActivation;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (eventTypeInfo() != null) {
            eventTypeInfo().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("partnerRegistrationImmutableId",
            Objects.toString(this.partnerRegistrationImmutableId, null));
        jsonWriter.writeStringField("source", this.source);
        jsonWriter.writeJsonField("eventTypeInfo", this.eventTypeInfo);
        jsonWriter.writeStringField("expirationTimeIfNotActivatedUtc",
            this.expirationTimeIfNotActivatedUtc == null
                ? null
                : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.expirationTimeIfNotActivatedUtc));
        jsonWriter.writeStringField("activationState",
            this.activationState == null ? null : this.activationState.toString());
        jsonWriter.writeStringField("partnerTopicFriendlyDescription", this.partnerTopicFriendlyDescription);
        jsonWriter.writeStringField("messageForActivation", this.messageForActivation);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of PartnerTopicProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of PartnerTopicProperties if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the PartnerTopicProperties.
     */
    public static PartnerTopicProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            PartnerTopicProperties deserializedPartnerTopicProperties = new PartnerTopicProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("partnerRegistrationImmutableId".equals(fieldName)) {
                    deserializedPartnerTopicProperties.partnerRegistrationImmutableId
                        = reader.getNullable(nonNullReader -> UUID.fromString(nonNullReader.getString()));
                } else if ("source".equals(fieldName)) {
                    deserializedPartnerTopicProperties.source = reader.getString();
                } else if ("eventTypeInfo".equals(fieldName)) {
                    deserializedPartnerTopicProperties.eventTypeInfo = EventTypeInfo.fromJson(reader);
                } else if ("expirationTimeIfNotActivatedUtc".equals(fieldName)) {
                    deserializedPartnerTopicProperties.expirationTimeIfNotActivatedUtc = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("provisioningState".equals(fieldName)) {
                    deserializedPartnerTopicProperties.provisioningState
                        = PartnerTopicProvisioningState.fromString(reader.getString());
                } else if ("activationState".equals(fieldName)) {
                    deserializedPartnerTopicProperties.activationState
                        = PartnerTopicActivationState.fromString(reader.getString());
                } else if ("partnerTopicFriendlyDescription".equals(fieldName)) {
                    deserializedPartnerTopicProperties.partnerTopicFriendlyDescription = reader.getString();
                } else if ("messageForActivation".equals(fieldName)) {
                    deserializedPartnerTopicProperties.messageForActivation = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedPartnerTopicProperties;
        });
    }
}
