// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.eventgrid.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Full endpoint URL of an event subscription.
 */
@Fluent
public final class SubscriptionFullUrlInner implements JsonSerializable<SubscriptionFullUrlInner> {
    /*
     * The URL that represents the endpoint of the destination of an event subscription.
     */
    private String endpointUrl;

    /**
     * Creates an instance of SubscriptionFullUrlInner class.
     */
    public SubscriptionFullUrlInner() {
    }

    /**
     * Get the endpointUrl property: The URL that represents the endpoint of the destination of an event subscription.
     * 
     * @return the endpointUrl value.
     */
    public String endpointUrl() {
        return this.endpointUrl;
    }

    /**
     * Set the endpointUrl property: The URL that represents the endpoint of the destination of an event subscription.
     * 
     * @param endpointUrl the endpointUrl value to set.
     * @return the SubscriptionFullUrlInner object itself.
     */
    public SubscriptionFullUrlInner withEndpointUrl(String endpointUrl) {
        this.endpointUrl = endpointUrl;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("endpointUrl", this.endpointUrl);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SubscriptionFullUrlInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SubscriptionFullUrlInner if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the SubscriptionFullUrlInner.
     */
    public static SubscriptionFullUrlInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SubscriptionFullUrlInner deserializedSubscriptionFullUrlInner = new SubscriptionFullUrlInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("endpointUrl".equals(fieldName)) {
                    deserializedSubscriptionFullUrlInner.endpointUrl = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedSubscriptionFullUrlInner;
        });
    }
}
