// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.eventgrid.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventgrid.models.DeliveryConfiguration;
import com.azure.resourcemanager.eventgrid.models.DeliverySchema;
import com.azure.resourcemanager.eventgrid.models.FiltersConfiguration;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

/**
 * Properties of the Event Subscription update parameters.
 */
@Fluent
public final class SubscriptionUpdateParametersProperties
    implements JsonSerializable<SubscriptionUpdateParametersProperties> {
    /*
     * Information about the delivery configuration of the event subscription.
     */
    private DeliveryConfiguration deliveryConfiguration;

    /*
     * The event delivery schema for the event subscription.
     */
    private DeliverySchema eventDeliverySchema;

    /*
     * Information about the filter for the event subscription.
     */
    private FiltersConfiguration filtersConfiguration;

    /*
     * Expiration time of the event subscription.
     */
    private OffsetDateTime expirationTimeUtc;

    /**
     * Creates an instance of SubscriptionUpdateParametersProperties class.
     */
    public SubscriptionUpdateParametersProperties() {
    }

    /**
     * Get the deliveryConfiguration property: Information about the delivery configuration of the event subscription.
     * 
     * @return the deliveryConfiguration value.
     */
    public DeliveryConfiguration deliveryConfiguration() {
        return this.deliveryConfiguration;
    }

    /**
     * Set the deliveryConfiguration property: Information about the delivery configuration of the event subscription.
     * 
     * @param deliveryConfiguration the deliveryConfiguration value to set.
     * @return the SubscriptionUpdateParametersProperties object itself.
     */
    public SubscriptionUpdateParametersProperties
        withDeliveryConfiguration(DeliveryConfiguration deliveryConfiguration) {
        this.deliveryConfiguration = deliveryConfiguration;
        return this;
    }

    /**
     * Get the eventDeliverySchema property: The event delivery schema for the event subscription.
     * 
     * @return the eventDeliverySchema value.
     */
    public DeliverySchema eventDeliverySchema() {
        return this.eventDeliverySchema;
    }

    /**
     * Set the eventDeliverySchema property: The event delivery schema for the event subscription.
     * 
     * @param eventDeliverySchema the eventDeliverySchema value to set.
     * @return the SubscriptionUpdateParametersProperties object itself.
     */
    public SubscriptionUpdateParametersProperties withEventDeliverySchema(DeliverySchema eventDeliverySchema) {
        this.eventDeliverySchema = eventDeliverySchema;
        return this;
    }

    /**
     * Get the filtersConfiguration property: Information about the filter for the event subscription.
     * 
     * @return the filtersConfiguration value.
     */
    public FiltersConfiguration filtersConfiguration() {
        return this.filtersConfiguration;
    }

    /**
     * Set the filtersConfiguration property: Information about the filter for the event subscription.
     * 
     * @param filtersConfiguration the filtersConfiguration value to set.
     * @return the SubscriptionUpdateParametersProperties object itself.
     */
    public SubscriptionUpdateParametersProperties withFiltersConfiguration(FiltersConfiguration filtersConfiguration) {
        this.filtersConfiguration = filtersConfiguration;
        return this;
    }

    /**
     * Get the expirationTimeUtc property: Expiration time of the event subscription.
     * 
     * @return the expirationTimeUtc value.
     */
    public OffsetDateTime expirationTimeUtc() {
        return this.expirationTimeUtc;
    }

    /**
     * Set the expirationTimeUtc property: Expiration time of the event subscription.
     * 
     * @param expirationTimeUtc the expirationTimeUtc value to set.
     * @return the SubscriptionUpdateParametersProperties object itself.
     */
    public SubscriptionUpdateParametersProperties withExpirationTimeUtc(OffsetDateTime expirationTimeUtc) {
        this.expirationTimeUtc = expirationTimeUtc;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (deliveryConfiguration() != null) {
            deliveryConfiguration().validate();
        }
        if (filtersConfiguration() != null) {
            filtersConfiguration().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("deliveryConfiguration", this.deliveryConfiguration);
        jsonWriter.writeStringField("eventDeliverySchema",
            this.eventDeliverySchema == null ? null : this.eventDeliverySchema.toString());
        jsonWriter.writeJsonField("filtersConfiguration", this.filtersConfiguration);
        jsonWriter.writeStringField("expirationTimeUtc",
            this.expirationTimeUtc == null
                ? null
                : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.expirationTimeUtc));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SubscriptionUpdateParametersProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SubscriptionUpdateParametersProperties if the JsonReader was pointing to an instance of
     * it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the SubscriptionUpdateParametersProperties.
     */
    public static SubscriptionUpdateParametersProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SubscriptionUpdateParametersProperties deserializedSubscriptionUpdateParametersProperties
                = new SubscriptionUpdateParametersProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("deliveryConfiguration".equals(fieldName)) {
                    deserializedSubscriptionUpdateParametersProperties.deliveryConfiguration
                        = DeliveryConfiguration.fromJson(reader);
                } else if ("eventDeliverySchema".equals(fieldName)) {
                    deserializedSubscriptionUpdateParametersProperties.eventDeliverySchema
                        = DeliverySchema.fromString(reader.getString());
                } else if ("filtersConfiguration".equals(fieldName)) {
                    deserializedSubscriptionUpdateParametersProperties.filtersConfiguration
                        = FiltersConfiguration.fromJson(reader);
                } else if ("expirationTimeUtc".equals(fieldName)) {
                    deserializedSubscriptionUpdateParametersProperties.expirationTimeUtc = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedSubscriptionUpdateParametersProperties;
        });
    }
}
