// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.eventgrid.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.Resource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventgrid.models.IdentityInfo;
import com.azure.resourcemanager.eventgrid.models.ResourceProvisioningState;
import java.io.IOException;
import java.util.Map;

/**
 * EventGrid System Topic.
 */
@Fluent
public final class SystemTopicInner extends Resource {
    /*
     * Properties of the system topic.
     */
    private SystemTopicProperties innerProperties;

    /*
     * The system metadata relating to the Event Grid resource.
     */
    private SystemData systemData;

    /*
     * Identity information for the resource.
     */
    private IdentityInfo identity;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of SystemTopicInner class.
     */
    public SystemTopicInner() {
    }

    /**
     * Get the innerProperties property: Properties of the system topic.
     * 
     * @return the innerProperties value.
     */
    private SystemTopicProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the systemData property: The system metadata relating to the Event Grid resource.
     * 
     * @return the systemData value.
     */
    public SystemData systemData() {
        return this.systemData;
    }

    /**
     * Get the identity property: Identity information for the resource.
     * 
     * @return the identity value.
     */
    public IdentityInfo identity() {
        return this.identity;
    }

    /**
     * Set the identity property: Identity information for the resource.
     * 
     * @param identity the identity value to set.
     * @return the SystemTopicInner object itself.
     */
    public SystemTopicInner withIdentity(IdentityInfo identity) {
        this.identity = identity;
        return this;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public SystemTopicInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public SystemTopicInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    /**
     * Get the provisioningState property: Provisioning state of the system topic.
     * 
     * @return the provisioningState value.
     */
    public ResourceProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    /**
     * Get the source property: Source for the system topic.
     * 
     * @return the source value.
     */
    public String source() {
        return this.innerProperties() == null ? null : this.innerProperties().source();
    }

    /**
     * Set the source property: Source for the system topic.
     * 
     * @param source the source value to set.
     * @return the SystemTopicInner object itself.
     */
    public SystemTopicInner withSource(String source) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SystemTopicProperties();
        }
        this.innerProperties().withSource(source);
        return this;
    }

    /**
     * Get the topicType property: TopicType for the system topic.
     * 
     * @return the topicType value.
     */
    public String topicType() {
        return this.innerProperties() == null ? null : this.innerProperties().topicType();
    }

    /**
     * Set the topicType property: TopicType for the system topic.
     * 
     * @param topicType the topicType value to set.
     * @return the SystemTopicInner object itself.
     */
    public SystemTopicInner withTopicType(String topicType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SystemTopicProperties();
        }
        this.innerProperties().withTopicType(topicType);
        return this;
    }

    /**
     * Get the metricResourceId property: Metric resource id for the system topic.
     * 
     * @return the metricResourceId value.
     */
    public String metricResourceId() {
        return this.innerProperties() == null ? null : this.innerProperties().metricResourceId();
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
        if (identity() != null) {
            identity().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", location());
        jsonWriter.writeMapField("tags", tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", this.innerProperties);
        jsonWriter.writeJsonField("identity", this.identity);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SystemTopicInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SystemTopicInner if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the SystemTopicInner.
     */
    public static SystemTopicInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SystemTopicInner deserializedSystemTopicInner = new SystemTopicInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedSystemTopicInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedSystemTopicInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedSystemTopicInner.type = reader.getString();
                } else if ("location".equals(fieldName)) {
                    deserializedSystemTopicInner.withLocation(reader.getString());
                } else if ("tags".equals(fieldName)) {
                    Map<String, String> tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedSystemTopicInner.withTags(tags);
                } else if ("properties".equals(fieldName)) {
                    deserializedSystemTopicInner.innerProperties = SystemTopicProperties.fromJson(reader);
                } else if ("systemData".equals(fieldName)) {
                    deserializedSystemTopicInner.systemData = SystemData.fromJson(reader);
                } else if ("identity".equals(fieldName)) {
                    deserializedSystemTopicInner.identity = IdentityInfo.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedSystemTopicInner;
        });
    }
}
