// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.eventgrid.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventgrid.models.ResourceProvisioningState;
import java.io.IOException;

/**
 * Properties of the System Topic.
 */
@Fluent
public final class SystemTopicProperties implements JsonSerializable<SystemTopicProperties> {
    /*
     * Provisioning state of the system topic.
     */
    private ResourceProvisioningState provisioningState;

    /*
     * Source for the system topic.
     */
    private String source;

    /*
     * TopicType for the system topic.
     */
    private String topicType;

    /*
     * Metric resource id for the system topic.
     */
    private String metricResourceId;

    /**
     * Creates an instance of SystemTopicProperties class.
     */
    public SystemTopicProperties() {
    }

    /**
     * Get the provisioningState property: Provisioning state of the system topic.
     * 
     * @return the provisioningState value.
     */
    public ResourceProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get the source property: Source for the system topic.
     * 
     * @return the source value.
     */
    public String source() {
        return this.source;
    }

    /**
     * Set the source property: Source for the system topic.
     * 
     * @param source the source value to set.
     * @return the SystemTopicProperties object itself.
     */
    public SystemTopicProperties withSource(String source) {
        this.source = source;
        return this;
    }

    /**
     * Get the topicType property: TopicType for the system topic.
     * 
     * @return the topicType value.
     */
    public String topicType() {
        return this.topicType;
    }

    /**
     * Set the topicType property: TopicType for the system topic.
     * 
     * @param topicType the topicType value to set.
     * @return the SystemTopicProperties object itself.
     */
    public SystemTopicProperties withTopicType(String topicType) {
        this.topicType = topicType;
        return this;
    }

    /**
     * Get the metricResourceId property: Metric resource id for the system topic.
     * 
     * @return the metricResourceId value.
     */
    public String metricResourceId() {
        return this.metricResourceId;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("source", this.source);
        jsonWriter.writeStringField("topicType", this.topicType);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SystemTopicProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SystemTopicProperties if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the SystemTopicProperties.
     */
    public static SystemTopicProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SystemTopicProperties deserializedSystemTopicProperties = new SystemTopicProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("provisioningState".equals(fieldName)) {
                    deserializedSystemTopicProperties.provisioningState
                        = ResourceProvisioningState.fromString(reader.getString());
                } else if ("source".equals(fieldName)) {
                    deserializedSystemTopicProperties.source = reader.getString();
                } else if ("topicType".equals(fieldName)) {
                    deserializedSystemTopicProperties.topicType = reader.getString();
                } else if ("metricResourceId".equals(fieldName)) {
                    deserializedSystemTopicProperties.metricResourceId = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedSystemTopicProperties;
        });
    }
}
