// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.eventgrid.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventgrid.models.TopicSpaceProvisioningState;
import java.io.IOException;
import java.util.List;

/**
 * The Topic space resource.
 */
@Fluent
public final class TopicSpaceInner extends ProxyResource {
    /*
     * The properties of topic space.
     */
    private TopicSpaceProperties innerProperties;

    /*
     * The system metadata relating to the Event Grid resource.
     */
    private SystemData systemData;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of TopicSpaceInner class.
     */
    public TopicSpaceInner() {
    }

    /**
     * Get the innerProperties property: The properties of topic space.
     * 
     * @return the innerProperties value.
     */
    private TopicSpaceProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the systemData property: The system metadata relating to the Event Grid resource.
     * 
     * @return the systemData value.
     */
    public SystemData systemData() {
        return this.systemData;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Get the description property: Description for the Topic Space resource.
     * 
     * @return the description value.
     */
    public String description() {
        return this.innerProperties() == null ? null : this.innerProperties().description();
    }

    /**
     * Set the description property: Description for the Topic Space resource.
     * 
     * @param description the description value to set.
     * @return the TopicSpaceInner object itself.
     */
    public TopicSpaceInner withDescription(String description) {
        if (this.innerProperties() == null) {
            this.innerProperties = new TopicSpaceProperties();
        }
        this.innerProperties().withDescription(description);
        return this;
    }

    /**
     * Get the topicTemplates property: The topic filters in the topic space.
     * Example: "topicTemplates": [
     * "devices/foo/bar",
     * "devices/topic1/+",
     * "devices/${principal.name}/${principal.attributes.keyName}" ].
     * 
     * @return the topicTemplates value.
     */
    public List<String> topicTemplates() {
        return this.innerProperties() == null ? null : this.innerProperties().topicTemplates();
    }

    /**
     * Set the topicTemplates property: The topic filters in the topic space.
     * Example: "topicTemplates": [
     * "devices/foo/bar",
     * "devices/topic1/+",
     * "devices/${principal.name}/${principal.attributes.keyName}" ].
     * 
     * @param topicTemplates the topicTemplates value to set.
     * @return the TopicSpaceInner object itself.
     */
    public TopicSpaceInner withTopicTemplates(List<String> topicTemplates) {
        if (this.innerProperties() == null) {
            this.innerProperties = new TopicSpaceProperties();
        }
        this.innerProperties().withTopicTemplates(topicTemplates);
        return this;
    }

    /**
     * Get the provisioningState property: Provisioning state of the TopicSpace resource.
     * 
     * @return the provisioningState value.
     */
    public TopicSpaceProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of TopicSpaceInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of TopicSpaceInner if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the TopicSpaceInner.
     */
    public static TopicSpaceInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            TopicSpaceInner deserializedTopicSpaceInner = new TopicSpaceInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedTopicSpaceInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedTopicSpaceInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedTopicSpaceInner.type = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    deserializedTopicSpaceInner.innerProperties = TopicSpaceProperties.fromJson(reader);
                } else if ("systemData".equals(fieldName)) {
                    deserializedTopicSpaceInner.systemData = SystemData.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedTopicSpaceInner;
        });
    }
}
