// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.eventgrid.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventgrid.models.TopicSpaceProvisioningState;
import java.io.IOException;
import java.util.List;

/**
 * The properties of topic space.
 */
@Fluent
public final class TopicSpaceProperties implements JsonSerializable<TopicSpaceProperties> {
    /*
     * Description for the Topic Space resource.
     */
    private String description;

    /*
     * The topic filters in the topic space.
     * Example: "topicTemplates": [
     * "devices/foo/bar",
     * "devices/topic1/+",
     * "devices/${principal.name}/${principal.attributes.keyName}" ].
     */
    private List<String> topicTemplates;

    /*
     * Provisioning state of the TopicSpace resource.
     */
    private TopicSpaceProvisioningState provisioningState;

    /**
     * Creates an instance of TopicSpaceProperties class.
     */
    public TopicSpaceProperties() {
    }

    /**
     * Get the description property: Description for the Topic Space resource.
     * 
     * @return the description value.
     */
    public String description() {
        return this.description;
    }

    /**
     * Set the description property: Description for the Topic Space resource.
     * 
     * @param description the description value to set.
     * @return the TopicSpaceProperties object itself.
     */
    public TopicSpaceProperties withDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * Get the topicTemplates property: The topic filters in the topic space.
     * Example: "topicTemplates": [
     * "devices/foo/bar",
     * "devices/topic1/+",
     * "devices/${principal.name}/${principal.attributes.keyName}" ].
     * 
     * @return the topicTemplates value.
     */
    public List<String> topicTemplates() {
        return this.topicTemplates;
    }

    /**
     * Set the topicTemplates property: The topic filters in the topic space.
     * Example: "topicTemplates": [
     * "devices/foo/bar",
     * "devices/topic1/+",
     * "devices/${principal.name}/${principal.attributes.keyName}" ].
     * 
     * @param topicTemplates the topicTemplates value to set.
     * @return the TopicSpaceProperties object itself.
     */
    public TopicSpaceProperties withTopicTemplates(List<String> topicTemplates) {
        this.topicTemplates = topicTemplates;
        return this;
    }

    /**
     * Get the provisioningState property: Provisioning state of the TopicSpace resource.
     * 
     * @return the provisioningState value.
     */
    public TopicSpaceProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeArrayField("topicTemplates", this.topicTemplates,
            (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of TopicSpaceProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of TopicSpaceProperties if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the TopicSpaceProperties.
     */
    public static TopicSpaceProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            TopicSpaceProperties deserializedTopicSpaceProperties = new TopicSpaceProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("description".equals(fieldName)) {
                    deserializedTopicSpaceProperties.description = reader.getString();
                } else if ("topicTemplates".equals(fieldName)) {
                    List<String> topicTemplates = reader.readArray(reader1 -> reader1.getString());
                    deserializedTopicSpaceProperties.topicTemplates = topicTemplates;
                } else if ("provisioningState".equals(fieldName)) {
                    deserializedTopicSpaceProperties.provisioningState
                        = TopicSpaceProvisioningState.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedTopicSpaceProperties;
        });
    }
}
