// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.eventgrid.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventgrid.models.ResourceRegionType;
import com.azure.resourcemanager.eventgrid.models.TopicTypeAdditionalEnforcedPermission;
import com.azure.resourcemanager.eventgrid.models.TopicTypeProvisioningState;
import com.azure.resourcemanager.eventgrid.models.TopicTypeSourceScope;
import java.io.IOException;
import java.util.List;

/**
 * Properties of a topic type.
 */
@Fluent
public final class TopicTypeProperties implements JsonSerializable<TopicTypeProperties> {
    /*
     * Namespace of the provider of the topic type.
     */
    private String provider;

    /*
     * Display Name for the topic type.
     */
    private String displayName;

    /*
     * Description of the topic type.
     */
    private String description;

    /*
     * Region type of the resource.
     */
    private ResourceRegionType resourceRegionType;

    /*
     * Provisioning state of the topic type.
     */
    private TopicTypeProvisioningState provisioningState;

    /*
     * List of locations supported by this topic type.
     */
    private List<String> supportedLocations;

    /*
     * Source resource format.
     */
    private String sourceResourceFormat;

    /*
     * Supported source scopes.
     */
    private List<TopicTypeSourceScope> supportedScopesForSource;

    /*
     * Flag to indicate that a topic type can support both regional or global system topics.
     */
    private Boolean areRegionalAndGlobalSourcesSupported;

    /*
     * Permissions which are enforced for creating and updating system topics of this this topic type.
     */
    private List<TopicTypeAdditionalEnforcedPermission> additionalEnforcedPermissions;

    /**
     * Creates an instance of TopicTypeProperties class.
     */
    public TopicTypeProperties() {
    }

    /**
     * Get the provider property: Namespace of the provider of the topic type.
     * 
     * @return the provider value.
     */
    public String provider() {
        return this.provider;
    }

    /**
     * Set the provider property: Namespace of the provider of the topic type.
     * 
     * @param provider the provider value to set.
     * @return the TopicTypeProperties object itself.
     */
    public TopicTypeProperties withProvider(String provider) {
        this.provider = provider;
        return this;
    }

    /**
     * Get the displayName property: Display Name for the topic type.
     * 
     * @return the displayName value.
     */
    public String displayName() {
        return this.displayName;
    }

    /**
     * Set the displayName property: Display Name for the topic type.
     * 
     * @param displayName the displayName value to set.
     * @return the TopicTypeProperties object itself.
     */
    public TopicTypeProperties withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    /**
     * Get the description property: Description of the topic type.
     * 
     * @return the description value.
     */
    public String description() {
        return this.description;
    }

    /**
     * Set the description property: Description of the topic type.
     * 
     * @param description the description value to set.
     * @return the TopicTypeProperties object itself.
     */
    public TopicTypeProperties withDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * Get the resourceRegionType property: Region type of the resource.
     * 
     * @return the resourceRegionType value.
     */
    public ResourceRegionType resourceRegionType() {
        return this.resourceRegionType;
    }

    /**
     * Set the resourceRegionType property: Region type of the resource.
     * 
     * @param resourceRegionType the resourceRegionType value to set.
     * @return the TopicTypeProperties object itself.
     */
    public TopicTypeProperties withResourceRegionType(ResourceRegionType resourceRegionType) {
        this.resourceRegionType = resourceRegionType;
        return this;
    }

    /**
     * Get the provisioningState property: Provisioning state of the topic type.
     * 
     * @return the provisioningState value.
     */
    public TopicTypeProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Set the provisioningState property: Provisioning state of the topic type.
     * 
     * @param provisioningState the provisioningState value to set.
     * @return the TopicTypeProperties object itself.
     */
    public TopicTypeProperties withProvisioningState(TopicTypeProvisioningState provisioningState) {
        this.provisioningState = provisioningState;
        return this;
    }

    /**
     * Get the supportedLocations property: List of locations supported by this topic type.
     * 
     * @return the supportedLocations value.
     */
    public List<String> supportedLocations() {
        return this.supportedLocations;
    }

    /**
     * Set the supportedLocations property: List of locations supported by this topic type.
     * 
     * @param supportedLocations the supportedLocations value to set.
     * @return the TopicTypeProperties object itself.
     */
    public TopicTypeProperties withSupportedLocations(List<String> supportedLocations) {
        this.supportedLocations = supportedLocations;
        return this;
    }

    /**
     * Get the sourceResourceFormat property: Source resource format.
     * 
     * @return the sourceResourceFormat value.
     */
    public String sourceResourceFormat() {
        return this.sourceResourceFormat;
    }

    /**
     * Set the sourceResourceFormat property: Source resource format.
     * 
     * @param sourceResourceFormat the sourceResourceFormat value to set.
     * @return the TopicTypeProperties object itself.
     */
    public TopicTypeProperties withSourceResourceFormat(String sourceResourceFormat) {
        this.sourceResourceFormat = sourceResourceFormat;
        return this;
    }

    /**
     * Get the supportedScopesForSource property: Supported source scopes.
     * 
     * @return the supportedScopesForSource value.
     */
    public List<TopicTypeSourceScope> supportedScopesForSource() {
        return this.supportedScopesForSource;
    }

    /**
     * Set the supportedScopesForSource property: Supported source scopes.
     * 
     * @param supportedScopesForSource the supportedScopesForSource value to set.
     * @return the TopicTypeProperties object itself.
     */
    public TopicTypeProperties withSupportedScopesForSource(List<TopicTypeSourceScope> supportedScopesForSource) {
        this.supportedScopesForSource = supportedScopesForSource;
        return this;
    }

    /**
     * Get the areRegionalAndGlobalSourcesSupported property: Flag to indicate that a topic type can support both
     * regional or global system topics.
     * 
     * @return the areRegionalAndGlobalSourcesSupported value.
     */
    public Boolean areRegionalAndGlobalSourcesSupported() {
        return this.areRegionalAndGlobalSourcesSupported;
    }

    /**
     * Set the areRegionalAndGlobalSourcesSupported property: Flag to indicate that a topic type can support both
     * regional or global system topics.
     * 
     * @param areRegionalAndGlobalSourcesSupported the areRegionalAndGlobalSourcesSupported value to set.
     * @return the TopicTypeProperties object itself.
     */
    public TopicTypeProperties withAreRegionalAndGlobalSourcesSupported(Boolean areRegionalAndGlobalSourcesSupported) {
        this.areRegionalAndGlobalSourcesSupported = areRegionalAndGlobalSourcesSupported;
        return this;
    }

    /**
     * Get the additionalEnforcedPermissions property: Permissions which are enforced for creating and updating system
     * topics of this this topic type.
     * 
     * @return the additionalEnforcedPermissions value.
     */
    public List<TopicTypeAdditionalEnforcedPermission> additionalEnforcedPermissions() {
        return this.additionalEnforcedPermissions;
    }

    /**
     * Set the additionalEnforcedPermissions property: Permissions which are enforced for creating and updating system
     * topics of this this topic type.
     * 
     * @param additionalEnforcedPermissions the additionalEnforcedPermissions value to set.
     * @return the TopicTypeProperties object itself.
     */
    public TopicTypeProperties
        withAdditionalEnforcedPermissions(List<TopicTypeAdditionalEnforcedPermission> additionalEnforcedPermissions) {
        this.additionalEnforcedPermissions = additionalEnforcedPermissions;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (additionalEnforcedPermissions() != null) {
            additionalEnforcedPermissions().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("provider", this.provider);
        jsonWriter.writeStringField("displayName", this.displayName);
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeStringField("resourceRegionType",
            this.resourceRegionType == null ? null : this.resourceRegionType.toString());
        jsonWriter.writeStringField("provisioningState",
            this.provisioningState == null ? null : this.provisioningState.toString());
        jsonWriter.writeArrayField("supportedLocations", this.supportedLocations,
            (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("sourceResourceFormat", this.sourceResourceFormat);
        jsonWriter.writeArrayField("supportedScopesForSource", this.supportedScopesForSource,
            (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        jsonWriter.writeBooleanField("areRegionalAndGlobalSourcesSupported", this.areRegionalAndGlobalSourcesSupported);
        jsonWriter.writeArrayField("additionalEnforcedPermissions", this.additionalEnforcedPermissions,
            (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of TopicTypeProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of TopicTypeProperties if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the TopicTypeProperties.
     */
    public static TopicTypeProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            TopicTypeProperties deserializedTopicTypeProperties = new TopicTypeProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("provider".equals(fieldName)) {
                    deserializedTopicTypeProperties.provider = reader.getString();
                } else if ("displayName".equals(fieldName)) {
                    deserializedTopicTypeProperties.displayName = reader.getString();
                } else if ("description".equals(fieldName)) {
                    deserializedTopicTypeProperties.description = reader.getString();
                } else if ("resourceRegionType".equals(fieldName)) {
                    deserializedTopicTypeProperties.resourceRegionType
                        = ResourceRegionType.fromString(reader.getString());
                } else if ("provisioningState".equals(fieldName)) {
                    deserializedTopicTypeProperties.provisioningState
                        = TopicTypeProvisioningState.fromString(reader.getString());
                } else if ("supportedLocations".equals(fieldName)) {
                    List<String> supportedLocations = reader.readArray(reader1 -> reader1.getString());
                    deserializedTopicTypeProperties.supportedLocations = supportedLocations;
                } else if ("sourceResourceFormat".equals(fieldName)) {
                    deserializedTopicTypeProperties.sourceResourceFormat = reader.getString();
                } else if ("supportedScopesForSource".equals(fieldName)) {
                    List<TopicTypeSourceScope> supportedScopesForSource
                        = reader.readArray(reader1 -> TopicTypeSourceScope.fromString(reader1.getString()));
                    deserializedTopicTypeProperties.supportedScopesForSource = supportedScopesForSource;
                } else if ("areRegionalAndGlobalSourcesSupported".equals(fieldName)) {
                    deserializedTopicTypeProperties.areRegionalAndGlobalSourcesSupported
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("additionalEnforcedPermissions".equals(fieldName)) {
                    List<TopicTypeAdditionalEnforcedPermission> additionalEnforcedPermissions
                        = reader.readArray(reader1 -> TopicTypeAdditionalEnforcedPermission.fromJson(reader1));
                    deserializedTopicTypeProperties.additionalEnforcedPermissions = additionalEnforcedPermissions;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedTopicTypeProperties;
        });
    }
}
