// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.eventgrid.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventgrid.models.PartnerDetails;
import com.azure.resourcemanager.eventgrid.models.VerifiedPartnerProvisioningState;
import java.io.IOException;
import java.util.UUID;

/**
 * Verified partner information.
 */
@Fluent
public final class VerifiedPartnerInner extends ProxyResource {
    /*
     * Properties of the verified partner.
     */
    private VerifiedPartnerProperties innerProperties;

    /*
     * The system metadata relating to the Event Grid resource.
     */
    private SystemData systemData;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of VerifiedPartnerInner class.
     */
    public VerifiedPartnerInner() {
    }

    /**
     * Get the innerProperties property: Properties of the verified partner.
     * 
     * @return the innerProperties value.
     */
    private VerifiedPartnerProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the systemData property: The system metadata relating to the Event Grid resource.
     * 
     * @return the systemData value.
     */
    public SystemData systemData() {
        return this.systemData;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Get the partnerRegistrationImmutableId property: ImmutableId of the corresponding partner registration.
     * 
     * @return the partnerRegistrationImmutableId value.
     */
    public UUID partnerRegistrationImmutableId() {
        return this.innerProperties() == null ? null : this.innerProperties().partnerRegistrationImmutableId();
    }

    /**
     * Set the partnerRegistrationImmutableId property: ImmutableId of the corresponding partner registration.
     * 
     * @param partnerRegistrationImmutableId the partnerRegistrationImmutableId value to set.
     * @return the VerifiedPartnerInner object itself.
     */
    public VerifiedPartnerInner withPartnerRegistrationImmutableId(UUID partnerRegistrationImmutableId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VerifiedPartnerProperties();
        }
        this.innerProperties().withPartnerRegistrationImmutableId(partnerRegistrationImmutableId);
        return this;
    }

    /**
     * Get the organizationName property: Official name of the Partner.
     * 
     * @return the organizationName value.
     */
    public String organizationName() {
        return this.innerProperties() == null ? null : this.innerProperties().organizationName();
    }

    /**
     * Set the organizationName property: Official name of the Partner.
     * 
     * @param organizationName the organizationName value to set.
     * @return the VerifiedPartnerInner object itself.
     */
    public VerifiedPartnerInner withOrganizationName(String organizationName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VerifiedPartnerProperties();
        }
        this.innerProperties().withOrganizationName(organizationName);
        return this;
    }

    /**
     * Get the partnerDisplayName property: Display name of the verified partner.
     * 
     * @return the partnerDisplayName value.
     */
    public String partnerDisplayName() {
        return this.innerProperties() == null ? null : this.innerProperties().partnerDisplayName();
    }

    /**
     * Set the partnerDisplayName property: Display name of the verified partner.
     * 
     * @param partnerDisplayName the partnerDisplayName value to set.
     * @return the VerifiedPartnerInner object itself.
     */
    public VerifiedPartnerInner withPartnerDisplayName(String partnerDisplayName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VerifiedPartnerProperties();
        }
        this.innerProperties().withPartnerDisplayName(partnerDisplayName);
        return this;
    }

    /**
     * Get the partnerTopicDetails property: Details of the partner topic scenario.
     * 
     * @return the partnerTopicDetails value.
     */
    public PartnerDetails partnerTopicDetails() {
        return this.innerProperties() == null ? null : this.innerProperties().partnerTopicDetails();
    }

    /**
     * Set the partnerTopicDetails property: Details of the partner topic scenario.
     * 
     * @param partnerTopicDetails the partnerTopicDetails value to set.
     * @return the VerifiedPartnerInner object itself.
     */
    public VerifiedPartnerInner withPartnerTopicDetails(PartnerDetails partnerTopicDetails) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VerifiedPartnerProperties();
        }
        this.innerProperties().withPartnerTopicDetails(partnerTopicDetails);
        return this;
    }

    /**
     * Get the provisioningState property: Provisioning state of the verified partner.
     * 
     * @return the provisioningState value.
     */
    public VerifiedPartnerProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    /**
     * Set the provisioningState property: Provisioning state of the verified partner.
     * 
     * @param provisioningState the provisioningState value to set.
     * @return the VerifiedPartnerInner object itself.
     */
    public VerifiedPartnerInner withProvisioningState(VerifiedPartnerProvisioningState provisioningState) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VerifiedPartnerProperties();
        }
        this.innerProperties().withProvisioningState(provisioningState);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of VerifiedPartnerInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of VerifiedPartnerInner if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the VerifiedPartnerInner.
     */
    public static VerifiedPartnerInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            VerifiedPartnerInner deserializedVerifiedPartnerInner = new VerifiedPartnerInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedVerifiedPartnerInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedVerifiedPartnerInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedVerifiedPartnerInner.type = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    deserializedVerifiedPartnerInner.innerProperties = VerifiedPartnerProperties.fromJson(reader);
                } else if ("systemData".equals(fieldName)) {
                    deserializedVerifiedPartnerInner.systemData = SystemData.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedVerifiedPartnerInner;
        });
    }
}
