// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.eventgrid.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventgrid.models.PartnerDetails;
import com.azure.resourcemanager.eventgrid.models.VerifiedPartnerProvisioningState;
import java.io.IOException;
import java.util.Objects;
import java.util.UUID;

/**
 * Properties of the verified partner.
 */
@Fluent
public final class VerifiedPartnerProperties implements JsonSerializable<VerifiedPartnerProperties> {
    /*
     * ImmutableId of the corresponding partner registration.
     */
    private UUID partnerRegistrationImmutableId;

    /*
     * Official name of the Partner.
     */
    private String organizationName;

    /*
     * Display name of the verified partner.
     */
    private String partnerDisplayName;

    /*
     * Details of the partner topic scenario.
     */
    private PartnerDetails partnerTopicDetails;

    /*
     * Provisioning state of the verified partner.
     */
    private VerifiedPartnerProvisioningState provisioningState;

    /**
     * Creates an instance of VerifiedPartnerProperties class.
     */
    public VerifiedPartnerProperties() {
    }

    /**
     * Get the partnerRegistrationImmutableId property: ImmutableId of the corresponding partner registration.
     * 
     * @return the partnerRegistrationImmutableId value.
     */
    public UUID partnerRegistrationImmutableId() {
        return this.partnerRegistrationImmutableId;
    }

    /**
     * Set the partnerRegistrationImmutableId property: ImmutableId of the corresponding partner registration.
     * 
     * @param partnerRegistrationImmutableId the partnerRegistrationImmutableId value to set.
     * @return the VerifiedPartnerProperties object itself.
     */
    public VerifiedPartnerProperties withPartnerRegistrationImmutableId(UUID partnerRegistrationImmutableId) {
        this.partnerRegistrationImmutableId = partnerRegistrationImmutableId;
        return this;
    }

    /**
     * Get the organizationName property: Official name of the Partner.
     * 
     * @return the organizationName value.
     */
    public String organizationName() {
        return this.organizationName;
    }

    /**
     * Set the organizationName property: Official name of the Partner.
     * 
     * @param organizationName the organizationName value to set.
     * @return the VerifiedPartnerProperties object itself.
     */
    public VerifiedPartnerProperties withOrganizationName(String organizationName) {
        this.organizationName = organizationName;
        return this;
    }

    /**
     * Get the partnerDisplayName property: Display name of the verified partner.
     * 
     * @return the partnerDisplayName value.
     */
    public String partnerDisplayName() {
        return this.partnerDisplayName;
    }

    /**
     * Set the partnerDisplayName property: Display name of the verified partner.
     * 
     * @param partnerDisplayName the partnerDisplayName value to set.
     * @return the VerifiedPartnerProperties object itself.
     */
    public VerifiedPartnerProperties withPartnerDisplayName(String partnerDisplayName) {
        this.partnerDisplayName = partnerDisplayName;
        return this;
    }

    /**
     * Get the partnerTopicDetails property: Details of the partner topic scenario.
     * 
     * @return the partnerTopicDetails value.
     */
    public PartnerDetails partnerTopicDetails() {
        return this.partnerTopicDetails;
    }

    /**
     * Set the partnerTopicDetails property: Details of the partner topic scenario.
     * 
     * @param partnerTopicDetails the partnerTopicDetails value to set.
     * @return the VerifiedPartnerProperties object itself.
     */
    public VerifiedPartnerProperties withPartnerTopicDetails(PartnerDetails partnerTopicDetails) {
        this.partnerTopicDetails = partnerTopicDetails;
        return this;
    }

    /**
     * Get the provisioningState property: Provisioning state of the verified partner.
     * 
     * @return the provisioningState value.
     */
    public VerifiedPartnerProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Set the provisioningState property: Provisioning state of the verified partner.
     * 
     * @param provisioningState the provisioningState value to set.
     * @return the VerifiedPartnerProperties object itself.
     */
    public VerifiedPartnerProperties withProvisioningState(VerifiedPartnerProvisioningState provisioningState) {
        this.provisioningState = provisioningState;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (partnerTopicDetails() != null) {
            partnerTopicDetails().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("partnerRegistrationImmutableId",
            Objects.toString(this.partnerRegistrationImmutableId, null));
        jsonWriter.writeStringField("organizationName", this.organizationName);
        jsonWriter.writeStringField("partnerDisplayName", this.partnerDisplayName);
        jsonWriter.writeJsonField("partnerTopicDetails", this.partnerTopicDetails);
        jsonWriter.writeStringField("provisioningState",
            this.provisioningState == null ? null : this.provisioningState.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of VerifiedPartnerProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of VerifiedPartnerProperties if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the VerifiedPartnerProperties.
     */
    public static VerifiedPartnerProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            VerifiedPartnerProperties deserializedVerifiedPartnerProperties = new VerifiedPartnerProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("partnerRegistrationImmutableId".equals(fieldName)) {
                    deserializedVerifiedPartnerProperties.partnerRegistrationImmutableId
                        = reader.getNullable(nonNullReader -> UUID.fromString(nonNullReader.getString()));
                } else if ("organizationName".equals(fieldName)) {
                    deserializedVerifiedPartnerProperties.organizationName = reader.getString();
                } else if ("partnerDisplayName".equals(fieldName)) {
                    deserializedVerifiedPartnerProperties.partnerDisplayName = reader.getString();
                } else if ("partnerTopicDetails".equals(fieldName)) {
                    deserializedVerifiedPartnerProperties.partnerTopicDetails = PartnerDetails.fromJson(reader);
                } else if ("provisioningState".equals(fieldName)) {
                    deserializedVerifiedPartnerProperties.provisioningState
                        = VerifiedPartnerProvisioningState.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedVerifiedPartnerProperties;
        });
    }
}
