// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.eventgrid.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.resourcemanager.eventgrid.fluent.ChannelsClient;
import com.azure.resourcemanager.eventgrid.fluent.models.ChannelInner;
import com.azure.resourcemanager.eventgrid.fluent.models.EventSubscriptionFullUrlInner;
import com.azure.resourcemanager.eventgrid.models.ChannelUpdateParameters;
import com.azure.resourcemanager.eventgrid.models.ChannelsListResult;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

/**
 * An instance of this class provides access to all the operations defined in ChannelsClient.
 */
public final class ChannelsClientImpl implements ChannelsClient {
    /**
     * The proxy service used to perform REST calls.
     */
    private final ChannelsService service;

    /**
     * The service client containing this operation class.
     */
    private final EventGridManagementClientImpl client;

    /**
     * Initializes an instance of ChannelsClientImpl.
     * 
     * @param client the instance of the service client containing this operation class.
     */
    ChannelsClientImpl(EventGridManagementClientImpl client) {
        this.service = RestProxy.create(ChannelsService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    /**
     * The interface defining all the services for EventGridManagementClientChannels to be used by the proxy service to
     * perform REST calls.
     */
    @Host("{$host}")
    @ServiceInterface(name = "EventGridManagementC")
    public interface ChannelsService {
        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/partnerNamespaces/{partnerNamespaceName}/channels/{channelName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<ChannelInner>> get(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("partnerNamespaceName") String partnerNamespaceName,
            @PathParam("channelName") String channelName, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Put("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/partnerNamespaces/{partnerNamespaceName}/channels/{channelName}")
        @ExpectedResponses({ 200, 201 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<ChannelInner>> createOrUpdate(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("partnerNamespaceName") String partnerNamespaceName,
            @PathParam("channelName") String channelName, @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") ChannelInner channelInfo, @HeaderParam("Accept") String accept,
            Context context);

        @Headers({ "Accept: application/json;q=0.9", "Content-Type: application/json" })
        @Delete("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/partnerNamespaces/{partnerNamespaceName}/channels/{channelName}")
        @ExpectedResponses({ 200, 202, 204 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> delete(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("partnerNamespaceName") String partnerNamespaceName,
            @PathParam("channelName") String channelName, @QueryParam("api-version") String apiVersion,
            Context context);

        @Headers({ "Accept: application/json;q=0.9", "Content-Type: application/json" })
        @Patch("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/partnerNamespaces/{partnerNamespaceName}/channels/{channelName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Void>> update(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("partnerNamespaceName") String partnerNamespaceName,
            @PathParam("channelName") String channelName, @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") ChannelUpdateParameters channelUpdateParameters, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/partnerNamespaces/{partnerNamespaceName}/channels")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<ChannelsListResult>> listByPartnerNamespace(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("partnerNamespaceName") String partnerNamespaceName,
            @QueryParam("api-version") String apiVersion, @QueryParam("$filter") String filter,
            @QueryParam("$top") Integer top, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/partnerNamespaces/{partnerNamespaceName}/channels/{channelName}/getFullUrl")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<EventSubscriptionFullUrlInner>> getFullUrl(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("partnerNamespaceName") String partnerNamespaceName,
            @PathParam("channelName") String channelName, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<ChannelsListResult>> listByPartnerNamespaceNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept, Context context);
    }

    /**
     * Get a channel.
     * 
     * Get properties of a channel.
     * 
     * @param resourceGroupName The name of the resource group within the partners subscription.
     * @param partnerNamespaceName Name of the partner namespace.
     * @param channelName Name of the channel.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return properties of a channel along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<ChannelInner>> getWithResponseAsync(String resourceGroupName, String partnerNamespaceName,
        String channelName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (partnerNamespaceName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter partnerNamespaceName is required and cannot be null."));
        }
        if (channelName == null) {
            return Mono.error(new IllegalArgumentException("Parameter channelName is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.get(this.client.getEndpoint(), this.client.getSubscriptionId(),
                resourceGroupName, partnerNamespaceName, channelName, this.client.getApiVersion(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get a channel.
     * 
     * Get properties of a channel.
     * 
     * @param resourceGroupName The name of the resource group within the partners subscription.
     * @param partnerNamespaceName Name of the partner namespace.
     * @param channelName Name of the channel.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return properties of a channel along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<ChannelInner>> getWithResponseAsync(String resourceGroupName, String partnerNamespaceName,
        String channelName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (partnerNamespaceName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter partnerNamespaceName is required and cannot be null."));
        }
        if (channelName == null) {
            return Mono.error(new IllegalArgumentException("Parameter channelName is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.get(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName,
            partnerNamespaceName, channelName, this.client.getApiVersion(), accept, context);
    }

    /**
     * Get a channel.
     * 
     * Get properties of a channel.
     * 
     * @param resourceGroupName The name of the resource group within the partners subscription.
     * @param partnerNamespaceName Name of the partner namespace.
     * @param channelName Name of the channel.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return properties of a channel on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<ChannelInner> getAsync(String resourceGroupName, String partnerNamespaceName, String channelName) {
        return getWithResponseAsync(resourceGroupName, partnerNamespaceName, channelName)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Get a channel.
     * 
     * Get properties of a channel.
     * 
     * @param resourceGroupName The name of the resource group within the partners subscription.
     * @param partnerNamespaceName Name of the partner namespace.
     * @param channelName Name of the channel.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return properties of a channel along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<ChannelInner> getWithResponse(String resourceGroupName, String partnerNamespaceName,
        String channelName, Context context) {
        return getWithResponseAsync(resourceGroupName, partnerNamespaceName, channelName, context).block();
    }

    /**
     * Get a channel.
     * 
     * Get properties of a channel.
     * 
     * @param resourceGroupName The name of the resource group within the partners subscription.
     * @param partnerNamespaceName Name of the partner namespace.
     * @param channelName Name of the channel.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return properties of a channel.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ChannelInner get(String resourceGroupName, String partnerNamespaceName, String channelName) {
        return getWithResponse(resourceGroupName, partnerNamespaceName, channelName, Context.NONE).getValue();
    }

    /**
     * Create or update a channel.
     * 
     * Synchronously creates or updates a new channel with the specified parameters.
     * 
     * @param resourceGroupName The name of the resource group within the partners subscription.
     * @param partnerNamespaceName Name of the partner namespace.
     * @param channelName Name of the channel.
     * @param channelInfo Channel information.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return channel info along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<ChannelInner>> createOrUpdateWithResponseAsync(String resourceGroupName,
        String partnerNamespaceName, String channelName, ChannelInner channelInfo) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (partnerNamespaceName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter partnerNamespaceName is required and cannot be null."));
        }
        if (channelName == null) {
            return Mono.error(new IllegalArgumentException("Parameter channelName is required and cannot be null."));
        }
        if (channelInfo == null) {
            return Mono.error(new IllegalArgumentException("Parameter channelInfo is required and cannot be null."));
        } else {
            channelInfo.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.createOrUpdate(this.client.getEndpoint(), this.client.getSubscriptionId(),
                resourceGroupName, partnerNamespaceName, channelName, this.client.getApiVersion(), channelInfo, accept,
                context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Create or update a channel.
     * 
     * Synchronously creates or updates a new channel with the specified parameters.
     * 
     * @param resourceGroupName The name of the resource group within the partners subscription.
     * @param partnerNamespaceName Name of the partner namespace.
     * @param channelName Name of the channel.
     * @param channelInfo Channel information.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return channel info along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<ChannelInner>> createOrUpdateWithResponseAsync(String resourceGroupName,
        String partnerNamespaceName, String channelName, ChannelInner channelInfo, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (partnerNamespaceName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter partnerNamespaceName is required and cannot be null."));
        }
        if (channelName == null) {
            return Mono.error(new IllegalArgumentException("Parameter channelName is required and cannot be null."));
        }
        if (channelInfo == null) {
            return Mono.error(new IllegalArgumentException("Parameter channelInfo is required and cannot be null."));
        } else {
            channelInfo.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.createOrUpdate(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName,
            partnerNamespaceName, channelName, this.client.getApiVersion(), channelInfo, accept, context);
    }

    /**
     * Create or update a channel.
     * 
     * Synchronously creates or updates a new channel with the specified parameters.
     * 
     * @param resourceGroupName The name of the resource group within the partners subscription.
     * @param partnerNamespaceName Name of the partner namespace.
     * @param channelName Name of the channel.
     * @param channelInfo Channel information.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return channel info on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<ChannelInner> createOrUpdateAsync(String resourceGroupName, String partnerNamespaceName,
        String channelName, ChannelInner channelInfo) {
        return createOrUpdateWithResponseAsync(resourceGroupName, partnerNamespaceName, channelName, channelInfo)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Create or update a channel.
     * 
     * Synchronously creates or updates a new channel with the specified parameters.
     * 
     * @param resourceGroupName The name of the resource group within the partners subscription.
     * @param partnerNamespaceName Name of the partner namespace.
     * @param channelName Name of the channel.
     * @param channelInfo Channel information.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return channel info along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<ChannelInner> createOrUpdateWithResponse(String resourceGroupName, String partnerNamespaceName,
        String channelName, ChannelInner channelInfo, Context context) {
        return createOrUpdateWithResponseAsync(resourceGroupName, partnerNamespaceName, channelName, channelInfo,
            context).block();
    }

    /**
     * Create or update a channel.
     * 
     * Synchronously creates or updates a new channel with the specified parameters.
     * 
     * @param resourceGroupName The name of the resource group within the partners subscription.
     * @param partnerNamespaceName Name of the partner namespace.
     * @param channelName Name of the channel.
     * @param channelInfo Channel information.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return channel info.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ChannelInner createOrUpdate(String resourceGroupName, String partnerNamespaceName, String channelName,
        ChannelInner channelInfo) {
        return createOrUpdateWithResponse(resourceGroupName, partnerNamespaceName, channelName, channelInfo,
            Context.NONE).getValue();
    }

    /**
     * Delete a channel.
     * 
     * Delete an existing channel.
     * 
     * @param resourceGroupName The name of the resource group within the partners subscription.
     * @param partnerNamespaceName Name of the partner namespace.
     * @param channelName Name of the channel.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName,
        String partnerNamespaceName, String channelName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (partnerNamespaceName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter partnerNamespaceName is required and cannot be null."));
        }
        if (channelName == null) {
            return Mono.error(new IllegalArgumentException("Parameter channelName is required and cannot be null."));
        }
        return FluxUtil
            .withContext(context -> service.delete(this.client.getEndpoint(), this.client.getSubscriptionId(),
                resourceGroupName, partnerNamespaceName, channelName, this.client.getApiVersion(), context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Delete a channel.
     * 
     * Delete an existing channel.
     * 
     * @param resourceGroupName The name of the resource group within the partners subscription.
     * @param partnerNamespaceName Name of the partner namespace.
     * @param channelName Name of the channel.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName,
        String partnerNamespaceName, String channelName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (partnerNamespaceName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter partnerNamespaceName is required and cannot be null."));
        }
        if (channelName == null) {
            return Mono.error(new IllegalArgumentException("Parameter channelName is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return service.delete(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName,
            partnerNamespaceName, channelName, this.client.getApiVersion(), context);
    }

    /**
     * Delete a channel.
     * 
     * Delete an existing channel.
     * 
     * @param resourceGroupName The name of the resource group within the partners subscription.
     * @param partnerNamespaceName Name of the partner namespace.
     * @param channelName Name of the channel.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String partnerNamespaceName,
        String channelName) {
        Mono<Response<Flux<ByteBuffer>>> mono
            = deleteWithResponseAsync(resourceGroupName, partnerNamespaceName, channelName);
        return this.client.<Void, Void>getLroResult(mono, this.client.getHttpPipeline(), Void.class, Void.class,
            this.client.getContext());
    }

    /**
     * Delete a channel.
     * 
     * Delete an existing channel.
     * 
     * @param resourceGroupName The name of the resource group within the partners subscription.
     * @param partnerNamespaceName Name of the partner namespace.
     * @param channelName Name of the channel.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String partnerNamespaceName,
        String channelName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono
            = deleteWithResponseAsync(resourceGroupName, partnerNamespaceName, channelName, context);
        return this.client.<Void, Void>getLroResult(mono, this.client.getHttpPipeline(), Void.class, Void.class,
            context);
    }

    /**
     * Delete a channel.
     * 
     * Delete an existing channel.
     * 
     * @param resourceGroupName The name of the resource group within the partners subscription.
     * @param partnerNamespaceName Name of the partner namespace.
     * @param channelName Name of the channel.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String partnerNamespaceName,
        String channelName) {
        return this.beginDeleteAsync(resourceGroupName, partnerNamespaceName, channelName).getSyncPoller();
    }

    /**
     * Delete a channel.
     * 
     * Delete an existing channel.
     * 
     * @param resourceGroupName The name of the resource group within the partners subscription.
     * @param partnerNamespaceName Name of the partner namespace.
     * @param channelName Name of the channel.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String partnerNamespaceName,
        String channelName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, partnerNamespaceName, channelName, context).getSyncPoller();
    }

    /**
     * Delete a channel.
     * 
     * Delete an existing channel.
     * 
     * @param resourceGroupName The name of the resource group within the partners subscription.
     * @param partnerNamespaceName Name of the partner namespace.
     * @param channelName Name of the channel.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String partnerNamespaceName, String channelName) {
        return beginDeleteAsync(resourceGroupName, partnerNamespaceName, channelName).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Delete a channel.
     * 
     * Delete an existing channel.
     * 
     * @param resourceGroupName The name of the resource group within the partners subscription.
     * @param partnerNamespaceName Name of the partner namespace.
     * @param channelName Name of the channel.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String partnerNamespaceName, String channelName,
        Context context) {
        return beginDeleteAsync(resourceGroupName, partnerNamespaceName, channelName, context).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Delete a channel.
     * 
     * Delete an existing channel.
     * 
     * @param resourceGroupName The name of the resource group within the partners subscription.
     * @param partnerNamespaceName Name of the partner namespace.
     * @param channelName Name of the channel.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void delete(String resourceGroupName, String partnerNamespaceName, String channelName) {
        deleteAsync(resourceGroupName, partnerNamespaceName, channelName).block();
    }

    /**
     * Delete a channel.
     * 
     * Delete an existing channel.
     * 
     * @param resourceGroupName The name of the resource group within the partners subscription.
     * @param partnerNamespaceName Name of the partner namespace.
     * @param channelName Name of the channel.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void delete(String resourceGroupName, String partnerNamespaceName, String channelName, Context context) {
        deleteAsync(resourceGroupName, partnerNamespaceName, channelName, context).block();
    }

    /**
     * Update a Channel.
     * 
     * Synchronously updates a channel with the specified parameters.
     * 
     * @param resourceGroupName The name of the resource group within the partners subscription.
     * @param partnerNamespaceName Name of the partner namespace.
     * @param channelName Name of the channel.
     * @param channelUpdateParameters Channel update information.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Void>> updateWithResponseAsync(String resourceGroupName, String partnerNamespaceName,
        String channelName, ChannelUpdateParameters channelUpdateParameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (partnerNamespaceName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter partnerNamespaceName is required and cannot be null."));
        }
        if (channelName == null) {
            return Mono.error(new IllegalArgumentException("Parameter channelName is required and cannot be null."));
        }
        if (channelUpdateParameters == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter channelUpdateParameters is required and cannot be null."));
        } else {
            channelUpdateParameters.validate();
        }
        return FluxUtil
            .withContext(
                context -> service.update(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName,
                    partnerNamespaceName, channelName, this.client.getApiVersion(), channelUpdateParameters, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Update a Channel.
     * 
     * Synchronously updates a channel with the specified parameters.
     * 
     * @param resourceGroupName The name of the resource group within the partners subscription.
     * @param partnerNamespaceName Name of the partner namespace.
     * @param channelName Name of the channel.
     * @param channelUpdateParameters Channel update information.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Void>> updateWithResponseAsync(String resourceGroupName, String partnerNamespaceName,
        String channelName, ChannelUpdateParameters channelUpdateParameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (partnerNamespaceName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter partnerNamespaceName is required and cannot be null."));
        }
        if (channelName == null) {
            return Mono.error(new IllegalArgumentException("Parameter channelName is required and cannot be null."));
        }
        if (channelUpdateParameters == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter channelUpdateParameters is required and cannot be null."));
        } else {
            channelUpdateParameters.validate();
        }
        context = this.client.mergeContext(context);
        return service.update(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName,
            partnerNamespaceName, channelName, this.client.getApiVersion(), channelUpdateParameters, context);
    }

    /**
     * Update a Channel.
     * 
     * Synchronously updates a channel with the specified parameters.
     * 
     * @param resourceGroupName The name of the resource group within the partners subscription.
     * @param partnerNamespaceName Name of the partner namespace.
     * @param channelName Name of the channel.
     * @param channelUpdateParameters Channel update information.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Void> updateAsync(String resourceGroupName, String partnerNamespaceName, String channelName,
        ChannelUpdateParameters channelUpdateParameters) {
        return updateWithResponseAsync(resourceGroupName, partnerNamespaceName, channelName, channelUpdateParameters)
            .flatMap(ignored -> Mono.empty());
    }

    /**
     * Update a Channel.
     * 
     * Synchronously updates a channel with the specified parameters.
     * 
     * @param resourceGroupName The name of the resource group within the partners subscription.
     * @param partnerNamespaceName Name of the partner namespace.
     * @param channelName Name of the channel.
     * @param channelUpdateParameters Channel update information.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> updateWithResponse(String resourceGroupName, String partnerNamespaceName, String channelName,
        ChannelUpdateParameters channelUpdateParameters, Context context) {
        return updateWithResponseAsync(resourceGroupName, partnerNamespaceName, channelName, channelUpdateParameters,
            context).block();
    }

    /**
     * Update a Channel.
     * 
     * Synchronously updates a channel with the specified parameters.
     * 
     * @param resourceGroupName The name of the resource group within the partners subscription.
     * @param partnerNamespaceName Name of the partner namespace.
     * @param channelName Name of the channel.
     * @param channelUpdateParameters Channel update information.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void update(String resourceGroupName, String partnerNamespaceName, String channelName,
        ChannelUpdateParameters channelUpdateParameters) {
        updateWithResponse(resourceGroupName, partnerNamespaceName, channelName, channelUpdateParameters, Context.NONE);
    }

    /**
     * List channels.
     * 
     * List all the channels in a partner namespace.
     * 
     * @param resourceGroupName The name of the resource group within the partners subscription.
     * @param partnerNamespaceName Name of the partner namespace.
     * @param filter The query used to filter the search results using OData syntax. Filtering is permitted on the
     * 'name' property only and with limited number of OData operations. These operations are: the 'contains' function
     * as well as the following logical operations: not, and, or, eq (for equal), and ne (for not equal). No arithmetic
     * operations are supported. The following is a valid filter example: $filter=contains(namE, 'PATTERN') and name ne
     * 'PATTERN-1'. The following is not a valid filter example: $filter=location eq 'westus'.
     * @param top The number of results to return per page for the list operation. Valid range for top parameter is 1 to
     * 100. If not specified, the default number of results to be returned is 20 items per page.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of the List Channels operation along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<ChannelInner>> listByPartnerNamespaceSinglePageAsync(String resourceGroupName,
        String partnerNamespaceName, String filter, Integer top) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (partnerNamespaceName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter partnerNamespaceName is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context -> service.listByPartnerNamespace(this.client.getEndpoint(), this.client.getSubscriptionId(),
                    resourceGroupName, partnerNamespaceName, this.client.getApiVersion(), filter, top, accept, context))
            .<PagedResponse<ChannelInner>>map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(),
                res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * List channels.
     * 
     * List all the channels in a partner namespace.
     * 
     * @param resourceGroupName The name of the resource group within the partners subscription.
     * @param partnerNamespaceName Name of the partner namespace.
     * @param filter The query used to filter the search results using OData syntax. Filtering is permitted on the
     * 'name' property only and with limited number of OData operations. These operations are: the 'contains' function
     * as well as the following logical operations: not, and, or, eq (for equal), and ne (for not equal). No arithmetic
     * operations are supported. The following is a valid filter example: $filter=contains(namE, 'PATTERN') and name ne
     * 'PATTERN-1'. The following is not a valid filter example: $filter=location eq 'westus'.
     * @param top The number of results to return per page for the list operation. Valid range for top parameter is 1 to
     * 100. If not specified, the default number of results to be returned is 20 items per page.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of the List Channels operation along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<ChannelInner>> listByPartnerNamespaceSinglePageAsync(String resourceGroupName,
        String partnerNamespaceName, String filter, Integer top, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (partnerNamespaceName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter partnerNamespaceName is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .listByPartnerNamespace(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName,
                partnerNamespaceName, this.client.getApiVersion(), filter, top, accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * List channels.
     * 
     * List all the channels in a partner namespace.
     * 
     * @param resourceGroupName The name of the resource group within the partners subscription.
     * @param partnerNamespaceName Name of the partner namespace.
     * @param filter The query used to filter the search results using OData syntax. Filtering is permitted on the
     * 'name' property only and with limited number of OData operations. These operations are: the 'contains' function
     * as well as the following logical operations: not, and, or, eq (for equal), and ne (for not equal). No arithmetic
     * operations are supported. The following is a valid filter example: $filter=contains(namE, 'PATTERN') and name ne
     * 'PATTERN-1'. The following is not a valid filter example: $filter=location eq 'westus'.
     * @param top The number of results to return per page for the list operation. Valid range for top parameter is 1 to
     * 100. If not specified, the default number of results to be returned is 20 items per page.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of the List Channels operation as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<ChannelInner> listByPartnerNamespaceAsync(String resourceGroupName, String partnerNamespaceName,
        String filter, Integer top) {
        return new PagedFlux<>(
            () -> listByPartnerNamespaceSinglePageAsync(resourceGroupName, partnerNamespaceName, filter, top),
            nextLink -> listByPartnerNamespaceNextSinglePageAsync(nextLink));
    }

    /**
     * List channels.
     * 
     * List all the channels in a partner namespace.
     * 
     * @param resourceGroupName The name of the resource group within the partners subscription.
     * @param partnerNamespaceName Name of the partner namespace.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of the List Channels operation as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<ChannelInner> listByPartnerNamespaceAsync(String resourceGroupName, String partnerNamespaceName) {
        final String filter = null;
        final Integer top = null;
        return new PagedFlux<>(
            () -> listByPartnerNamespaceSinglePageAsync(resourceGroupName, partnerNamespaceName, filter, top),
            nextLink -> listByPartnerNamespaceNextSinglePageAsync(nextLink));
    }

    /**
     * List channels.
     * 
     * List all the channels in a partner namespace.
     * 
     * @param resourceGroupName The name of the resource group within the partners subscription.
     * @param partnerNamespaceName Name of the partner namespace.
     * @param filter The query used to filter the search results using OData syntax. Filtering is permitted on the
     * 'name' property only and with limited number of OData operations. These operations are: the 'contains' function
     * as well as the following logical operations: not, and, or, eq (for equal), and ne (for not equal). No arithmetic
     * operations are supported. The following is a valid filter example: $filter=contains(namE, 'PATTERN') and name ne
     * 'PATTERN-1'. The following is not a valid filter example: $filter=location eq 'westus'.
     * @param top The number of results to return per page for the list operation. Valid range for top parameter is 1 to
     * 100. If not specified, the default number of results to be returned is 20 items per page.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of the List Channels operation as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<ChannelInner> listByPartnerNamespaceAsync(String resourceGroupName, String partnerNamespaceName,
        String filter, Integer top, Context context) {
        return new PagedFlux<>(
            () -> listByPartnerNamespaceSinglePageAsync(resourceGroupName, partnerNamespaceName, filter, top, context),
            nextLink -> listByPartnerNamespaceNextSinglePageAsync(nextLink, context));
    }

    /**
     * List channels.
     * 
     * List all the channels in a partner namespace.
     * 
     * @param resourceGroupName The name of the resource group within the partners subscription.
     * @param partnerNamespaceName Name of the partner namespace.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of the List Channels operation as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<ChannelInner> listByPartnerNamespace(String resourceGroupName, String partnerNamespaceName) {
        final String filter = null;
        final Integer top = null;
        return new PagedIterable<>(listByPartnerNamespaceAsync(resourceGroupName, partnerNamespaceName, filter, top));
    }

    /**
     * List channels.
     * 
     * List all the channels in a partner namespace.
     * 
     * @param resourceGroupName The name of the resource group within the partners subscription.
     * @param partnerNamespaceName Name of the partner namespace.
     * @param filter The query used to filter the search results using OData syntax. Filtering is permitted on the
     * 'name' property only and with limited number of OData operations. These operations are: the 'contains' function
     * as well as the following logical operations: not, and, or, eq (for equal), and ne (for not equal). No arithmetic
     * operations are supported. The following is a valid filter example: $filter=contains(namE, 'PATTERN') and name ne
     * 'PATTERN-1'. The following is not a valid filter example: $filter=location eq 'westus'.
     * @param top The number of results to return per page for the list operation. Valid range for top parameter is 1 to
     * 100. If not specified, the default number of results to be returned is 20 items per page.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of the List Channels operation as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<ChannelInner> listByPartnerNamespace(String resourceGroupName, String partnerNamespaceName,
        String filter, Integer top, Context context) {
        return new PagedIterable<>(
            listByPartnerNamespaceAsync(resourceGroupName, partnerNamespaceName, filter, top, context));
    }

    /**
     * Get full URL of partner destination channel.
     * 
     * Get the full endpoint URL of a partner destination channel.
     * 
     * @param resourceGroupName The name of the resource group within the partners subscription.
     * @param partnerNamespaceName Name of the partner namespace.
     * @param channelName Name of the Channel.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the full endpoint URL of a partner destination channel along with {@link Response} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<EventSubscriptionFullUrlInner>> getFullUrlWithResponseAsync(String resourceGroupName,
        String partnerNamespaceName, String channelName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (partnerNamespaceName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter partnerNamespaceName is required and cannot be null."));
        }
        if (channelName == null) {
            return Mono.error(new IllegalArgumentException("Parameter channelName is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.getFullUrl(this.client.getEndpoint(), this.client.getSubscriptionId(),
                resourceGroupName, partnerNamespaceName, channelName, this.client.getApiVersion(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get full URL of partner destination channel.
     * 
     * Get the full endpoint URL of a partner destination channel.
     * 
     * @param resourceGroupName The name of the resource group within the partners subscription.
     * @param partnerNamespaceName Name of the partner namespace.
     * @param channelName Name of the Channel.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the full endpoint URL of a partner destination channel along with {@link Response} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<EventSubscriptionFullUrlInner>> getFullUrlWithResponseAsync(String resourceGroupName,
        String partnerNamespaceName, String channelName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (partnerNamespaceName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter partnerNamespaceName is required and cannot be null."));
        }
        if (channelName == null) {
            return Mono.error(new IllegalArgumentException("Parameter channelName is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.getFullUrl(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName,
            partnerNamespaceName, channelName, this.client.getApiVersion(), accept, context);
    }

    /**
     * Get full URL of partner destination channel.
     * 
     * Get the full endpoint URL of a partner destination channel.
     * 
     * @param resourceGroupName The name of the resource group within the partners subscription.
     * @param partnerNamespaceName Name of the partner namespace.
     * @param channelName Name of the Channel.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the full endpoint URL of a partner destination channel on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<EventSubscriptionFullUrlInner> getFullUrlAsync(String resourceGroupName, String partnerNamespaceName,
        String channelName) {
        return getFullUrlWithResponseAsync(resourceGroupName, partnerNamespaceName, channelName)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Get full URL of partner destination channel.
     * 
     * Get the full endpoint URL of a partner destination channel.
     * 
     * @param resourceGroupName The name of the resource group within the partners subscription.
     * @param partnerNamespaceName Name of the partner namespace.
     * @param channelName Name of the Channel.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the full endpoint URL of a partner destination channel along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<EventSubscriptionFullUrlInner> getFullUrlWithResponse(String resourceGroupName,
        String partnerNamespaceName, String channelName, Context context) {
        return getFullUrlWithResponseAsync(resourceGroupName, partnerNamespaceName, channelName, context).block();
    }

    /**
     * Get full URL of partner destination channel.
     * 
     * Get the full endpoint URL of a partner destination channel.
     * 
     * @param resourceGroupName The name of the resource group within the partners subscription.
     * @param partnerNamespaceName Name of the partner namespace.
     * @param channelName Name of the Channel.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the full endpoint URL of a partner destination channel.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public EventSubscriptionFullUrlInner getFullUrl(String resourceGroupName, String partnerNamespaceName,
        String channelName) {
        return getFullUrlWithResponse(resourceGroupName, partnerNamespaceName, channelName, Context.NONE).getValue();
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of the List Channels operation along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<ChannelInner>> listByPartnerNamespaceNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context -> service.listByPartnerNamespaceNext(nextLink, this.client.getEndpoint(), accept, context))
            .<PagedResponse<ChannelInner>>map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(),
                res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of the List Channels operation along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<ChannelInner>> listByPartnerNamespaceNextSinglePageAsync(String nextLink,
        Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.listByPartnerNamespaceNext(nextLink, this.client.getEndpoint(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }
}
