// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.eventgrid.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.eventgrid.fluent.ClientGroupsClient;
import com.azure.resourcemanager.eventgrid.fluent.models.ClientGroupInner;
import com.azure.resourcemanager.eventgrid.models.ClientGroup;
import com.azure.resourcemanager.eventgrid.models.ClientGroups;

public final class ClientGroupsImpl implements ClientGroups {
    private static final ClientLogger LOGGER = new ClientLogger(ClientGroupsImpl.class);

    private final ClientGroupsClient innerClient;

    private final com.azure.resourcemanager.eventgrid.EventGridManager serviceManager;

    public ClientGroupsImpl(ClientGroupsClient innerClient,
        com.azure.resourcemanager.eventgrid.EventGridManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    public Response<ClientGroup> getWithResponse(String resourceGroupName, String namespaceName, String clientGroupName,
        Context context) {
        Response<ClientGroupInner> inner
            = this.serviceClient().getWithResponse(resourceGroupName, namespaceName, clientGroupName, context);
        if (inner != null) {
            return new SimpleResponse<>(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(),
                new ClientGroupImpl(inner.getValue(), this.manager()));
        } else {
            return null;
        }
    }

    public ClientGroup get(String resourceGroupName, String namespaceName, String clientGroupName) {
        ClientGroupInner inner = this.serviceClient().get(resourceGroupName, namespaceName, clientGroupName);
        if (inner != null) {
            return new ClientGroupImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public void delete(String resourceGroupName, String namespaceName, String clientGroupName) {
        this.serviceClient().delete(resourceGroupName, namespaceName, clientGroupName);
    }

    public void delete(String resourceGroupName, String namespaceName, String clientGroupName, Context context) {
        this.serviceClient().delete(resourceGroupName, namespaceName, clientGroupName, context);
    }

    public PagedIterable<ClientGroup> listByNamespace(String resourceGroupName, String namespaceName) {
        PagedIterable<ClientGroupInner> inner = this.serviceClient().listByNamespace(resourceGroupName, namespaceName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ClientGroupImpl(inner1, this.manager()));
    }

    public PagedIterable<ClientGroup> listByNamespace(String resourceGroupName, String namespaceName, String filter,
        Integer top, Context context) {
        PagedIterable<ClientGroupInner> inner
            = this.serviceClient().listByNamespace(resourceGroupName, namespaceName, filter, top, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ClientGroupImpl(inner1, this.manager()));
    }

    public ClientGroup getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String namespaceName = ResourceManagerUtils.getValueFromIdByName(id, "namespaces");
        if (namespaceName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'namespaces'.", id)));
        }
        String clientGroupName = ResourceManagerUtils.getValueFromIdByName(id, "clientGroups");
        if (clientGroupName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'clientGroups'.", id)));
        }
        return this.getWithResponse(resourceGroupName, namespaceName, clientGroupName, Context.NONE).getValue();
    }

    public Response<ClientGroup> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String namespaceName = ResourceManagerUtils.getValueFromIdByName(id, "namespaces");
        if (namespaceName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'namespaces'.", id)));
        }
        String clientGroupName = ResourceManagerUtils.getValueFromIdByName(id, "clientGroups");
        if (clientGroupName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'clientGroups'.", id)));
        }
        return this.getWithResponse(resourceGroupName, namespaceName, clientGroupName, context);
    }

    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String namespaceName = ResourceManagerUtils.getValueFromIdByName(id, "namespaces");
        if (namespaceName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'namespaces'.", id)));
        }
        String clientGroupName = ResourceManagerUtils.getValueFromIdByName(id, "clientGroups");
        if (clientGroupName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'clientGroups'.", id)));
        }
        this.delete(resourceGroupName, namespaceName, clientGroupName, Context.NONE);
    }

    public void deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String namespaceName = ResourceManagerUtils.getValueFromIdByName(id, "namespaces");
        if (namespaceName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'namespaces'.", id)));
        }
        String clientGroupName = ResourceManagerUtils.getValueFromIdByName(id, "clientGroups");
        if (clientGroupName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'clientGroups'.", id)));
        }
        this.delete(resourceGroupName, namespaceName, clientGroupName, context);
    }

    private ClientGroupsClient serviceClient() {
        return this.innerClient;
    }

    private com.azure.resourcemanager.eventgrid.EventGridManager manager() {
        return this.serviceManager;
    }

    public ClientGroupImpl define(String name) {
        return new ClientGroupImpl(name, this.manager());
    }
}
