// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.eventgrid.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.eventgrid.fluent.ClientsClient;
import com.azure.resourcemanager.eventgrid.fluent.models.ClientInner;
import com.azure.resourcemanager.eventgrid.models.Client;
import com.azure.resourcemanager.eventgrid.models.Clients;

public final class ClientsImpl implements Clients {
    private static final ClientLogger LOGGER = new ClientLogger(ClientsImpl.class);

    private final ClientsClient innerClient;

    private final com.azure.resourcemanager.eventgrid.EventGridManager serviceManager;

    public ClientsImpl(ClientsClient innerClient, com.azure.resourcemanager.eventgrid.EventGridManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    public Response<Client> getWithResponse(String resourceGroupName, String namespaceName, String clientName,
        Context context) {
        Response<ClientInner> inner
            = this.serviceClient().getWithResponse(resourceGroupName, namespaceName, clientName, context);
        if (inner != null) {
            return new SimpleResponse<>(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(),
                new ClientImpl(inner.getValue(), this.manager()));
        } else {
            return null;
        }
    }

    public Client get(String resourceGroupName, String namespaceName, String clientName) {
        ClientInner inner = this.serviceClient().get(resourceGroupName, namespaceName, clientName);
        if (inner != null) {
            return new ClientImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public void delete(String resourceGroupName, String namespaceName, String clientName) {
        this.serviceClient().delete(resourceGroupName, namespaceName, clientName);
    }

    public void delete(String resourceGroupName, String namespaceName, String clientName, Context context) {
        this.serviceClient().delete(resourceGroupName, namespaceName, clientName, context);
    }

    public PagedIterable<Client> listByNamespace(String resourceGroupName, String namespaceName) {
        PagedIterable<ClientInner> inner = this.serviceClient().listByNamespace(resourceGroupName, namespaceName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ClientImpl(inner1, this.manager()));
    }

    public PagedIterable<Client> listByNamespace(String resourceGroupName, String namespaceName, String filter,
        Integer top, Context context) {
        PagedIterable<ClientInner> inner
            = this.serviceClient().listByNamespace(resourceGroupName, namespaceName, filter, top, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ClientImpl(inner1, this.manager()));
    }

    public Client getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String namespaceName = ResourceManagerUtils.getValueFromIdByName(id, "namespaces");
        if (namespaceName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'namespaces'.", id)));
        }
        String clientName = ResourceManagerUtils.getValueFromIdByName(id, "clients");
        if (clientName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'clients'.", id)));
        }
        return this.getWithResponse(resourceGroupName, namespaceName, clientName, Context.NONE).getValue();
    }

    public Response<Client> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String namespaceName = ResourceManagerUtils.getValueFromIdByName(id, "namespaces");
        if (namespaceName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'namespaces'.", id)));
        }
        String clientName = ResourceManagerUtils.getValueFromIdByName(id, "clients");
        if (clientName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'clients'.", id)));
        }
        return this.getWithResponse(resourceGroupName, namespaceName, clientName, context);
    }

    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String namespaceName = ResourceManagerUtils.getValueFromIdByName(id, "namespaces");
        if (namespaceName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'namespaces'.", id)));
        }
        String clientName = ResourceManagerUtils.getValueFromIdByName(id, "clients");
        if (clientName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'clients'.", id)));
        }
        this.delete(resourceGroupName, namespaceName, clientName, Context.NONE);
    }

    public void deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String namespaceName = ResourceManagerUtils.getValueFromIdByName(id, "namespaces");
        if (namespaceName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'namespaces'.", id)));
        }
        String clientName = ResourceManagerUtils.getValueFromIdByName(id, "clients");
        if (clientName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'clients'.", id)));
        }
        this.delete(resourceGroupName, namespaceName, clientName, context);
    }

    private ClientsClient serviceClient() {
        return this.innerClient;
    }

    private com.azure.resourcemanager.eventgrid.EventGridManager manager() {
        return this.serviceManager;
    }

    public ClientImpl define(String name) {
        return new ClientImpl(name, this.manager());
    }
}
