// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.eventgrid.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.resourcemanager.eventgrid.fluent.NamespaceTopicEventSubscriptionsClient;
import com.azure.resourcemanager.eventgrid.fluent.models.DeliveryAttributeListResultInner;
import com.azure.resourcemanager.eventgrid.fluent.models.SubscriptionFullUrlInner;
import com.azure.resourcemanager.eventgrid.fluent.models.SubscriptionInner;
import com.azure.resourcemanager.eventgrid.models.SubscriptionUpdateParameters;
import com.azure.resourcemanager.eventgrid.models.SubscriptionsListResult;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

/**
 * An instance of this class provides access to all the operations defined in NamespaceTopicEventSubscriptionsClient.
 */
public final class NamespaceTopicEventSubscriptionsClientImpl implements NamespaceTopicEventSubscriptionsClient {
    /**
     * The proxy service used to perform REST calls.
     */
    private final NamespaceTopicEventSubscriptionsService service;

    /**
     * The service client containing this operation class.
     */
    private final EventGridManagementClientImpl client;

    /**
     * Initializes an instance of NamespaceTopicEventSubscriptionsClientImpl.
     * 
     * @param client the instance of the service client containing this operation class.
     */
    NamespaceTopicEventSubscriptionsClientImpl(EventGridManagementClientImpl client) {
        this.service = RestProxy.create(NamespaceTopicEventSubscriptionsService.class, client.getHttpPipeline(),
            client.getSerializerAdapter());
        this.client = client;
    }

    /**
     * The interface defining all the services for EventGridManagementClientNamespaceTopicEventSubscriptions to be used
     * by the proxy service to perform REST calls.
     */
    @Host("{$host}")
    @ServiceInterface(name = "EventGridManagementC")
    public interface NamespaceTopicEventSubscriptionsService {
        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/namespaces/{namespaceName}/topics/{topicName}/eventSubscriptions/{eventSubscriptionName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<SubscriptionInner>> get(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("namespaceName") String namespaceName,
            @PathParam("topicName") String topicName, @PathParam("eventSubscriptionName") String eventSubscriptionName,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Put("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/namespaces/{namespaceName}/topics/{topicName}/eventSubscriptions/{eventSubscriptionName}")
        @ExpectedResponses({ 200, 201 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> createOrUpdate(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("namespaceName") String namespaceName,
            @PathParam("topicName") String topicName, @PathParam("eventSubscriptionName") String eventSubscriptionName,
            @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") SubscriptionInner eventSubscriptionInfo,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Delete("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/namespaces/{namespaceName}/topics/{topicName}/eventSubscriptions/{eventSubscriptionName}")
        @ExpectedResponses({ 200, 202, 204 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> delete(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("namespaceName") String namespaceName,
            @PathParam("topicName") String topicName, @PathParam("eventSubscriptionName") String eventSubscriptionName,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Patch("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/namespaces/{namespaceName}/topics/{topicName}/eventSubscriptions/{eventSubscriptionName}")
        @ExpectedResponses({ 200, 202 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> update(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("namespaceName") String namespaceName,
            @PathParam("topicName") String topicName, @PathParam("eventSubscriptionName") String eventSubscriptionName,
            @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") SubscriptionUpdateParameters eventSubscriptionUpdateParameters,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/namespaces/{namespaceName}/topics/{topicName}/eventSubscriptions")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<SubscriptionsListResult>> listByNamespaceTopic(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("namespaceName") String namespaceName,
            @PathParam("topicName") String topicName, @QueryParam("api-version") String apiVersion,
            @QueryParam("$filter") String filter, @QueryParam("$top") Integer top, @HeaderParam("Accept") String accept,
            Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/namespaces/{namespaceName}/topics/{topicName}/eventSubscriptions/{eventSubscriptionName}/getDeliveryAttributes")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<DeliveryAttributeListResultInner>> getDeliveryAttributes(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("namespaceName") String namespaceName,
            @PathParam("topicName") String topicName, @PathParam("eventSubscriptionName") String eventSubscriptionName,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/namespaces/{namespaceName}/topics/{topicName}/eventSubscriptions/{eventSubscriptionName}/getFullUrl")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<SubscriptionFullUrlInner>> getFullUrl(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("namespaceName") String namespaceName,
            @PathParam("topicName") String topicName, @PathParam("eventSubscriptionName") String eventSubscriptionName,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<SubscriptionsListResult>> listByNamespaceTopicNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept, Context context);
    }

    /**
     * Get an event subscription of a namespace topic.
     * 
     * Get properties of an event subscription of a namespace topic.
     * 
     * @param resourceGroupName The name of the resource group within the user's subscription.
     * @param namespaceName Name of the namespace.
     * @param topicName Name of the namespace topic.
     * @param eventSubscriptionName Name of the event subscription to be found.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return properties of an event subscription of a namespace topic along with {@link Response} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<SubscriptionInner>> getWithResponseAsync(String resourceGroupName, String namespaceName,
        String topicName, String eventSubscriptionName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (namespaceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter namespaceName is required and cannot be null."));
        }
        if (topicName == null) {
            return Mono.error(new IllegalArgumentException("Parameter topicName is required and cannot be null."));
        }
        if (eventSubscriptionName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter eventSubscriptionName is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context -> service.get(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName,
                    namespaceName, topicName, eventSubscriptionName, this.client.getApiVersion(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get an event subscription of a namespace topic.
     * 
     * Get properties of an event subscription of a namespace topic.
     * 
     * @param resourceGroupName The name of the resource group within the user's subscription.
     * @param namespaceName Name of the namespace.
     * @param topicName Name of the namespace topic.
     * @param eventSubscriptionName Name of the event subscription to be found.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return properties of an event subscription of a namespace topic along with {@link Response} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<SubscriptionInner>> getWithResponseAsync(String resourceGroupName, String namespaceName,
        String topicName, String eventSubscriptionName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (namespaceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter namespaceName is required and cannot be null."));
        }
        if (topicName == null) {
            return Mono.error(new IllegalArgumentException("Parameter topicName is required and cannot be null."));
        }
        if (eventSubscriptionName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter eventSubscriptionName is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.get(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, namespaceName,
            topicName, eventSubscriptionName, this.client.getApiVersion(), accept, context);
    }

    /**
     * Get an event subscription of a namespace topic.
     * 
     * Get properties of an event subscription of a namespace topic.
     * 
     * @param resourceGroupName The name of the resource group within the user's subscription.
     * @param namespaceName Name of the namespace.
     * @param topicName Name of the namespace topic.
     * @param eventSubscriptionName Name of the event subscription to be found.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return properties of an event subscription of a namespace topic on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<SubscriptionInner> getAsync(String resourceGroupName, String namespaceName, String topicName,
        String eventSubscriptionName) {
        return getWithResponseAsync(resourceGroupName, namespaceName, topicName, eventSubscriptionName)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Get an event subscription of a namespace topic.
     * 
     * Get properties of an event subscription of a namespace topic.
     * 
     * @param resourceGroupName The name of the resource group within the user's subscription.
     * @param namespaceName Name of the namespace.
     * @param topicName Name of the namespace topic.
     * @param eventSubscriptionName Name of the event subscription to be found.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return properties of an event subscription of a namespace topic along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<SubscriptionInner> getWithResponse(String resourceGroupName, String namespaceName, String topicName,
        String eventSubscriptionName, Context context) {
        return getWithResponseAsync(resourceGroupName, namespaceName, topicName, eventSubscriptionName, context)
            .block();
    }

    /**
     * Get an event subscription of a namespace topic.
     * 
     * Get properties of an event subscription of a namespace topic.
     * 
     * @param resourceGroupName The name of the resource group within the user's subscription.
     * @param namespaceName Name of the namespace.
     * @param topicName Name of the namespace topic.
     * @param eventSubscriptionName Name of the event subscription to be found.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return properties of an event subscription of a namespace topic.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public SubscriptionInner get(String resourceGroupName, String namespaceName, String topicName,
        String eventSubscriptionName) {
        return getWithResponse(resourceGroupName, namespaceName, topicName, eventSubscriptionName, Context.NONE)
            .getValue();
    }

    /**
     * Create or update an event subscription of a namespace topic.
     * 
     * Asynchronously creates or updates an event subscription of a namespace topic with the specified parameters.
     * Existing event subscriptions will be updated with this API.
     * 
     * @param resourceGroupName The name of the resource group within the user's subscription.
     * @param namespaceName Name of the namespace.
     * @param topicName Name of the namespace topic.
     * @param eventSubscriptionName Name of the event subscription to be created. Event subscription names must be
     * between 3 and 50 characters in length and use alphanumeric letters only.
     * @param eventSubscriptionInfo Event subscription properties containing the delivery mode, filter information, and
     * others.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return event Subscription along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName,
        String namespaceName, String topicName, String eventSubscriptionName, SubscriptionInner eventSubscriptionInfo) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (namespaceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter namespaceName is required and cannot be null."));
        }
        if (topicName == null) {
            return Mono.error(new IllegalArgumentException("Parameter topicName is required and cannot be null."));
        }
        if (eventSubscriptionName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter eventSubscriptionName is required and cannot be null."));
        }
        if (eventSubscriptionInfo == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter eventSubscriptionInfo is required and cannot be null."));
        } else {
            eventSubscriptionInfo.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.createOrUpdate(this.client.getEndpoint(), this.client.getSubscriptionId(),
                resourceGroupName, namespaceName, topicName, eventSubscriptionName, this.client.getApiVersion(),
                eventSubscriptionInfo, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Create or update an event subscription of a namespace topic.
     * 
     * Asynchronously creates or updates an event subscription of a namespace topic with the specified parameters.
     * Existing event subscriptions will be updated with this API.
     * 
     * @param resourceGroupName The name of the resource group within the user's subscription.
     * @param namespaceName Name of the namespace.
     * @param topicName Name of the namespace topic.
     * @param eventSubscriptionName Name of the event subscription to be created. Event subscription names must be
     * between 3 and 50 characters in length and use alphanumeric letters only.
     * @param eventSubscriptionInfo Event subscription properties containing the delivery mode, filter information, and
     * others.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return event Subscription along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName,
        String namespaceName, String topicName, String eventSubscriptionName, SubscriptionInner eventSubscriptionInfo,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (namespaceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter namespaceName is required and cannot be null."));
        }
        if (topicName == null) {
            return Mono.error(new IllegalArgumentException("Parameter topicName is required and cannot be null."));
        }
        if (eventSubscriptionName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter eventSubscriptionName is required and cannot be null."));
        }
        if (eventSubscriptionInfo == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter eventSubscriptionInfo is required and cannot be null."));
        } else {
            eventSubscriptionInfo.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.createOrUpdate(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName,
            namespaceName, topicName, eventSubscriptionName, this.client.getApiVersion(), eventSubscriptionInfo, accept,
            context);
    }

    /**
     * Create or update an event subscription of a namespace topic.
     * 
     * Asynchronously creates or updates an event subscription of a namespace topic with the specified parameters.
     * Existing event subscriptions will be updated with this API.
     * 
     * @param resourceGroupName The name of the resource group within the user's subscription.
     * @param namespaceName Name of the namespace.
     * @param topicName Name of the namespace topic.
     * @param eventSubscriptionName Name of the event subscription to be created. Event subscription names must be
     * between 3 and 50 characters in length and use alphanumeric letters only.
     * @param eventSubscriptionInfo Event subscription properties containing the delivery mode, filter information, and
     * others.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of event Subscription.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<SubscriptionInner>, SubscriptionInner> beginCreateOrUpdateAsync(
        String resourceGroupName, String namespaceName, String topicName, String eventSubscriptionName,
        SubscriptionInner eventSubscriptionInfo) {
        Mono<Response<Flux<ByteBuffer>>> mono = createOrUpdateWithResponseAsync(resourceGroupName, namespaceName,
            topicName, eventSubscriptionName, eventSubscriptionInfo);
        return this.client.<SubscriptionInner, SubscriptionInner>getLroResult(mono, this.client.getHttpPipeline(),
            SubscriptionInner.class, SubscriptionInner.class, this.client.getContext());
    }

    /**
     * Create or update an event subscription of a namespace topic.
     * 
     * Asynchronously creates or updates an event subscription of a namespace topic with the specified parameters.
     * Existing event subscriptions will be updated with this API.
     * 
     * @param resourceGroupName The name of the resource group within the user's subscription.
     * @param namespaceName Name of the namespace.
     * @param topicName Name of the namespace topic.
     * @param eventSubscriptionName Name of the event subscription to be created. Event subscription names must be
     * between 3 and 50 characters in length and use alphanumeric letters only.
     * @param eventSubscriptionInfo Event subscription properties containing the delivery mode, filter information, and
     * others.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of event Subscription.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<SubscriptionInner>, SubscriptionInner> beginCreateOrUpdateAsync(
        String resourceGroupName, String namespaceName, String topicName, String eventSubscriptionName,
        SubscriptionInner eventSubscriptionInfo, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = createOrUpdateWithResponseAsync(resourceGroupName, namespaceName,
            topicName, eventSubscriptionName, eventSubscriptionInfo, context);
        return this.client.<SubscriptionInner, SubscriptionInner>getLroResult(mono, this.client.getHttpPipeline(),
            SubscriptionInner.class, SubscriptionInner.class, context);
    }

    /**
     * Create or update an event subscription of a namespace topic.
     * 
     * Asynchronously creates or updates an event subscription of a namespace topic with the specified parameters.
     * Existing event subscriptions will be updated with this API.
     * 
     * @param resourceGroupName The name of the resource group within the user's subscription.
     * @param namespaceName Name of the namespace.
     * @param topicName Name of the namespace topic.
     * @param eventSubscriptionName Name of the event subscription to be created. Event subscription names must be
     * between 3 and 50 characters in length and use alphanumeric letters only.
     * @param eventSubscriptionInfo Event subscription properties containing the delivery mode, filter information, and
     * others.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of event Subscription.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<SubscriptionInner>, SubscriptionInner> beginCreateOrUpdate(String resourceGroupName,
        String namespaceName, String topicName, String eventSubscriptionName, SubscriptionInner eventSubscriptionInfo) {
        return this
            .beginCreateOrUpdateAsync(resourceGroupName, namespaceName, topicName, eventSubscriptionName,
                eventSubscriptionInfo)
            .getSyncPoller();
    }

    /**
     * Create or update an event subscription of a namespace topic.
     * 
     * Asynchronously creates or updates an event subscription of a namespace topic with the specified parameters.
     * Existing event subscriptions will be updated with this API.
     * 
     * @param resourceGroupName The name of the resource group within the user's subscription.
     * @param namespaceName Name of the namespace.
     * @param topicName Name of the namespace topic.
     * @param eventSubscriptionName Name of the event subscription to be created. Event subscription names must be
     * between 3 and 50 characters in length and use alphanumeric letters only.
     * @param eventSubscriptionInfo Event subscription properties containing the delivery mode, filter information, and
     * others.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of event Subscription.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<SubscriptionInner>, SubscriptionInner> beginCreateOrUpdate(String resourceGroupName,
        String namespaceName, String topicName, String eventSubscriptionName, SubscriptionInner eventSubscriptionInfo,
        Context context) {
        return this
            .beginCreateOrUpdateAsync(resourceGroupName, namespaceName, topicName, eventSubscriptionName,
                eventSubscriptionInfo, context)
            .getSyncPoller();
    }

    /**
     * Create or update an event subscription of a namespace topic.
     * 
     * Asynchronously creates or updates an event subscription of a namespace topic with the specified parameters.
     * Existing event subscriptions will be updated with this API.
     * 
     * @param resourceGroupName The name of the resource group within the user's subscription.
     * @param namespaceName Name of the namespace.
     * @param topicName Name of the namespace topic.
     * @param eventSubscriptionName Name of the event subscription to be created. Event subscription names must be
     * between 3 and 50 characters in length and use alphanumeric letters only.
     * @param eventSubscriptionInfo Event subscription properties containing the delivery mode, filter information, and
     * others.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return event Subscription on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<SubscriptionInner> createOrUpdateAsync(String resourceGroupName, String namespaceName,
        String topicName, String eventSubscriptionName, SubscriptionInner eventSubscriptionInfo) {
        return beginCreateOrUpdateAsync(resourceGroupName, namespaceName, topicName, eventSubscriptionName,
            eventSubscriptionInfo).last().flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Create or update an event subscription of a namespace topic.
     * 
     * Asynchronously creates or updates an event subscription of a namespace topic with the specified parameters.
     * Existing event subscriptions will be updated with this API.
     * 
     * @param resourceGroupName The name of the resource group within the user's subscription.
     * @param namespaceName Name of the namespace.
     * @param topicName Name of the namespace topic.
     * @param eventSubscriptionName Name of the event subscription to be created. Event subscription names must be
     * between 3 and 50 characters in length and use alphanumeric letters only.
     * @param eventSubscriptionInfo Event subscription properties containing the delivery mode, filter information, and
     * others.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return event Subscription on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<SubscriptionInner> createOrUpdateAsync(String resourceGroupName, String namespaceName,
        String topicName, String eventSubscriptionName, SubscriptionInner eventSubscriptionInfo, Context context) {
        return beginCreateOrUpdateAsync(resourceGroupName, namespaceName, topicName, eventSubscriptionName,
            eventSubscriptionInfo, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Create or update an event subscription of a namespace topic.
     * 
     * Asynchronously creates or updates an event subscription of a namespace topic with the specified parameters.
     * Existing event subscriptions will be updated with this API.
     * 
     * @param resourceGroupName The name of the resource group within the user's subscription.
     * @param namespaceName Name of the namespace.
     * @param topicName Name of the namespace topic.
     * @param eventSubscriptionName Name of the event subscription to be created. Event subscription names must be
     * between 3 and 50 characters in length and use alphanumeric letters only.
     * @param eventSubscriptionInfo Event subscription properties containing the delivery mode, filter information, and
     * others.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return event Subscription.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public SubscriptionInner createOrUpdate(String resourceGroupName, String namespaceName, String topicName,
        String eventSubscriptionName, SubscriptionInner eventSubscriptionInfo) {
        return createOrUpdateAsync(resourceGroupName, namespaceName, topicName, eventSubscriptionName,
            eventSubscriptionInfo).block();
    }

    /**
     * Create or update an event subscription of a namespace topic.
     * 
     * Asynchronously creates or updates an event subscription of a namespace topic with the specified parameters.
     * Existing event subscriptions will be updated with this API.
     * 
     * @param resourceGroupName The name of the resource group within the user's subscription.
     * @param namespaceName Name of the namespace.
     * @param topicName Name of the namespace topic.
     * @param eventSubscriptionName Name of the event subscription to be created. Event subscription names must be
     * between 3 and 50 characters in length and use alphanumeric letters only.
     * @param eventSubscriptionInfo Event subscription properties containing the delivery mode, filter information, and
     * others.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return event Subscription.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public SubscriptionInner createOrUpdate(String resourceGroupName, String namespaceName, String topicName,
        String eventSubscriptionName, SubscriptionInner eventSubscriptionInfo, Context context) {
        return createOrUpdateAsync(resourceGroupName, namespaceName, topicName, eventSubscriptionName,
            eventSubscriptionInfo, context).block();
    }

    /**
     * Delete an event subscription of a namespace topic.
     * 
     * Delete an existing event subscription of a namespace topic.
     * 
     * @param resourceGroupName The name of the resource group within the user's subscription.
     * @param namespaceName Name of the namespace.
     * @param topicName Name of the namespace topic.
     * @param eventSubscriptionName Name of the event subscription to be deleted.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String namespaceName,
        String topicName, String eventSubscriptionName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (namespaceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter namespaceName is required and cannot be null."));
        }
        if (topicName == null) {
            return Mono.error(new IllegalArgumentException("Parameter topicName is required and cannot be null."));
        }
        if (eventSubscriptionName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter eventSubscriptionName is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context -> service.delete(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName,
                    namespaceName, topicName, eventSubscriptionName, this.client.getApiVersion(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Delete an event subscription of a namespace topic.
     * 
     * Delete an existing event subscription of a namespace topic.
     * 
     * @param resourceGroupName The name of the resource group within the user's subscription.
     * @param namespaceName Name of the namespace.
     * @param topicName Name of the namespace topic.
     * @param eventSubscriptionName Name of the event subscription to be deleted.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String namespaceName,
        String topicName, String eventSubscriptionName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (namespaceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter namespaceName is required and cannot be null."));
        }
        if (topicName == null) {
            return Mono.error(new IllegalArgumentException("Parameter topicName is required and cannot be null."));
        }
        if (eventSubscriptionName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter eventSubscriptionName is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.delete(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName,
            namespaceName, topicName, eventSubscriptionName, this.client.getApiVersion(), accept, context);
    }

    /**
     * Delete an event subscription of a namespace topic.
     * 
     * Delete an existing event subscription of a namespace topic.
     * 
     * @param resourceGroupName The name of the resource group within the user's subscription.
     * @param namespaceName Name of the namespace.
     * @param topicName Name of the namespace topic.
     * @param eventSubscriptionName Name of the event subscription to be deleted.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String namespaceName,
        String topicName, String eventSubscriptionName) {
        Mono<Response<Flux<ByteBuffer>>> mono
            = deleteWithResponseAsync(resourceGroupName, namespaceName, topicName, eventSubscriptionName);
        return this.client.<Void, Void>getLroResult(mono, this.client.getHttpPipeline(), Void.class, Void.class,
            this.client.getContext());
    }

    /**
     * Delete an event subscription of a namespace topic.
     * 
     * Delete an existing event subscription of a namespace topic.
     * 
     * @param resourceGroupName The name of the resource group within the user's subscription.
     * @param namespaceName Name of the namespace.
     * @param topicName Name of the namespace topic.
     * @param eventSubscriptionName Name of the event subscription to be deleted.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String namespaceName,
        String topicName, String eventSubscriptionName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono
            = deleteWithResponseAsync(resourceGroupName, namespaceName, topicName, eventSubscriptionName, context);
        return this.client.<Void, Void>getLroResult(mono, this.client.getHttpPipeline(), Void.class, Void.class,
            context);
    }

    /**
     * Delete an event subscription of a namespace topic.
     * 
     * Delete an existing event subscription of a namespace topic.
     * 
     * @param resourceGroupName The name of the resource group within the user's subscription.
     * @param namespaceName Name of the namespace.
     * @param topicName Name of the namespace topic.
     * @param eventSubscriptionName Name of the event subscription to be deleted.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String namespaceName,
        String topicName, String eventSubscriptionName) {
        return this.beginDeleteAsync(resourceGroupName, namespaceName, topicName, eventSubscriptionName)
            .getSyncPoller();
    }

    /**
     * Delete an event subscription of a namespace topic.
     * 
     * Delete an existing event subscription of a namespace topic.
     * 
     * @param resourceGroupName The name of the resource group within the user's subscription.
     * @param namespaceName Name of the namespace.
     * @param topicName Name of the namespace topic.
     * @param eventSubscriptionName Name of the event subscription to be deleted.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String namespaceName,
        String topicName, String eventSubscriptionName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, namespaceName, topicName, eventSubscriptionName, context)
            .getSyncPoller();
    }

    /**
     * Delete an event subscription of a namespace topic.
     * 
     * Delete an existing event subscription of a namespace topic.
     * 
     * @param resourceGroupName The name of the resource group within the user's subscription.
     * @param namespaceName Name of the namespace.
     * @param topicName Name of the namespace topic.
     * @param eventSubscriptionName Name of the event subscription to be deleted.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String namespaceName, String topicName,
        String eventSubscriptionName) {
        return beginDeleteAsync(resourceGroupName, namespaceName, topicName, eventSubscriptionName).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Delete an event subscription of a namespace topic.
     * 
     * Delete an existing event subscription of a namespace topic.
     * 
     * @param resourceGroupName The name of the resource group within the user's subscription.
     * @param namespaceName Name of the namespace.
     * @param topicName Name of the namespace topic.
     * @param eventSubscriptionName Name of the event subscription to be deleted.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String namespaceName, String topicName,
        String eventSubscriptionName, Context context) {
        return beginDeleteAsync(resourceGroupName, namespaceName, topicName, eventSubscriptionName, context).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Delete an event subscription of a namespace topic.
     * 
     * Delete an existing event subscription of a namespace topic.
     * 
     * @param resourceGroupName The name of the resource group within the user's subscription.
     * @param namespaceName Name of the namespace.
     * @param topicName Name of the namespace topic.
     * @param eventSubscriptionName Name of the event subscription to be deleted.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void delete(String resourceGroupName, String namespaceName, String topicName, String eventSubscriptionName) {
        deleteAsync(resourceGroupName, namespaceName, topicName, eventSubscriptionName).block();
    }

    /**
     * Delete an event subscription of a namespace topic.
     * 
     * Delete an existing event subscription of a namespace topic.
     * 
     * @param resourceGroupName The name of the resource group within the user's subscription.
     * @param namespaceName Name of the namespace.
     * @param topicName Name of the namespace topic.
     * @param eventSubscriptionName Name of the event subscription to be deleted.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void delete(String resourceGroupName, String namespaceName, String topicName, String eventSubscriptionName,
        Context context) {
        deleteAsync(resourceGroupName, namespaceName, topicName, eventSubscriptionName, context).block();
    }

    /**
     * Update event subscription of a namespace topic.
     * 
     * Update an existing event subscription of a namespace topic.
     * 
     * @param resourceGroupName The name of the resource group within the user's subscription.
     * @param namespaceName Name of the namespace.
     * @param topicName Name of the namespace topic.
     * @param eventSubscriptionName Name of the event subscription to be updated.
     * @param eventSubscriptionUpdateParameters Updated event subscription information.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return event Subscription along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String namespaceName,
        String topicName, String eventSubscriptionName,
        SubscriptionUpdateParameters eventSubscriptionUpdateParameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (namespaceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter namespaceName is required and cannot be null."));
        }
        if (topicName == null) {
            return Mono.error(new IllegalArgumentException("Parameter topicName is required and cannot be null."));
        }
        if (eventSubscriptionName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter eventSubscriptionName is required and cannot be null."));
        }
        if (eventSubscriptionUpdateParameters == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter eventSubscriptionUpdateParameters is required and cannot be null."));
        } else {
            eventSubscriptionUpdateParameters.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.update(this.client.getEndpoint(), this.client.getSubscriptionId(),
                resourceGroupName, namespaceName, topicName, eventSubscriptionName, this.client.getApiVersion(),
                eventSubscriptionUpdateParameters, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Update event subscription of a namespace topic.
     * 
     * Update an existing event subscription of a namespace topic.
     * 
     * @param resourceGroupName The name of the resource group within the user's subscription.
     * @param namespaceName Name of the namespace.
     * @param topicName Name of the namespace topic.
     * @param eventSubscriptionName Name of the event subscription to be updated.
     * @param eventSubscriptionUpdateParameters Updated event subscription information.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return event Subscription along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String namespaceName,
        String topicName, String eventSubscriptionName, SubscriptionUpdateParameters eventSubscriptionUpdateParameters,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (namespaceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter namespaceName is required and cannot be null."));
        }
        if (topicName == null) {
            return Mono.error(new IllegalArgumentException("Parameter topicName is required and cannot be null."));
        }
        if (eventSubscriptionName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter eventSubscriptionName is required and cannot be null."));
        }
        if (eventSubscriptionUpdateParameters == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter eventSubscriptionUpdateParameters is required and cannot be null."));
        } else {
            eventSubscriptionUpdateParameters.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.update(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName,
            namespaceName, topicName, eventSubscriptionName, this.client.getApiVersion(),
            eventSubscriptionUpdateParameters, accept, context);
    }

    /**
     * Update event subscription of a namespace topic.
     * 
     * Update an existing event subscription of a namespace topic.
     * 
     * @param resourceGroupName The name of the resource group within the user's subscription.
     * @param namespaceName Name of the namespace.
     * @param topicName Name of the namespace topic.
     * @param eventSubscriptionName Name of the event subscription to be updated.
     * @param eventSubscriptionUpdateParameters Updated event subscription information.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of event Subscription.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<SubscriptionInner>, SubscriptionInner> beginUpdateAsync(String resourceGroupName,
        String namespaceName, String topicName, String eventSubscriptionName,
        SubscriptionUpdateParameters eventSubscriptionUpdateParameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = updateWithResponseAsync(resourceGroupName, namespaceName, topicName,
            eventSubscriptionName, eventSubscriptionUpdateParameters);
        return this.client.<SubscriptionInner, SubscriptionInner>getLroResult(mono, this.client.getHttpPipeline(),
            SubscriptionInner.class, SubscriptionInner.class, this.client.getContext());
    }

    /**
     * Update event subscription of a namespace topic.
     * 
     * Update an existing event subscription of a namespace topic.
     * 
     * @param resourceGroupName The name of the resource group within the user's subscription.
     * @param namespaceName Name of the namespace.
     * @param topicName Name of the namespace topic.
     * @param eventSubscriptionName Name of the event subscription to be updated.
     * @param eventSubscriptionUpdateParameters Updated event subscription information.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of event Subscription.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<SubscriptionInner>, SubscriptionInner> beginUpdateAsync(String resourceGroupName,
        String namespaceName, String topicName, String eventSubscriptionName,
        SubscriptionUpdateParameters eventSubscriptionUpdateParameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = updateWithResponseAsync(resourceGroupName, namespaceName, topicName,
            eventSubscriptionName, eventSubscriptionUpdateParameters, context);
        return this.client.<SubscriptionInner, SubscriptionInner>getLroResult(mono, this.client.getHttpPipeline(),
            SubscriptionInner.class, SubscriptionInner.class, context);
    }

    /**
     * Update event subscription of a namespace topic.
     * 
     * Update an existing event subscription of a namespace topic.
     * 
     * @param resourceGroupName The name of the resource group within the user's subscription.
     * @param namespaceName Name of the namespace.
     * @param topicName Name of the namespace topic.
     * @param eventSubscriptionName Name of the event subscription to be updated.
     * @param eventSubscriptionUpdateParameters Updated event subscription information.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of event Subscription.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<SubscriptionInner>, SubscriptionInner> beginUpdate(String resourceGroupName,
        String namespaceName, String topicName, String eventSubscriptionName,
        SubscriptionUpdateParameters eventSubscriptionUpdateParameters) {
        return this
            .beginUpdateAsync(resourceGroupName, namespaceName, topicName, eventSubscriptionName,
                eventSubscriptionUpdateParameters)
            .getSyncPoller();
    }

    /**
     * Update event subscription of a namespace topic.
     * 
     * Update an existing event subscription of a namespace topic.
     * 
     * @param resourceGroupName The name of the resource group within the user's subscription.
     * @param namespaceName Name of the namespace.
     * @param topicName Name of the namespace topic.
     * @param eventSubscriptionName Name of the event subscription to be updated.
     * @param eventSubscriptionUpdateParameters Updated event subscription information.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of event Subscription.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<SubscriptionInner>, SubscriptionInner> beginUpdate(String resourceGroupName,
        String namespaceName, String topicName, String eventSubscriptionName,
        SubscriptionUpdateParameters eventSubscriptionUpdateParameters, Context context) {
        return this
            .beginUpdateAsync(resourceGroupName, namespaceName, topicName, eventSubscriptionName,
                eventSubscriptionUpdateParameters, context)
            .getSyncPoller();
    }

    /**
     * Update event subscription of a namespace topic.
     * 
     * Update an existing event subscription of a namespace topic.
     * 
     * @param resourceGroupName The name of the resource group within the user's subscription.
     * @param namespaceName Name of the namespace.
     * @param topicName Name of the namespace topic.
     * @param eventSubscriptionName Name of the event subscription to be updated.
     * @param eventSubscriptionUpdateParameters Updated event subscription information.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return event Subscription on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<SubscriptionInner> updateAsync(String resourceGroupName, String namespaceName, String topicName,
        String eventSubscriptionName, SubscriptionUpdateParameters eventSubscriptionUpdateParameters) {
        return beginUpdateAsync(resourceGroupName, namespaceName, topicName, eventSubscriptionName,
            eventSubscriptionUpdateParameters).last().flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Update event subscription of a namespace topic.
     * 
     * Update an existing event subscription of a namespace topic.
     * 
     * @param resourceGroupName The name of the resource group within the user's subscription.
     * @param namespaceName Name of the namespace.
     * @param topicName Name of the namespace topic.
     * @param eventSubscriptionName Name of the event subscription to be updated.
     * @param eventSubscriptionUpdateParameters Updated event subscription information.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return event Subscription on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<SubscriptionInner> updateAsync(String resourceGroupName, String namespaceName, String topicName,
        String eventSubscriptionName, SubscriptionUpdateParameters eventSubscriptionUpdateParameters, Context context) {
        return beginUpdateAsync(resourceGroupName, namespaceName, topicName, eventSubscriptionName,
            eventSubscriptionUpdateParameters, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Update event subscription of a namespace topic.
     * 
     * Update an existing event subscription of a namespace topic.
     * 
     * @param resourceGroupName The name of the resource group within the user's subscription.
     * @param namespaceName Name of the namespace.
     * @param topicName Name of the namespace topic.
     * @param eventSubscriptionName Name of the event subscription to be updated.
     * @param eventSubscriptionUpdateParameters Updated event subscription information.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return event Subscription.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public SubscriptionInner update(String resourceGroupName, String namespaceName, String topicName,
        String eventSubscriptionName, SubscriptionUpdateParameters eventSubscriptionUpdateParameters) {
        return updateAsync(resourceGroupName, namespaceName, topicName, eventSubscriptionName,
            eventSubscriptionUpdateParameters).block();
    }

    /**
     * Update event subscription of a namespace topic.
     * 
     * Update an existing event subscription of a namespace topic.
     * 
     * @param resourceGroupName The name of the resource group within the user's subscription.
     * @param namespaceName Name of the namespace.
     * @param topicName Name of the namespace topic.
     * @param eventSubscriptionName Name of the event subscription to be updated.
     * @param eventSubscriptionUpdateParameters Updated event subscription information.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return event Subscription.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public SubscriptionInner update(String resourceGroupName, String namespaceName, String topicName,
        String eventSubscriptionName, SubscriptionUpdateParameters eventSubscriptionUpdateParameters, Context context) {
        return updateAsync(resourceGroupName, namespaceName, topicName, eventSubscriptionName,
            eventSubscriptionUpdateParameters, context).block();
    }

    /**
     * List event subscriptions of a namespace topic.
     * 
     * List event subscriptions that belong to a specific namespace topic.
     * 
     * @param resourceGroupName The name of the resource group within the user's subscription.
     * @param namespaceName Name of the namespace.
     * @param topicName Name of the namespace topic.
     * @param filter The query used to filter the search results using OData syntax. Filtering is permitted on the
     * 'name' property only and with limited number of OData operations. These operations are: the 'contains' function
     * as well as the following logical operations: not, and, or, eq (for equal), and ne (for not equal). No arithmetic
     * operations are supported. The following is a valid filter example: $filter=contains(namE, 'PATTERN') and name ne
     * 'PATTERN-1'. The following is not a valid filter example: $filter=location eq 'westus'.
     * @param top The number of results to return per page for the list operation. Valid range for top parameter is 1 to
     * 100. If not specified, the default number of results to be returned is 20 items per page.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of the List event subscriptions operation along with {@link PagedResponse} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<SubscriptionInner>> listByNamespaceTopicSinglePageAsync(String resourceGroupName,
        String namespaceName, String topicName, String filter, Integer top) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (namespaceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter namespaceName is required and cannot be null."));
        }
        if (topicName == null) {
            return Mono.error(new IllegalArgumentException("Parameter topicName is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listByNamespaceTopic(this.client.getEndpoint(),
                this.client.getSubscriptionId(), resourceGroupName, namespaceName, topicName,
                this.client.getApiVersion(), filter, top, accept, context))
            .<PagedResponse<SubscriptionInner>>map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(),
                res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * List event subscriptions of a namespace topic.
     * 
     * List event subscriptions that belong to a specific namespace topic.
     * 
     * @param resourceGroupName The name of the resource group within the user's subscription.
     * @param namespaceName Name of the namespace.
     * @param topicName Name of the namespace topic.
     * @param filter The query used to filter the search results using OData syntax. Filtering is permitted on the
     * 'name' property only and with limited number of OData operations. These operations are: the 'contains' function
     * as well as the following logical operations: not, and, or, eq (for equal), and ne (for not equal). No arithmetic
     * operations are supported. The following is a valid filter example: $filter=contains(namE, 'PATTERN') and name ne
     * 'PATTERN-1'. The following is not a valid filter example: $filter=location eq 'westus'.
     * @param top The number of results to return per page for the list operation. Valid range for top parameter is 1 to
     * 100. If not specified, the default number of results to be returned is 20 items per page.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of the List event subscriptions operation along with {@link PagedResponse} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<SubscriptionInner>> listByNamespaceTopicSinglePageAsync(String resourceGroupName,
        String namespaceName, String topicName, String filter, Integer top, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (namespaceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter namespaceName is required and cannot be null."));
        }
        if (topicName == null) {
            return Mono.error(new IllegalArgumentException("Parameter topicName is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .listByNamespaceTopic(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName,
                namespaceName, topicName, this.client.getApiVersion(), filter, top, accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * List event subscriptions of a namespace topic.
     * 
     * List event subscriptions that belong to a specific namespace topic.
     * 
     * @param resourceGroupName The name of the resource group within the user's subscription.
     * @param namespaceName Name of the namespace.
     * @param topicName Name of the namespace topic.
     * @param filter The query used to filter the search results using OData syntax. Filtering is permitted on the
     * 'name' property only and with limited number of OData operations. These operations are: the 'contains' function
     * as well as the following logical operations: not, and, or, eq (for equal), and ne (for not equal). No arithmetic
     * operations are supported. The following is a valid filter example: $filter=contains(namE, 'PATTERN') and name ne
     * 'PATTERN-1'. The following is not a valid filter example: $filter=location eq 'westus'.
     * @param top The number of results to return per page for the list operation. Valid range for top parameter is 1 to
     * 100. If not specified, the default number of results to be returned is 20 items per page.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of the List event subscriptions operation as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<SubscriptionInner> listByNamespaceTopicAsync(String resourceGroupName, String namespaceName,
        String topicName, String filter, Integer top) {
        return new PagedFlux<>(
            () -> listByNamespaceTopicSinglePageAsync(resourceGroupName, namespaceName, topicName, filter, top),
            nextLink -> listByNamespaceTopicNextSinglePageAsync(nextLink));
    }

    /**
     * List event subscriptions of a namespace topic.
     * 
     * List event subscriptions that belong to a specific namespace topic.
     * 
     * @param resourceGroupName The name of the resource group within the user's subscription.
     * @param namespaceName Name of the namespace.
     * @param topicName Name of the namespace topic.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of the List event subscriptions operation as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<SubscriptionInner> listByNamespaceTopicAsync(String resourceGroupName, String namespaceName,
        String topicName) {
        final String filter = null;
        final Integer top = null;
        return new PagedFlux<>(
            () -> listByNamespaceTopicSinglePageAsync(resourceGroupName, namespaceName, topicName, filter, top),
            nextLink -> listByNamespaceTopicNextSinglePageAsync(nextLink));
    }

    /**
     * List event subscriptions of a namespace topic.
     * 
     * List event subscriptions that belong to a specific namespace topic.
     * 
     * @param resourceGroupName The name of the resource group within the user's subscription.
     * @param namespaceName Name of the namespace.
     * @param topicName Name of the namespace topic.
     * @param filter The query used to filter the search results using OData syntax. Filtering is permitted on the
     * 'name' property only and with limited number of OData operations. These operations are: the 'contains' function
     * as well as the following logical operations: not, and, or, eq (for equal), and ne (for not equal). No arithmetic
     * operations are supported. The following is a valid filter example: $filter=contains(namE, 'PATTERN') and name ne
     * 'PATTERN-1'. The following is not a valid filter example: $filter=location eq 'westus'.
     * @param top The number of results to return per page for the list operation. Valid range for top parameter is 1 to
     * 100. If not specified, the default number of results to be returned is 20 items per page.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of the List event subscriptions operation as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<SubscriptionInner> listByNamespaceTopicAsync(String resourceGroupName, String namespaceName,
        String topicName, String filter, Integer top, Context context) {
        return new PagedFlux<>(() -> listByNamespaceTopicSinglePageAsync(resourceGroupName, namespaceName, topicName,
            filter, top, context), nextLink -> listByNamespaceTopicNextSinglePageAsync(nextLink, context));
    }

    /**
     * List event subscriptions of a namespace topic.
     * 
     * List event subscriptions that belong to a specific namespace topic.
     * 
     * @param resourceGroupName The name of the resource group within the user's subscription.
     * @param namespaceName Name of the namespace.
     * @param topicName Name of the namespace topic.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of the List event subscriptions operation as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<SubscriptionInner> listByNamespaceTopic(String resourceGroupName, String namespaceName,
        String topicName) {
        final String filter = null;
        final Integer top = null;
        return new PagedIterable<>(listByNamespaceTopicAsync(resourceGroupName, namespaceName, topicName, filter, top));
    }

    /**
     * List event subscriptions of a namespace topic.
     * 
     * List event subscriptions that belong to a specific namespace topic.
     * 
     * @param resourceGroupName The name of the resource group within the user's subscription.
     * @param namespaceName Name of the namespace.
     * @param topicName Name of the namespace topic.
     * @param filter The query used to filter the search results using OData syntax. Filtering is permitted on the
     * 'name' property only and with limited number of OData operations. These operations are: the 'contains' function
     * as well as the following logical operations: not, and, or, eq (for equal), and ne (for not equal). No arithmetic
     * operations are supported. The following is a valid filter example: $filter=contains(namE, 'PATTERN') and name ne
     * 'PATTERN-1'. The following is not a valid filter example: $filter=location eq 'westus'.
     * @param top The number of results to return per page for the list operation. Valid range for top parameter is 1 to
     * 100. If not specified, the default number of results to be returned is 20 items per page.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of the List event subscriptions operation as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<SubscriptionInner> listByNamespaceTopic(String resourceGroupName, String namespaceName,
        String topicName, String filter, Integer top, Context context) {
        return new PagedIterable<>(
            listByNamespaceTopicAsync(resourceGroupName, namespaceName, topicName, filter, top, context));
    }

    /**
     * Get delivery attributes for an event subscription of a namespace topic.
     * 
     * Get all delivery attributes for an event subscription of a namespace topic.
     * 
     * @param resourceGroupName The name of the resource group within the user's subscription.
     * @param namespaceName Name of the namespace.
     * @param topicName Name of the namespace topic.
     * @param eventSubscriptionName Name of the event subscription.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all delivery attributes for an event subscription of a namespace topic along with {@link Response} on
     * successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<DeliveryAttributeListResultInner>> getDeliveryAttributesWithResponseAsync(
        String resourceGroupName, String namespaceName, String topicName, String eventSubscriptionName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (namespaceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter namespaceName is required and cannot be null."));
        }
        if (topicName == null) {
            return Mono.error(new IllegalArgumentException("Parameter topicName is required and cannot be null."));
        }
        if (eventSubscriptionName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter eventSubscriptionName is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.getDeliveryAttributes(this.client.getEndpoint(),
                this.client.getSubscriptionId(), resourceGroupName, namespaceName, topicName, eventSubscriptionName,
                this.client.getApiVersion(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get delivery attributes for an event subscription of a namespace topic.
     * 
     * Get all delivery attributes for an event subscription of a namespace topic.
     * 
     * @param resourceGroupName The name of the resource group within the user's subscription.
     * @param namespaceName Name of the namespace.
     * @param topicName Name of the namespace topic.
     * @param eventSubscriptionName Name of the event subscription.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all delivery attributes for an event subscription of a namespace topic along with {@link Response} on
     * successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<DeliveryAttributeListResultInner>> getDeliveryAttributesWithResponseAsync(
        String resourceGroupName, String namespaceName, String topicName, String eventSubscriptionName,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (namespaceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter namespaceName is required and cannot be null."));
        }
        if (topicName == null) {
            return Mono.error(new IllegalArgumentException("Parameter topicName is required and cannot be null."));
        }
        if (eventSubscriptionName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter eventSubscriptionName is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.getDeliveryAttributes(this.client.getEndpoint(), this.client.getSubscriptionId(),
            resourceGroupName, namespaceName, topicName, eventSubscriptionName, this.client.getApiVersion(), accept,
            context);
    }

    /**
     * Get delivery attributes for an event subscription of a namespace topic.
     * 
     * Get all delivery attributes for an event subscription of a namespace topic.
     * 
     * @param resourceGroupName The name of the resource group within the user's subscription.
     * @param namespaceName Name of the namespace.
     * @param topicName Name of the namespace topic.
     * @param eventSubscriptionName Name of the event subscription.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all delivery attributes for an event subscription of a namespace topic on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<DeliveryAttributeListResultInner> getDeliveryAttributesAsync(String resourceGroupName,
        String namespaceName, String topicName, String eventSubscriptionName) {
        return getDeliveryAttributesWithResponseAsync(resourceGroupName, namespaceName, topicName,
            eventSubscriptionName).flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Get delivery attributes for an event subscription of a namespace topic.
     * 
     * Get all delivery attributes for an event subscription of a namespace topic.
     * 
     * @param resourceGroupName The name of the resource group within the user's subscription.
     * @param namespaceName Name of the namespace.
     * @param topicName Name of the namespace topic.
     * @param eventSubscriptionName Name of the event subscription.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all delivery attributes for an event subscription of a namespace topic along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<DeliveryAttributeListResultInner> getDeliveryAttributesWithResponse(String resourceGroupName,
        String namespaceName, String topicName, String eventSubscriptionName, Context context) {
        return getDeliveryAttributesWithResponseAsync(resourceGroupName, namespaceName, topicName,
            eventSubscriptionName, context).block();
    }

    /**
     * Get delivery attributes for an event subscription of a namespace topic.
     * 
     * Get all delivery attributes for an event subscription of a namespace topic.
     * 
     * @param resourceGroupName The name of the resource group within the user's subscription.
     * @param namespaceName Name of the namespace.
     * @param topicName Name of the namespace topic.
     * @param eventSubscriptionName Name of the event subscription.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all delivery attributes for an event subscription of a namespace topic.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public DeliveryAttributeListResultInner getDeliveryAttributes(String resourceGroupName, String namespaceName,
        String topicName, String eventSubscriptionName) {
        return getDeliveryAttributesWithResponse(resourceGroupName, namespaceName, topicName, eventSubscriptionName,
            Context.NONE).getValue();
    }

    /**
     * Get full URL of an event subscription of a namespace topic.
     * 
     * Get the full endpoint URL for an event subscription of a namespace topic.
     * 
     * @param resourceGroupName The name of the resource group within the user's subscription.
     * @param namespaceName Name of the namespace.
     * @param topicName Name of the namespace topic.
     * @param eventSubscriptionName Name of the event subscription.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the full endpoint URL for an event subscription of a namespace topic along with {@link Response} on
     * successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<SubscriptionFullUrlInner>> getFullUrlWithResponseAsync(String resourceGroupName,
        String namespaceName, String topicName, String eventSubscriptionName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (namespaceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter namespaceName is required and cannot be null."));
        }
        if (topicName == null) {
            return Mono.error(new IllegalArgumentException("Parameter topicName is required and cannot be null."));
        }
        if (eventSubscriptionName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter eventSubscriptionName is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.getFullUrl(this.client.getEndpoint(), this.client.getSubscriptionId(),
                resourceGroupName, namespaceName, topicName, eventSubscriptionName, this.client.getApiVersion(), accept,
                context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get full URL of an event subscription of a namespace topic.
     * 
     * Get the full endpoint URL for an event subscription of a namespace topic.
     * 
     * @param resourceGroupName The name of the resource group within the user's subscription.
     * @param namespaceName Name of the namespace.
     * @param topicName Name of the namespace topic.
     * @param eventSubscriptionName Name of the event subscription.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the full endpoint URL for an event subscription of a namespace topic along with {@link Response} on
     * successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<SubscriptionFullUrlInner>> getFullUrlWithResponseAsync(String resourceGroupName,
        String namespaceName, String topicName, String eventSubscriptionName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (namespaceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter namespaceName is required and cannot be null."));
        }
        if (topicName == null) {
            return Mono.error(new IllegalArgumentException("Parameter topicName is required and cannot be null."));
        }
        if (eventSubscriptionName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter eventSubscriptionName is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.getFullUrl(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName,
            namespaceName, topicName, eventSubscriptionName, this.client.getApiVersion(), accept, context);
    }

    /**
     * Get full URL of an event subscription of a namespace topic.
     * 
     * Get the full endpoint URL for an event subscription of a namespace topic.
     * 
     * @param resourceGroupName The name of the resource group within the user's subscription.
     * @param namespaceName Name of the namespace.
     * @param topicName Name of the namespace topic.
     * @param eventSubscriptionName Name of the event subscription.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the full endpoint URL for an event subscription of a namespace topic on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<SubscriptionFullUrlInner> getFullUrlAsync(String resourceGroupName, String namespaceName,
        String topicName, String eventSubscriptionName) {
        return getFullUrlWithResponseAsync(resourceGroupName, namespaceName, topicName, eventSubscriptionName)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Get full URL of an event subscription of a namespace topic.
     * 
     * Get the full endpoint URL for an event subscription of a namespace topic.
     * 
     * @param resourceGroupName The name of the resource group within the user's subscription.
     * @param namespaceName Name of the namespace.
     * @param topicName Name of the namespace topic.
     * @param eventSubscriptionName Name of the event subscription.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the full endpoint URL for an event subscription of a namespace topic along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<SubscriptionFullUrlInner> getFullUrlWithResponse(String resourceGroupName, String namespaceName,
        String topicName, String eventSubscriptionName, Context context) {
        return getFullUrlWithResponseAsync(resourceGroupName, namespaceName, topicName, eventSubscriptionName, context)
            .block();
    }

    /**
     * Get full URL of an event subscription of a namespace topic.
     * 
     * Get the full endpoint URL for an event subscription of a namespace topic.
     * 
     * @param resourceGroupName The name of the resource group within the user's subscription.
     * @param namespaceName Name of the namespace.
     * @param topicName Name of the namespace topic.
     * @param eventSubscriptionName Name of the event subscription.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the full endpoint URL for an event subscription of a namespace topic.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public SubscriptionFullUrlInner getFullUrl(String resourceGroupName, String namespaceName, String topicName,
        String eventSubscriptionName) {
        return getFullUrlWithResponse(resourceGroupName, namespaceName, topicName, eventSubscriptionName, Context.NONE)
            .getValue();
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of the List event subscriptions operation along with {@link PagedResponse} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<SubscriptionInner>> listByNamespaceTopicNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context -> service.listByNamespaceTopicNext(nextLink, this.client.getEndpoint(), accept, context))
            .<PagedResponse<SubscriptionInner>>map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(),
                res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of the List event subscriptions operation along with {@link PagedResponse} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<SubscriptionInner>> listByNamespaceTopicNextSinglePageAsync(String nextLink,
        Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.listByNamespaceTopicNext(nextLink, this.client.getEndpoint(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }
}
