// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.eventgrid.implementation;

import com.azure.core.management.SystemData;
import com.azure.resourcemanager.eventgrid.fluent.models.PartnerConfigurationInner;
import com.azure.resourcemanager.eventgrid.models.PartnerAuthorization;
import com.azure.resourcemanager.eventgrid.models.PartnerConfiguration;
import com.azure.resourcemanager.eventgrid.models.PartnerConfigurationProvisioningState;
import java.util.Collections;
import java.util.Map;

public final class PartnerConfigurationImpl implements PartnerConfiguration {
    private PartnerConfigurationInner innerObject;

    private final com.azure.resourcemanager.eventgrid.EventGridManager serviceManager;

    PartnerConfigurationImpl(PartnerConfigurationInner innerObject,
        com.azure.resourcemanager.eventgrid.EventGridManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
    }

    public String id() {
        return this.innerModel().id();
    }

    public String name() {
        return this.innerModel().name();
    }

    public String type() {
        return this.innerModel().type();
    }

    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    public String location() {
        return this.innerModel().location();
    }

    public Map<String, String> tags() {
        Map<String, String> inner = this.innerModel().tags();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        } else {
            return Collections.emptyMap();
        }
    }

    public PartnerAuthorization partnerAuthorization() {
        return this.innerModel().partnerAuthorization();
    }

    public PartnerConfigurationProvisioningState provisioningState() {
        return this.innerModel().provisioningState();
    }

    public PartnerConfigurationInner innerModel() {
        return this.innerObject;
    }

    private com.azure.resourcemanager.eventgrid.EventGridManager manager() {
        return this.serviceManager;
    }
}
