// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.eventgrid.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.eventgrid.fluent.PartnerConfigurationsClient;
import com.azure.resourcemanager.eventgrid.fluent.models.PartnerConfigurationInner;
import com.azure.resourcemanager.eventgrid.models.Partner;
import com.azure.resourcemanager.eventgrid.models.PartnerConfiguration;
import com.azure.resourcemanager.eventgrid.models.PartnerConfigurationUpdateParameters;
import com.azure.resourcemanager.eventgrid.models.PartnerConfigurations;

public final class PartnerConfigurationsImpl implements PartnerConfigurations {
    private static final ClientLogger LOGGER = new ClientLogger(PartnerConfigurationsImpl.class);

    private final PartnerConfigurationsClient innerClient;

    private final com.azure.resourcemanager.eventgrid.EventGridManager serviceManager;

    public PartnerConfigurationsImpl(PartnerConfigurationsClient innerClient,
        com.azure.resourcemanager.eventgrid.EventGridManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    public Response<PartnerConfiguration> getByResourceGroupWithResponse(String resourceGroupName, Context context) {
        Response<PartnerConfigurationInner> inner
            = this.serviceClient().getByResourceGroupWithResponse(resourceGroupName, context);
        if (inner != null) {
            return new SimpleResponse<>(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(),
                new PartnerConfigurationImpl(inner.getValue(), this.manager()));
        } else {
            return null;
        }
    }

    public PartnerConfiguration getByResourceGroup(String resourceGroupName) {
        PartnerConfigurationInner inner = this.serviceClient().getByResourceGroup(resourceGroupName);
        if (inner != null) {
            return new PartnerConfigurationImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public PartnerConfiguration createOrUpdate(String resourceGroupName,
        PartnerConfigurationInner partnerConfigurationInfo) {
        PartnerConfigurationInner inner
            = this.serviceClient().createOrUpdate(resourceGroupName, partnerConfigurationInfo);
        if (inner != null) {
            return new PartnerConfigurationImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public PartnerConfiguration createOrUpdate(String resourceGroupName,
        PartnerConfigurationInner partnerConfigurationInfo, Context context) {
        PartnerConfigurationInner inner
            = this.serviceClient().createOrUpdate(resourceGroupName, partnerConfigurationInfo, context);
        if (inner != null) {
            return new PartnerConfigurationImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public void delete(String resourceGroupName) {
        this.serviceClient().delete(resourceGroupName);
    }

    public void delete(String resourceGroupName, Context context) {
        this.serviceClient().delete(resourceGroupName, context);
    }

    public PartnerConfiguration update(String resourceGroupName,
        PartnerConfigurationUpdateParameters partnerConfigurationUpdateParameters) {
        PartnerConfigurationInner inner
            = this.serviceClient().update(resourceGroupName, partnerConfigurationUpdateParameters);
        if (inner != null) {
            return new PartnerConfigurationImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public PartnerConfiguration update(String resourceGroupName,
        PartnerConfigurationUpdateParameters partnerConfigurationUpdateParameters, Context context) {
        PartnerConfigurationInner inner
            = this.serviceClient().update(resourceGroupName, partnerConfigurationUpdateParameters, context);
        if (inner != null) {
            return new PartnerConfigurationImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public PagedIterable<PartnerConfiguration> listByResourceGroup(String resourceGroupName) {
        PagedIterable<PartnerConfigurationInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new PartnerConfigurationImpl(inner1, this.manager()));
    }

    public PagedIterable<PartnerConfiguration> listByResourceGroup(String resourceGroupName, Context context) {
        PagedIterable<PartnerConfigurationInner> inner
            = this.serviceClient().listByResourceGroup(resourceGroupName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new PartnerConfigurationImpl(inner1, this.manager()));
    }

    public PagedIterable<PartnerConfiguration> list() {
        PagedIterable<PartnerConfigurationInner> inner = this.serviceClient().list();
        return ResourceManagerUtils.mapPage(inner, inner1 -> new PartnerConfigurationImpl(inner1, this.manager()));
    }

    public PagedIterable<PartnerConfiguration> list(String filter, Integer top, Context context) {
        PagedIterable<PartnerConfigurationInner> inner = this.serviceClient().list(filter, top, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new PartnerConfigurationImpl(inner1, this.manager()));
    }

    public Response<PartnerConfiguration> authorizePartnerWithResponse(String resourceGroupName, Partner partnerInfo,
        Context context) {
        Response<PartnerConfigurationInner> inner
            = this.serviceClient().authorizePartnerWithResponse(resourceGroupName, partnerInfo, context);
        if (inner != null) {
            return new SimpleResponse<>(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(),
                new PartnerConfigurationImpl(inner.getValue(), this.manager()));
        } else {
            return null;
        }
    }

    public PartnerConfiguration authorizePartner(String resourceGroupName, Partner partnerInfo) {
        PartnerConfigurationInner inner = this.serviceClient().authorizePartner(resourceGroupName, partnerInfo);
        if (inner != null) {
            return new PartnerConfigurationImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public Response<PartnerConfiguration> unauthorizePartnerWithResponse(String resourceGroupName, Partner partnerInfo,
        Context context) {
        Response<PartnerConfigurationInner> inner
            = this.serviceClient().unauthorizePartnerWithResponse(resourceGroupName, partnerInfo, context);
        if (inner != null) {
            return new SimpleResponse<>(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(),
                new PartnerConfigurationImpl(inner.getValue(), this.manager()));
        } else {
            return null;
        }
    }

    public PartnerConfiguration unauthorizePartner(String resourceGroupName, Partner partnerInfo) {
        PartnerConfigurationInner inner = this.serviceClient().unauthorizePartner(resourceGroupName, partnerInfo);
        if (inner != null) {
            return new PartnerConfigurationImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    private PartnerConfigurationsClient serviceClient() {
        return this.innerClient;
    }

    private com.azure.resourcemanager.eventgrid.EventGridManager manager() {
        return this.serviceManager;
    }
}
