// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.eventgrid.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.eventgrid.fluent.PermissionBindingsClient;
import com.azure.resourcemanager.eventgrid.fluent.models.PermissionBindingInner;
import com.azure.resourcemanager.eventgrid.models.PermissionBinding;
import com.azure.resourcemanager.eventgrid.models.PermissionBindings;

public final class PermissionBindingsImpl implements PermissionBindings {
    private static final ClientLogger LOGGER = new ClientLogger(PermissionBindingsImpl.class);

    private final PermissionBindingsClient innerClient;

    private final com.azure.resourcemanager.eventgrid.EventGridManager serviceManager;

    public PermissionBindingsImpl(PermissionBindingsClient innerClient,
        com.azure.resourcemanager.eventgrid.EventGridManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    public Response<PermissionBinding> getWithResponse(String resourceGroupName, String namespaceName,
        String permissionBindingName, Context context) {
        Response<PermissionBindingInner> inner
            = this.serviceClient().getWithResponse(resourceGroupName, namespaceName, permissionBindingName, context);
        if (inner != null) {
            return new SimpleResponse<>(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(),
                new PermissionBindingImpl(inner.getValue(), this.manager()));
        } else {
            return null;
        }
    }

    public PermissionBinding get(String resourceGroupName, String namespaceName, String permissionBindingName) {
        PermissionBindingInner inner
            = this.serviceClient().get(resourceGroupName, namespaceName, permissionBindingName);
        if (inner != null) {
            return new PermissionBindingImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public void delete(String resourceGroupName, String namespaceName, String permissionBindingName) {
        this.serviceClient().delete(resourceGroupName, namespaceName, permissionBindingName);
    }

    public void delete(String resourceGroupName, String namespaceName, String permissionBindingName, Context context) {
        this.serviceClient().delete(resourceGroupName, namespaceName, permissionBindingName, context);
    }

    public PagedIterable<PermissionBinding> listByNamespace(String resourceGroupName, String namespaceName) {
        PagedIterable<PermissionBindingInner> inner
            = this.serviceClient().listByNamespace(resourceGroupName, namespaceName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new PermissionBindingImpl(inner1, this.manager()));
    }

    public PagedIterable<PermissionBinding> listByNamespace(String resourceGroupName, String namespaceName,
        String filter, Integer top, Context context) {
        PagedIterable<PermissionBindingInner> inner
            = this.serviceClient().listByNamespace(resourceGroupName, namespaceName, filter, top, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new PermissionBindingImpl(inner1, this.manager()));
    }

    public PermissionBinding getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String namespaceName = ResourceManagerUtils.getValueFromIdByName(id, "namespaces");
        if (namespaceName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'namespaces'.", id)));
        }
        String permissionBindingName = ResourceManagerUtils.getValueFromIdByName(id, "permissionBindings");
        if (permissionBindingName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'permissionBindings'.", id)));
        }
        return this.getWithResponse(resourceGroupName, namespaceName, permissionBindingName, Context.NONE).getValue();
    }

    public Response<PermissionBinding> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String namespaceName = ResourceManagerUtils.getValueFromIdByName(id, "namespaces");
        if (namespaceName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'namespaces'.", id)));
        }
        String permissionBindingName = ResourceManagerUtils.getValueFromIdByName(id, "permissionBindings");
        if (permissionBindingName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'permissionBindings'.", id)));
        }
        return this.getWithResponse(resourceGroupName, namespaceName, permissionBindingName, context);
    }

    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String namespaceName = ResourceManagerUtils.getValueFromIdByName(id, "namespaces");
        if (namespaceName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'namespaces'.", id)));
        }
        String permissionBindingName = ResourceManagerUtils.getValueFromIdByName(id, "permissionBindings");
        if (permissionBindingName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'permissionBindings'.", id)));
        }
        this.delete(resourceGroupName, namespaceName, permissionBindingName, Context.NONE);
    }

    public void deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String namespaceName = ResourceManagerUtils.getValueFromIdByName(id, "namespaces");
        if (namespaceName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'namespaces'.", id)));
        }
        String permissionBindingName = ResourceManagerUtils.getValueFromIdByName(id, "permissionBindings");
        if (permissionBindingName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'permissionBindings'.", id)));
        }
        this.delete(resourceGroupName, namespaceName, permissionBindingName, context);
    }

    private PermissionBindingsClient serviceClient() {
        return this.innerClient;
    }

    private com.azure.resourcemanager.eventgrid.EventGridManager manager() {
        return this.serviceManager;
    }

    public PermissionBindingImpl define(String name) {
        return new PermissionBindingImpl(name, this.manager());
    }
}
