// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.eventgrid.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.eventgrid.fluent.TopicSpacesClient;
import com.azure.resourcemanager.eventgrid.fluent.models.TopicSpaceInner;
import com.azure.resourcemanager.eventgrid.models.TopicSpace;
import com.azure.resourcemanager.eventgrid.models.TopicSpaces;

public final class TopicSpacesImpl implements TopicSpaces {
    private static final ClientLogger LOGGER = new ClientLogger(TopicSpacesImpl.class);

    private final TopicSpacesClient innerClient;

    private final com.azure.resourcemanager.eventgrid.EventGridManager serviceManager;

    public TopicSpacesImpl(TopicSpacesClient innerClient,
        com.azure.resourcemanager.eventgrid.EventGridManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    public Response<TopicSpace> getWithResponse(String resourceGroupName, String namespaceName, String topicSpaceName,
        Context context) {
        Response<TopicSpaceInner> inner
            = this.serviceClient().getWithResponse(resourceGroupName, namespaceName, topicSpaceName, context);
        if (inner != null) {
            return new SimpleResponse<>(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(),
                new TopicSpaceImpl(inner.getValue(), this.manager()));
        } else {
            return null;
        }
    }

    public TopicSpace get(String resourceGroupName, String namespaceName, String topicSpaceName) {
        TopicSpaceInner inner = this.serviceClient().get(resourceGroupName, namespaceName, topicSpaceName);
        if (inner != null) {
            return new TopicSpaceImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public void delete(String resourceGroupName, String namespaceName, String topicSpaceName) {
        this.serviceClient().delete(resourceGroupName, namespaceName, topicSpaceName);
    }

    public void delete(String resourceGroupName, String namespaceName, String topicSpaceName, Context context) {
        this.serviceClient().delete(resourceGroupName, namespaceName, topicSpaceName, context);
    }

    public PagedIterable<TopicSpace> listByNamespace(String resourceGroupName, String namespaceName) {
        PagedIterable<TopicSpaceInner> inner = this.serviceClient().listByNamespace(resourceGroupName, namespaceName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new TopicSpaceImpl(inner1, this.manager()));
    }

    public PagedIterable<TopicSpace> listByNamespace(String resourceGroupName, String namespaceName, String filter,
        Integer top, Context context) {
        PagedIterable<TopicSpaceInner> inner
            = this.serviceClient().listByNamespace(resourceGroupName, namespaceName, filter, top, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new TopicSpaceImpl(inner1, this.manager()));
    }

    public TopicSpace getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String namespaceName = ResourceManagerUtils.getValueFromIdByName(id, "namespaces");
        if (namespaceName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'namespaces'.", id)));
        }
        String topicSpaceName = ResourceManagerUtils.getValueFromIdByName(id, "topicSpaces");
        if (topicSpaceName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'topicSpaces'.", id)));
        }
        return this.getWithResponse(resourceGroupName, namespaceName, topicSpaceName, Context.NONE).getValue();
    }

    public Response<TopicSpace> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String namespaceName = ResourceManagerUtils.getValueFromIdByName(id, "namespaces");
        if (namespaceName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'namespaces'.", id)));
        }
        String topicSpaceName = ResourceManagerUtils.getValueFromIdByName(id, "topicSpaces");
        if (topicSpaceName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'topicSpaces'.", id)));
        }
        return this.getWithResponse(resourceGroupName, namespaceName, topicSpaceName, context);
    }

    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String namespaceName = ResourceManagerUtils.getValueFromIdByName(id, "namespaces");
        if (namespaceName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'namespaces'.", id)));
        }
        String topicSpaceName = ResourceManagerUtils.getValueFromIdByName(id, "topicSpaces");
        if (topicSpaceName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'topicSpaces'.", id)));
        }
        this.delete(resourceGroupName, namespaceName, topicSpaceName, Context.NONE);
    }

    public void deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String namespaceName = ResourceManagerUtils.getValueFromIdByName(id, "namespaces");
        if (namespaceName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'namespaces'.", id)));
        }
        String topicSpaceName = ResourceManagerUtils.getValueFromIdByName(id, "topicSpaces");
        if (topicSpaceName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'topicSpaces'.", id)));
        }
        this.delete(resourceGroupName, namespaceName, topicSpaceName, context);
    }

    private TopicSpacesClient serviceClient() {
        return this.innerClient;
    }

    private com.azure.resourcemanager.eventgrid.EventGridManager manager() {
        return this.serviceManager;
    }

    public TopicSpaceImpl define(String name) {
        return new TopicSpaceImpl(name, this.manager());
    }
}
