// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.eventgrid.implementation;

import com.azure.resourcemanager.eventgrid.fluent.models.TopicTypeInfoInner;
import com.azure.resourcemanager.eventgrid.models.ResourceRegionType;
import com.azure.resourcemanager.eventgrid.models.TopicTypeAdditionalEnforcedPermission;
import com.azure.resourcemanager.eventgrid.models.TopicTypeInfo;
import com.azure.resourcemanager.eventgrid.models.TopicTypeProvisioningState;
import com.azure.resourcemanager.eventgrid.models.TopicTypeSourceScope;
import java.util.Collections;
import java.util.List;

public final class TopicTypeInfoImpl implements TopicTypeInfo {
    private TopicTypeInfoInner innerObject;

    private final com.azure.resourcemanager.eventgrid.EventGridManager serviceManager;

    TopicTypeInfoImpl(TopicTypeInfoInner innerObject,
        com.azure.resourcemanager.eventgrid.EventGridManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
    }

    public String id() {
        return this.innerModel().id();
    }

    public String name() {
        return this.innerModel().name();
    }

    public String type() {
        return this.innerModel().type();
    }

    public String provider() {
        return this.innerModel().provider();
    }

    public String displayName() {
        return this.innerModel().displayName();
    }

    public String description() {
        return this.innerModel().description();
    }

    public ResourceRegionType resourceRegionType() {
        return this.innerModel().resourceRegionType();
    }

    public TopicTypeProvisioningState provisioningState() {
        return this.innerModel().provisioningState();
    }

    public List<String> supportedLocations() {
        List<String> inner = this.innerModel().supportedLocations();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        } else {
            return Collections.emptyList();
        }
    }

    public String sourceResourceFormat() {
        return this.innerModel().sourceResourceFormat();
    }

    public List<TopicTypeSourceScope> supportedScopesForSource() {
        List<TopicTypeSourceScope> inner = this.innerModel().supportedScopesForSource();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        } else {
            return Collections.emptyList();
        }
    }

    public Boolean areRegionalAndGlobalSourcesSupported() {
        return this.innerModel().areRegionalAndGlobalSourcesSupported();
    }

    public List<TopicTypeAdditionalEnforcedPermission> additionalEnforcedPermissions() {
        List<TopicTypeAdditionalEnforcedPermission> inner = this.innerModel().additionalEnforcedPermissions();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        } else {
            return Collections.emptyList();
        }
    }

    public TopicTypeInfoInner innerModel() {
        return this.innerObject;
    }

    private com.azure.resourcemanager.eventgrid.EventGridManager manager() {
        return this.serviceManager;
    }
}
