// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.eventgrid.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * BoolEquals Advanced Filter.
 */
@Fluent
public final class BoolEqualsAdvancedFilter extends AdvancedFilter {
    /*
     * The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals and others.
     */
    private AdvancedFilterOperatorType operatorType = AdvancedFilterOperatorType.BOOL_EQUALS;

    /*
     * The boolean filter value.
     */
    private Boolean value;

    /**
     * Creates an instance of BoolEqualsAdvancedFilter class.
     */
    public BoolEqualsAdvancedFilter() {
    }

    /**
     * Get the operatorType property: The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals
     * and others.
     * 
     * @return the operatorType value.
     */
    @Override
    public AdvancedFilterOperatorType operatorType() {
        return this.operatorType;
    }

    /**
     * Get the value property: The boolean filter value.
     * 
     * @return the value value.
     */
    public Boolean value() {
        return this.value;
    }

    /**
     * Set the value property: The boolean filter value.
     * 
     * @param value the value value to set.
     * @return the BoolEqualsAdvancedFilter object itself.
     */
    public BoolEqualsAdvancedFilter withValue(Boolean value) {
        this.value = value;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public BoolEqualsAdvancedFilter withKey(String key) {
        super.withKey(key);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("key", key());
        jsonWriter.writeStringField("operatorType", this.operatorType == null ? null : this.operatorType.toString());
        jsonWriter.writeBooleanField("value", this.value);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of BoolEqualsAdvancedFilter from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of BoolEqualsAdvancedFilter if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the BoolEqualsAdvancedFilter.
     */
    public static BoolEqualsAdvancedFilter fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            BoolEqualsAdvancedFilter deserializedBoolEqualsAdvancedFilter = new BoolEqualsAdvancedFilter();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("key".equals(fieldName)) {
                    deserializedBoolEqualsAdvancedFilter.withKey(reader.getString());
                } else if ("operatorType".equals(fieldName)) {
                    deserializedBoolEqualsAdvancedFilter.operatorType
                        = AdvancedFilterOperatorType.fromString(reader.getString());
                } else if ("value".equals(fieldName)) {
                    deserializedBoolEqualsAdvancedFilter.value = reader.getNullable(JsonReader::getBoolean);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedBoolEqualsAdvancedFilter;
        });
    }
}
