// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.eventgrid.models;

import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.eventgrid.fluent.models.CaCertificateInner;
import java.time.OffsetDateTime;

/**
 * An immutable client-side representation of CaCertificate.
 */
public interface CaCertificate {
    /**
     * Gets the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    String id();

    /**
     * Gets the name property: The name of the resource.
     * 
     * @return the name value.
     */
    String name();

    /**
     * Gets the type property: The type of the resource.
     * 
     * @return the type value.
     */
    String type();

    /**
     * Gets the systemData property: The system metadata relating to the Event Grid resource.
     * 
     * @return the systemData value.
     */
    SystemData systemData();

    /**
     * Gets the description property: Description for the CA Certificate resource.
     * 
     * @return the description value.
     */
    String description();

    /**
     * Gets the encodedCertificate property: Base64 encoded PEM (Privacy Enhanced Mail) format certificate data.
     * 
     * @return the encodedCertificate value.
     */
    String encodedCertificate();

    /**
     * Gets the issueTimeInUtc property: Certificate issue time in UTC. This is a read-only field.
     * 
     * @return the issueTimeInUtc value.
     */
    OffsetDateTime issueTimeInUtc();

    /**
     * Gets the expiryTimeInUtc property: Certificate expiry time in UTC. This is a read-only field.
     * 
     * @return the expiryTimeInUtc value.
     */
    OffsetDateTime expiryTimeInUtc();

    /**
     * Gets the provisioningState property: Provisioning state of the CA Certificate resource.
     * 
     * @return the provisioningState value.
     */
    CaCertificateProvisioningState provisioningState();

    /**
     * Gets the name of the resource group.
     * 
     * @return the name of the resource group.
     */
    String resourceGroupName();

    /**
     * Gets the inner com.azure.resourcemanager.eventgrid.fluent.models.CaCertificateInner object.
     * 
     * @return the inner object.
     */
    CaCertificateInner innerModel();

    /**
     * The entirety of the CaCertificate definition.
     */
    interface Definition
        extends DefinitionStages.Blank, DefinitionStages.WithParentResource, DefinitionStages.WithCreate {
    }

    /**
     * The CaCertificate definition stages.
     */
    interface DefinitionStages {
        /**
         * The first stage of the CaCertificate definition.
         */
        interface Blank extends WithParentResource {
        }

        /**
         * The stage of the CaCertificate definition allowing to specify parent resource.
         */
        interface WithParentResource {
            /**
             * Specifies resourceGroupName, namespaceName.
             * 
             * @param resourceGroupName The name of the resource group within the user's subscription.
             * @param namespaceName Name of the namespace.
             * @return the next definition stage.
             */
            WithCreate withExistingNamespace(String resourceGroupName, String namespaceName);
        }

        /**
         * The stage of the CaCertificate definition which contains all the minimum required properties for the resource
         * to be created, but also allows for any other optional properties to be specified.
         */
        interface WithCreate extends DefinitionStages.WithDescription, DefinitionStages.WithEncodedCertificate {
            /**
             * Executes the create request.
             * 
             * @return the created resource.
             */
            CaCertificate create();

            /**
             * Executes the create request.
             * 
             * @param context The context to associate with this operation.
             * @return the created resource.
             */
            CaCertificate create(Context context);
        }

        /**
         * The stage of the CaCertificate definition allowing to specify description.
         */
        interface WithDescription {
            /**
             * Specifies the description property: Description for the CA Certificate resource..
             * 
             * @param description Description for the CA Certificate resource.
             * @return the next definition stage.
             */
            WithCreate withDescription(String description);
        }

        /**
         * The stage of the CaCertificate definition allowing to specify encodedCertificate.
         */
        interface WithEncodedCertificate {
            /**
             * Specifies the encodedCertificate property: Base64 encoded PEM (Privacy Enhanced Mail) format certificate
             * data..
             * 
             * @param encodedCertificate Base64 encoded PEM (Privacy Enhanced Mail) format certificate data.
             * @return the next definition stage.
             */
            WithCreate withEncodedCertificate(String encodedCertificate);
        }
    }

    /**
     * Begins update for the CaCertificate resource.
     * 
     * @return the stage of resource update.
     */
    CaCertificate.Update update();

    /**
     * The template for CaCertificate update.
     */
    interface Update extends UpdateStages.WithDescription, UpdateStages.WithEncodedCertificate {
        /**
         * Executes the update request.
         * 
         * @return the updated resource.
         */
        CaCertificate apply();

        /**
         * Executes the update request.
         * 
         * @param context The context to associate with this operation.
         * @return the updated resource.
         */
        CaCertificate apply(Context context);
    }

    /**
     * The CaCertificate update stages.
     */
    interface UpdateStages {
        /**
         * The stage of the CaCertificate update allowing to specify description.
         */
        interface WithDescription {
            /**
             * Specifies the description property: Description for the CA Certificate resource..
             * 
             * @param description Description for the CA Certificate resource.
             * @return the next definition stage.
             */
            Update withDescription(String description);
        }

        /**
         * The stage of the CaCertificate update allowing to specify encodedCertificate.
         */
        interface WithEncodedCertificate {
            /**
             * Specifies the encodedCertificate property: Base64 encoded PEM (Privacy Enhanced Mail) format certificate
             * data..
             * 
             * @param encodedCertificate Base64 encoded PEM (Privacy Enhanced Mail) format certificate data.
             * @return the next definition stage.
             */
            Update withEncodedCertificate(String encodedCertificate);
        }
    }

    /**
     * Refreshes the resource to sync with Azure.
     * 
     * @return the refreshed resource.
     */
    CaCertificate refresh();

    /**
     * Refreshes the resource to sync with Azure.
     * 
     * @param context The context to associate with this operation.
     * @return the refreshed resource.
     */
    CaCertificate refresh(Context context);
}
