// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.eventgrid.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * Provisioning state of the CA Certificate resource.
 */
public final class CaCertificateProvisioningState extends ExpandableStringEnum<CaCertificateProvisioningState> {
    /**
     * Static value Creating for CaCertificateProvisioningState.
     */
    public static final CaCertificateProvisioningState CREATING = fromString("Creating");

    /**
     * Static value Updating for CaCertificateProvisioningState.
     */
    public static final CaCertificateProvisioningState UPDATING = fromString("Updating");

    /**
     * Static value Deleting for CaCertificateProvisioningState.
     */
    public static final CaCertificateProvisioningState DELETING = fromString("Deleting");

    /**
     * Static value Succeeded for CaCertificateProvisioningState.
     */
    public static final CaCertificateProvisioningState SUCCEEDED = fromString("Succeeded");

    /**
     * Static value Canceled for CaCertificateProvisioningState.
     */
    public static final CaCertificateProvisioningState CANCELED = fromString("Canceled");

    /**
     * Static value Failed for CaCertificateProvisioningState.
     */
    public static final CaCertificateProvisioningState FAILED = fromString("Failed");

    /**
     * Static value Deleted for CaCertificateProvisioningState.
     */
    public static final CaCertificateProvisioningState DELETED = fromString("Deleted");

    /**
     * Creates a new instance of CaCertificateProvisioningState value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public CaCertificateProvisioningState() {
    }

    /**
     * Creates or finds a CaCertificateProvisioningState from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding CaCertificateProvisioningState.
     */
    public static CaCertificateProvisioningState fromString(String name) {
        return fromString(name, CaCertificateProvisioningState.class);
    }

    /**
     * Gets known CaCertificateProvisioningState values.
     * 
     * @return known CaCertificateProvisioningState values.
     */
    public static Collection<CaCertificateProvisioningState> values() {
        return values(CaCertificateProvisioningState.class);
    }
}
