// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.eventgrid.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventgrid.fluent.models.CaCertificateInner;
import java.io.IOException;
import java.util.List;

/**
 * Result of the List CA Certificate operation.
 */
@Fluent
public final class CaCertificatesListResult implements JsonSerializable<CaCertificatesListResult> {
    /*
     * A collection of CA Certificate.
     */
    private List<CaCertificateInner> value;

    /*
     * A link for the next page of CA Certificate.
     */
    private String nextLink;

    /**
     * Creates an instance of CaCertificatesListResult class.
     */
    public CaCertificatesListResult() {
    }

    /**
     * Get the value property: A collection of CA Certificate.
     * 
     * @return the value value.
     */
    public List<CaCertificateInner> value() {
        return this.value;
    }

    /**
     * Set the value property: A collection of CA Certificate.
     * 
     * @param value the value value to set.
     * @return the CaCertificatesListResult object itself.
     */
    public CaCertificatesListResult withValue(List<CaCertificateInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: A link for the next page of CA Certificate.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: A link for the next page of CA Certificate.
     * 
     * @param nextLink the nextLink value to set.
     * @return the CaCertificatesListResult object itself.
     */
    public CaCertificatesListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of CaCertificatesListResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of CaCertificatesListResult if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the CaCertificatesListResult.
     */
    public static CaCertificatesListResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            CaCertificatesListResult deserializedCaCertificatesListResult = new CaCertificatesListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<CaCertificateInner> value = reader.readArray(reader1 -> CaCertificateInner.fromJson(reader1));
                    deserializedCaCertificatesListResult.value = value;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedCaCertificatesListResult.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedCaCertificatesListResult;
        });
    }
}
