// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.eventgrid.models;

import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.eventgrid.fluent.models.ClientInner;
import java.util.Map;

/**
 * An immutable client-side representation of Client.
 */
public interface Client {
    /**
     * Gets the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    String id();

    /**
     * Gets the name property: The name of the resource.
     * 
     * @return the name value.
     */
    String name();

    /**
     * Gets the type property: The type of the resource.
     * 
     * @return the type value.
     */
    String type();

    /**
     * Gets the systemData property: The system metadata relating to the Event Grid resource.
     * 
     * @return the systemData value.
     */
    SystemData systemData();

    /**
     * Gets the description property: Description for the Client resource.
     * 
     * @return the description value.
     */
    String description();

    /**
     * Gets the authenticationName property: The name presented by the client for authentication. The default value is
     * the name of the resource.
     * 
     * @return the authenticationName value.
     */
    String authenticationName();

    /**
     * Gets the clientCertificateAuthentication property: The client certificate authentication information.
     * 
     * @return the clientCertificateAuthentication value.
     */
    ClientCertificateAuthentication clientCertificateAuthentication();

    /**
     * Gets the state property: Indicates if the client is enabled or not. Default value is Enabled.
     * 
     * @return the state value.
     */
    ClientState state();

    /**
     * Gets the attributes property: Attributes for the client. Supported values are int, bool, string, string[].
     * Example:
     * "attributes": { "room": "345", "floor": 12, "deviceTypes": ["Fan", "Light"] }.
     * 
     * @return the attributes value.
     */
    Map<String, Object> attributes();

    /**
     * Gets the provisioningState property: Provisioning state of the Client resource.
     * 
     * @return the provisioningState value.
     */
    ClientProvisioningState provisioningState();

    /**
     * Gets the name of the resource group.
     * 
     * @return the name of the resource group.
     */
    String resourceGroupName();

    /**
     * Gets the inner com.azure.resourcemanager.eventgrid.fluent.models.ClientInner object.
     * 
     * @return the inner object.
     */
    ClientInner innerModel();

    /**
     * The entirety of the Client definition.
     */
    interface Definition
        extends DefinitionStages.Blank, DefinitionStages.WithParentResource, DefinitionStages.WithCreate {
    }

    /**
     * The Client definition stages.
     */
    interface DefinitionStages {
        /**
         * The first stage of the Client definition.
         */
        interface Blank extends WithParentResource {
        }

        /**
         * The stage of the Client definition allowing to specify parent resource.
         */
        interface WithParentResource {
            /**
             * Specifies resourceGroupName, namespaceName.
             * 
             * @param resourceGroupName The name of the resource group within the user's subscription.
             * @param namespaceName Name of the namespace.
             * @return the next definition stage.
             */
            WithCreate withExistingNamespace(String resourceGroupName, String namespaceName);
        }

        /**
         * The stage of the Client definition which contains all the minimum required properties for the resource to be
         * created, but also allows for any other optional properties to be specified.
         */
        interface WithCreate extends DefinitionStages.WithDescription, DefinitionStages.WithAuthenticationName,
            DefinitionStages.WithClientCertificateAuthentication, DefinitionStages.WithState,
            DefinitionStages.WithAttributes {
            /**
             * Executes the create request.
             * 
             * @return the created resource.
             */
            Client create();

            /**
             * Executes the create request.
             * 
             * @param context The context to associate with this operation.
             * @return the created resource.
             */
            Client create(Context context);
        }

        /**
         * The stage of the Client definition allowing to specify description.
         */
        interface WithDescription {
            /**
             * Specifies the description property: Description for the Client resource..
             * 
             * @param description Description for the Client resource.
             * @return the next definition stage.
             */
            WithCreate withDescription(String description);
        }

        /**
         * The stage of the Client definition allowing to specify authenticationName.
         */
        interface WithAuthenticationName {
            /**
             * Specifies the authenticationName property: The name presented by the client for authentication. The
             * default value is the name of the resource..
             * 
             * @param authenticationName The name presented by the client for authentication. The default value is the
             * name of the resource.
             * @return the next definition stage.
             */
            WithCreate withAuthenticationName(String authenticationName);
        }

        /**
         * The stage of the Client definition allowing to specify clientCertificateAuthentication.
         */
        interface WithClientCertificateAuthentication {
            /**
             * Specifies the clientCertificateAuthentication property: The client certificate authentication
             * information..
             * 
             * @param clientCertificateAuthentication The client certificate authentication information.
             * @return the next definition stage.
             */
            WithCreate
                withClientCertificateAuthentication(ClientCertificateAuthentication clientCertificateAuthentication);
        }

        /**
         * The stage of the Client definition allowing to specify state.
         */
        interface WithState {
            /**
             * Specifies the state property: Indicates if the client is enabled or not. Default value is Enabled..
             * 
             * @param state Indicates if the client is enabled or not. Default value is Enabled.
             * @return the next definition stage.
             */
            WithCreate withState(ClientState state);
        }

        /**
         * The stage of the Client definition allowing to specify attributes.
         */
        interface WithAttributes {
            /**
             * Specifies the attributes property: Attributes for the client. Supported values are int, bool, string,
             * string[].
             * Example:
             * "attributes": { "room": "345", "floor": 12, "deviceTypes": ["Fan", "Light"] }.
             * 
             * @param attributes Attributes for the client. Supported values are int, bool, string, string[].
             * Example:
             * "attributes": { "room": "345", "floor": 12, "deviceTypes": ["Fan", "Light"] }.
             * @return the next definition stage.
             */
            WithCreate withAttributes(Map<String, Object> attributes);
        }
    }

    /**
     * Begins update for the Client resource.
     * 
     * @return the stage of resource update.
     */
    Client.Update update();

    /**
     * The template for Client update.
     */
    interface Update extends UpdateStages.WithDescription, UpdateStages.WithAuthenticationName,
        UpdateStages.WithClientCertificateAuthentication, UpdateStages.WithState, UpdateStages.WithAttributes {
        /**
         * Executes the update request.
         * 
         * @return the updated resource.
         */
        Client apply();

        /**
         * Executes the update request.
         * 
         * @param context The context to associate with this operation.
         * @return the updated resource.
         */
        Client apply(Context context);
    }

    /**
     * The Client update stages.
     */
    interface UpdateStages {
        /**
         * The stage of the Client update allowing to specify description.
         */
        interface WithDescription {
            /**
             * Specifies the description property: Description for the Client resource..
             * 
             * @param description Description for the Client resource.
             * @return the next definition stage.
             */
            Update withDescription(String description);
        }

        /**
         * The stage of the Client update allowing to specify authenticationName.
         */
        interface WithAuthenticationName {
            /**
             * Specifies the authenticationName property: The name presented by the client for authentication. The
             * default value is the name of the resource..
             * 
             * @param authenticationName The name presented by the client for authentication. The default value is the
             * name of the resource.
             * @return the next definition stage.
             */
            Update withAuthenticationName(String authenticationName);
        }

        /**
         * The stage of the Client update allowing to specify clientCertificateAuthentication.
         */
        interface WithClientCertificateAuthentication {
            /**
             * Specifies the clientCertificateAuthentication property: The client certificate authentication
             * information..
             * 
             * @param clientCertificateAuthentication The client certificate authentication information.
             * @return the next definition stage.
             */
            Update withClientCertificateAuthentication(ClientCertificateAuthentication clientCertificateAuthentication);
        }

        /**
         * The stage of the Client update allowing to specify state.
         */
        interface WithState {
            /**
             * Specifies the state property: Indicates if the client is enabled or not. Default value is Enabled..
             * 
             * @param state Indicates if the client is enabled or not. Default value is Enabled.
             * @return the next definition stage.
             */
            Update withState(ClientState state);
        }

        /**
         * The stage of the Client update allowing to specify attributes.
         */
        interface WithAttributes {
            /**
             * Specifies the attributes property: Attributes for the client. Supported values are int, bool, string,
             * string[].
             * Example:
             * "attributes": { "room": "345", "floor": 12, "deviceTypes": ["Fan", "Light"] }.
             * 
             * @param attributes Attributes for the client. Supported values are int, bool, string, string[].
             * Example:
             * "attributes": { "room": "345", "floor": 12, "deviceTypes": ["Fan", "Light"] }.
             * @return the next definition stage.
             */
            Update withAttributes(Map<String, Object> attributes);
        }
    }

    /**
     * Refreshes the resource to sync with Azure.
     * 
     * @return the refreshed resource.
     */
    Client refresh();

    /**
     * Refreshes the resource to sync with Azure.
     * 
     * @param context The context to associate with this operation.
     * @return the refreshed resource.
     */
    Client refresh(Context context);
}
