// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.eventgrid.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * The certificate authentication properties for the client.
 */
@Fluent
public final class ClientCertificateAuthentication implements JsonSerializable<ClientCertificateAuthentication> {
    /*
     * The validation scheme used to authenticate the client. Default value is SubjectMatchesAuthenticationName.
     */
    private ClientCertificateValidationScheme validationScheme;

    /*
     * The list of thumbprints that are allowed during client authentication. This property is required only if the
     * validationScheme is 'ThumbprintMatch'.
     */
    private List<String> allowedThumbprints;

    /**
     * Creates an instance of ClientCertificateAuthentication class.
     */
    public ClientCertificateAuthentication() {
    }

    /**
     * Get the validationScheme property: The validation scheme used to authenticate the client. Default value is
     * SubjectMatchesAuthenticationName.
     * 
     * @return the validationScheme value.
     */
    public ClientCertificateValidationScheme validationScheme() {
        return this.validationScheme;
    }

    /**
     * Set the validationScheme property: The validation scheme used to authenticate the client. Default value is
     * SubjectMatchesAuthenticationName.
     * 
     * @param validationScheme the validationScheme value to set.
     * @return the ClientCertificateAuthentication object itself.
     */
    public ClientCertificateAuthentication withValidationScheme(ClientCertificateValidationScheme validationScheme) {
        this.validationScheme = validationScheme;
        return this;
    }

    /**
     * Get the allowedThumbprints property: The list of thumbprints that are allowed during client authentication. This
     * property is required only if the validationScheme is 'ThumbprintMatch'.
     * 
     * @return the allowedThumbprints value.
     */
    public List<String> allowedThumbprints() {
        return this.allowedThumbprints;
    }

    /**
     * Set the allowedThumbprints property: The list of thumbprints that are allowed during client authentication. This
     * property is required only if the validationScheme is 'ThumbprintMatch'.
     * 
     * @param allowedThumbprints the allowedThumbprints value to set.
     * @return the ClientCertificateAuthentication object itself.
     */
    public ClientCertificateAuthentication withAllowedThumbprints(List<String> allowedThumbprints) {
        this.allowedThumbprints = allowedThumbprints;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("validationScheme",
            this.validationScheme == null ? null : this.validationScheme.toString());
        jsonWriter.writeArrayField("allowedThumbprints", this.allowedThumbprints,
            (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ClientCertificateAuthentication from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ClientCertificateAuthentication if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ClientCertificateAuthentication.
     */
    public static ClientCertificateAuthentication fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ClientCertificateAuthentication deserializedClientCertificateAuthentication
                = new ClientCertificateAuthentication();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("validationScheme".equals(fieldName)) {
                    deserializedClientCertificateAuthentication.validationScheme
                        = ClientCertificateValidationScheme.fromString(reader.getString());
                } else if ("allowedThumbprints".equals(fieldName)) {
                    List<String> allowedThumbprints = reader.readArray(reader1 -> reader1.getString());
                    deserializedClientCertificateAuthentication.allowedThumbprints = allowedThumbprints;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedClientCertificateAuthentication;
        });
    }
}
